/*
 * Decompiled with CFR 0.152.
 */
package extracells.network;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEPartLocation;
import extracells.ExtraCells;
import extracells.api.IPortableFluidStorageCell;
import extracells.api.IPortableGasStorageCell;
import extracells.api.IWirelessFluidTermHandler;
import extracells.api.IWirelessGasTermHandler;
import extracells.api.gas.IAEGasStack;
import extracells.block.TGuiBlock;
import extracells.container.ContainerStorage;
import extracells.container.fluid.ContainerFluidStorage;
import extracells.container.gas.ContainerGasStorage;
import extracells.gui.GuiStorage;
import extracells.integration.mekanism.gas.MEMonitorFluidGasWrapper;
import extracells.network.IGuiProvider;
import extracells.part.PartECBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Array$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class GuiHandler$
implements IGuiHandler {
    public static final GuiHandler$ MODULE$;
    private Object[] temp;
    private EnumHand hand;

    static {
        new GuiHandler$();
    }

    public Object getContainer(int ID, EntityPlayer player, Object[] args) {
        ContainerStorage containerStorage;
        int n = ID;
        switch (n) {
            default: {
                containerStorage = null;
                break;
            }
            case 6: {
                MEMonitorFluidGasWrapper fluidInventory3 = new MEMonitorFluidGasWrapper((IMEMonitor<IAEGasStack>)((IMEMonitor)args[0]));
                IPortableGasStorageCell storageCell = (IPortableGasStorageCell)args[1];
                containerStorage = new ContainerGasStorage((IMEMonitor<IAEFluidStack>)fluidInventory3, player, storageCell, this.hand());
                break;
            }
            case 5: {
                MEMonitorFluidGasWrapper fluidInventory2 = new MEMonitorFluidGasWrapper((IMEMonitor<IAEGasStack>)((IMEMonitor)args[0]));
                IWirelessGasTermHandler handler = (IWirelessGasTermHandler)args[1];
                containerStorage = new ContainerGasStorage((IMEMonitor<IAEFluidStack>)fluidInventory2, player, handler, this.hand());
                break;
            }
            case 4: {
                MEMonitorFluidGasWrapper fluidInventory = new MEMonitorFluidGasWrapper((IMEMonitor<IAEGasStack>)((IMEMonitor)args[0]));
                containerStorage = new ContainerGasStorage(fluidInventory, player, this.hand());
                break;
            }
            case 3: {
                IMEMonitor fluidInventory3 = (IMEMonitor)args[0];
                IPortableFluidStorageCell storageCell = (IPortableFluidStorageCell)args[1];
                containerStorage = new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory3, player, storageCell, this.hand());
                break;
            }
            case 1: {
                IMEMonitor fluidInventory2 = (IMEMonitor)args[0];
                IWirelessFluidTermHandler handler = (IWirelessFluidTermHandler)args[1];
                containerStorage = new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory2, player, handler, this.hand());
                break;
            }
            case 0: {
                IMEMonitor fluidInventory = (IMEMonitor)args[0];
                containerStorage = new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory, player, this.hand());
            }
        }
        return containerStorage;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getGui(int ID, EntityPlayer player) {
        GuiStorage guiStorage;
        int n = ID;
        switch (n) {
            default: {
                guiStorage = null;
                break;
            }
            case 6: {
                guiStorage = new GuiStorage(new ContainerGasStorage(player, this.hand()), "extracells.item.storage.gas.portable.name");
                break;
            }
            case 5: {
                guiStorage = new GuiStorage(new ContainerGasStorage(player, this.hand()), "extracells.part.gas.terminal.name");
                break;
            }
            case 4: {
                guiStorage = new GuiStorage(new ContainerGasStorage(player, this.hand()), "extracells.part.gas.terminal.name");
                break;
            }
            case 3: {
                guiStorage = new GuiStorage(new ContainerFluidStorage(player, this.hand()), "extracells.item.storage.fluid.portable.name");
                break;
            }
            case 1: {
                guiStorage = new GuiStorage(new ContainerFluidStorage(player, this.hand()), "extracells.part.fluid.terminal.name");
                break;
            }
            case 0: {
                guiStorage = new GuiStorage(new ContainerFluidStorage(player, this.hand()), "extracells.part.fluid.terminal.name");
            }
        }
        return guiStorage;
    }

    public int getGuiId(int guiId) {
        return guiId + 6;
    }

    public int getGuiId(PartECBase part) {
        return part.getFacing().ordinal();
    }

    public Object getPartContainer(EnumFacing side, EntityPlayer player, World world, int x, int y, int z) {
        return ((PartECBase)((IPartHost)world.func_175625_s(new BlockPos(x, y, z))).getPart(side)).getServerGuiElement(player);
    }

    public Object getPartGui(EnumFacing side, EntityPlayer player, World world, int x, int y, int z) {
        return ((PartECBase)((IPartHost)world.func_175625_s(new BlockPos(x, y, z))).getPart(side)).getClientGuiElement(player);
    }

    public void launchGui(int ID, EntityPlayer player, EnumHand hand, Object[] args) {
        this.temp_$eq(args);
        this.hand_$eq(hand);
        player.openGui((Object)ExtraCells.instance, ID, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    public Object launchGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)ExtraCells.instance, ID, world, x, y, z);
        return BoxedUnit.UNIT;
    }

    public boolean hasPermissions(BlockPos pos, AEPartLocation side, EntityPlayer player) {
        IPart part;
        World world = player.func_130014_f_();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return true;
        }
        if (tileEntity instanceof IGuiProvider) {
            return this.securityCheck(tileEntity, player);
        }
        if (tileEntity instanceof IPartHost && (part = ((IPartHost)tileEntity).getPart(side)) != null) {
            return this.securityCheck(part, player);
        }
        return false;
    }

    private boolean securityCheck(Object te, EntityPlayer player) {
        if (te instanceof IActionHost) {
            IGrid g;
            IGridNode gn = ((IActionHost)te).getActionableNode();
            if (gn != null && (g = gn.getGrid()) != null) {
                IEnergyGrid eg;
                boolean requirePower = false;
                if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                    return false;
                }
                ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
                if (sg.hasPermission(player, SecurityPermissions.BUILD)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public Object[] temp() {
        return this.temp;
    }

    public void temp_$eq(Object[] x$1) {
        this.temp = x$1;
    }

    public EnumHand hand() {
        return this.hand;
    }

    public void hand_$eq(EnumHand x$1) {
        this.hand = x$1;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Object gui = this.getGuiBlockElement(player, world, x, y, z);
        if (gui == null) {
            BlockPos pos;
            TileEntity tileEntity;
            EnumFacing side = null;
            if (ID <= 5) {
                side = EnumFacing.func_82600_a((int)ID);
            }
            if ((tileEntity = world.func_175625_s(pos = new BlockPos(x, y, z))) == null) {
                if (ID >= 6) {
                    return this.getGui(ID - 6, player);
                }
                return null;
            }
            if (tileEntity instanceof IGuiProvider) {
                return ((IGuiProvider)tileEntity).getClientGuiElement(player, new Object[0]);
            }
            if (tileEntity instanceof IPartHost) {
                if (world == null || side == null) {
                    if (ID >= 6) {
                        return this.getGui(ID - 6, player);
                    }
                } else {
                    return this.getPartGui(side, player, world, x, y, z);
                }
            }
            return null;
        }
        return gui;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Object con = this.getContainerBlockElement(player, world, x, y, z);
        if (con == null) {
            BlockPos pos;
            TileEntity tileEntity;
            EnumFacing side = null;
            if (ID <= 5) {
                side = EnumFacing.func_82600_a((int)ID);
            }
            if ((tileEntity = world.func_175625_s(pos = new BlockPos(x, y, z))) == null) {
                if (ID >= 6) {
                    return this.getContainer(ID - 6, player, this.temp());
                }
                return null;
            }
            if (tileEntity instanceof IGuiProvider) {
                return ((IGuiProvider)tileEntity).getServerGuiElement(player, new Object[0]);
            }
            if (tileEntity instanceof IPartHost) {
                if (world == null || side == null) {
                    if (ID >= 6) {
                        return this.getContainer(ID - 6, player, this.temp());
                    }
                } else {
                    return this.getPartContainer(side, player, world, x, y, z);
                }
            }
            return null;
        }
        return con;
    }

    public Object getGuiBlockElement(EntityPlayer player, World world, int x, int y, int z) {
        if (world == null || player == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == null) {
            return null;
        }
        Block block2 = block;
        if (block2 instanceof TGuiBlock) {
            Block block3 = block2;
            return ((TGuiBlock)block3).getClientGuiElement(player, world, pos);
        }
        return null;
    }

    public Object getContainerBlockElement(EntityPlayer player, World world, int x, int y, int z) {
        if (world == null || player == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == null) {
            return null;
        }
        Block block2 = block;
        if (block2 instanceof TGuiBlock) {
            Block block3 = block2;
            return ((TGuiBlock)block3).getServerGuiElement(player, world, pos);
        }
        return null;
    }

    private GuiHandler$() {
        MODULE$ = this;
        this.temp = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Any());
        this.hand = null;
    }
}

