/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

public final class BooleanAlgebra {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int NULL = 2;
    public static final double F = 0.0;
    public static final double T = 1.0;
    public static final double N = Double.NaN;
    public static final double[][] AND_TRUTH_TABLE = new double[][]{{0.0, 0.0, 0.0}, {0.0, 1.0, Double.NaN}, {0.0, Double.NaN, Double.NaN}};
    public static final double[][] NAND_TRUTH_TABLE = new double[][]{{1.0, 1.0, 1.0}, {1.0, 0.0, Double.NaN}, {1.0, Double.NaN, Double.NaN}};
    public static final double[][] OR_TRUTH_TABLE = new double[][]{{0.0, 1.0, Double.NaN}, {1.0, 1.0, 1.0}, {Double.NaN, 1.0, Double.NaN}};
    public static final double[][] NOR_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {0.0, 0.0, 0.0}, {Double.NaN, 0.0, Double.NaN}};
    public static final double[][] XOR_TRUTH_TABLE = new double[][]{{0.0, 1.0, Double.NaN}, {1.0, 0.0, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}};
    public static final double[][] XNOR_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {0.0, 1.0, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}};
    public static final double[][] IMP_TRUTH_TABLE = new double[][]{{1.0, 1.0, 1.0}, {0.0, 1.0, Double.NaN}, {Double.NaN, 1.0, Double.NaN}};
    public static final double[][] CIMP_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {1.0, 1.0, 1.0}, {1.0, Double.NaN, Double.NaN}};
    public static final double[][] EQV_TRUTH_TABLE = new double[][]{{1.0, 0.0, Double.NaN}, {0.0, 1.0, Double.NaN}, {Double.NaN, Double.NaN, Double.NaN}};
    public static final double[][] NIMP_TRUTH_TABLE = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, Double.NaN}, {Double.NaN, 0.0, Double.NaN}};
    public static final double[][] CNIMP_TRUTH_TABLE = new double[][]{{0.0, 1.0, Double.NaN}, {0.0, 0.0, 0.0}, {0.0, Double.NaN, Double.NaN}};
    public static final double[] NOT_TRUTH_TABLE = new double[]{1.0, 0.0, Double.NaN};

    public static final int double2IntBoolean(double a) {
        if (Double.isNaN(a)) {
            return 2;
        }
        if (a != 0.0) {
            return 1;
        }
        return 0;
    }

    public static final double and(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return AND_TRUTH_TABLE[A][B];
    }

    public static final double or(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return OR_TRUTH_TABLE[A][B];
    }

    public static final double xor(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return XOR_TRUTH_TABLE[A][B];
    }

    public static final double nand(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return NAND_TRUTH_TABLE[A][B];
    }

    public static final double nor(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return NOR_TRUTH_TABLE[A][B];
    }

    public static final double xnor(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return XNOR_TRUTH_TABLE[A][B];
    }

    public static final double imp(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return IMP_TRUTH_TABLE[A][B];
    }

    public static final double eqv(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return EQV_TRUTH_TABLE[A][B];
    }

    public static final double not(double a) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        return NOT_TRUTH_TABLE[A];
    }

    public static final double cimp(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return CIMP_TRUTH_TABLE[A][B];
    }

    public static final double nimp(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return NIMP_TRUTH_TABLE[A][B];
    }

    public static final double cnimp(double a, double b) {
        int A = BooleanAlgebra.double2IntBoolean(a);
        int B = BooleanAlgebra.double2IntBoolean(b);
        return CNIMP_TRUTH_TABLE[A][B];
    }
}

