/*
 * Decompiled with CFR 0.152.
 */
package cofh.api.util;

import cofh.core.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ThermalExpansionHelper {
    static final String MOD_ID = "thermalexpansion";
    static final String ENERGY = "energy";
    static final String EXPERIENCE = "experience";
    static final String FLUID = "fluid";
    static final String REVERSIBLE = "reversible";
    static final String CHANCE = "chance";
    static final String FACTOR = "factor";
    static final String INPUT = "input";
    static final String OUTPUT = "output";
    static final String INPUT_2 = "input2";
    static final String OUTPUT_2 = "output2";
    public static final String ADD_FURNACE_RECIPE = "addfurnacerecipe";
    public static final String ADD_PULVERIZER_RECIPE = "addpulverizerrecipe";
    public static final String ADD_SAWMILL_RECIPE = "addsawmillrecipe";
    public static final String ADD_SMELTER_RECIPE = "addsmelterrecipe";
    public static final String ADD_INSOLATOR_RECIPE = "addinsolatorrecipe";
    public static final String ADD_COMPACTOR_RECIPE = "addcompactorrecipe";
    public static final String ADD_COMPACTOR_PLATE_RECIPE = "addcompactorplaterecipe";
    public static final String ADD_COMPACTOR_COIN_RECIPE = "addcompactorcoinrecipe";
    public static final String ADD_COMPACTOR_GEAR_RECIPE = "addcompactorgearrecipe";
    public static final String ADD_CRUCIBLE_RECIPE = "addcruciblerecipe";
    public static final String ADD_REFINERY_RECIPE = "addrefineryrecipe";
    public static final String ADD_TRANSPOSER_FILL_RECIPE = "addtransposerfillrecipe";
    public static final String ADD_TRANSPOSER_EXTRACT_RECIPE = "addtransposerextractrecipe";
    public static final String ADD_CHARGER_RECIPE = "addchargerrecipe";
    public static final String ADD_CENTRIFUGE_RECIPE = "addcentrifugerecipe";
    public static final String ADD_BREWER_RECIPE = "addbrewerrecipe";
    public static final String ADD_ENCHANTER_RECIPE = "addenchanterrecipe";
    public static final String REMOVE_FURNACE_RECIPE = "removefurnacerecipe";
    public static final String REMOVE_PULVERIZER_RECIPE = "removepulverizerrecipe";
    public static final String REMOVE_SAWMILL_RECIPE = "removesawmillrecipe";
    public static final String REMOVE_SMELTER_RECIPE = "removesmelterrecipe";
    public static final String REMOVE_INSOLATOR_RECIPE = "removeinsolatorrecipe";
    public static final String REMOVE_COMPACTOR_RECIPE = "removecompactorrecipe";
    public static final String REMOVE_COMPACTOR_PLATE_RECIPE = "removecompactorplaterecipe";
    public static final String REMOVE_COMPACTOR_COIN_RECIPE = "removecompactorcoinrecipe";
    public static final String REMOVE_COMPACTOR_GEAR_RECIPE = "removecompactorgearrecipe";
    public static final String REMOVE_CRUCIBLE_RECIPE = "removecruciblerecipe";
    public static final String REMOVE_REFINERY_RECIPE = "removerefineryrecipe";
    public static final String REMOVE_TRANSPOSER_FILL_RECIPE = "removetransposerfillrecipe";
    public static final String REMOVE_TRANSPOSER_EXTRACT_RECIPE = "removetransposerextractrecipe";
    public static final String REMOVE_CHARGER_RECIPE = "removechargerrecipe";
    public static final String REMOVE_CENTRIFUGE_RECIPE = "removecentrifugerecipe";
    public static final String REMOVE_BREWER_RECIPE = "removebrewerrecipe";
    public static final String REMOVE_ENCHANTER_RECIPE = "removeenchanterrecipe";
    public static final String ADD_STEAM_FUEL = "addsteamfuel";
    public static final String ADD_MAGMATIC_FUEL = "addmagmaticfuel";
    public static final String ADD_COMPRESSION_FUEL = "addcompressionfuel";
    public static final String ADD_REACTANT_FUEL = "addreactantfuel";
    public static final String ADD_ENERVATION_FUEL = "addenervationfuel";
    public static final String ADD_NUMISMATIC_FUEL = "addnumismaticfuel";
    public static final String REMOVE_STEAM_FUEL = "removesteamfuel";
    public static final String REMOVE_MAGMATIC_FUEL = "removemagmaticfuel";
    public static final String REMOVE_COMPRESSION_FUEL = "removecompressionfuel";
    public static final String REMOVE_REACTANT_FUEL = "removereactantfuel";
    public static final String REMOVE_ENERVATION_FUEL = "removeenervationfuel";
    public static final String REMOVE_NUMISMATIC_FUEL = "removenumismaticfuel";
    public static final String ADD_COOLANT = "addcoolant";
    public static final String REMOVE_COOLANT = "removecoolant";

    private ThermalExpansionHelper() {
    }

    public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_FURNACE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeFurnaceRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_FURNACE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack output) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, output, ItemStack.field_190927_a, 0);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack output, ItemStack output2) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, output, output2, 100);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack output, ItemStack output2, int chance) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        if (!output2.func_190926_b()) {
            toSend.func_74782_a(OUTPUT_2, (NBTBase)new NBTTagCompound());
            output2.func_77955_b(toSend.func_74775_l(OUTPUT_2));
            toSend.func_74768_a(CHANCE, chance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_PULVERIZER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removePulverizerRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_PULVERIZER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack output) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, output, ItemStack.field_190927_a, 0);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack output, ItemStack output2) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, output, output2, 100);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack output, ItemStack output2, int chance) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        if (!output2.func_190926_b()) {
            toSend.func_74782_a(OUTPUT_2, (NBTBase)new NBTTagCompound());
            output2.func_77955_b(toSend.func_74775_l(OUTPUT_2));
            toSend.func_74768_a(CHANCE, chance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_SAWMILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeSawmillRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_SAWMILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addSmelterRecipe(int energy, ItemStack input, ItemStack input2, ItemStack output) {
        ThermalExpansionHelper.addSmelterRecipe(energy, input, input2, output, ItemStack.field_190927_a, 0);
    }

    public static void addSmelterRecipe(int energy, ItemStack input, ItemStack input2, ItemStack output, ItemStack output2) {
        ThermalExpansionHelper.addSmelterRecipe(energy, input, input2, output, output2, 100);
    }

    public static void addSmelterRecipe(int energy, ItemStack input, ItemStack input2, ItemStack output, ItemStack output2, int chance) {
        if (input.func_190926_b() || input2.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(INPUT_2, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        input2.func_77955_b(toSend.func_74775_l(INPUT_2));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        if (!output2.func_190926_b()) {
            toSend.func_74782_a(OUTPUT_2, (NBTBase)new NBTTagCompound());
            output2.func_77955_b(toSend.func_74775_l(OUTPUT_2));
            toSend.func_74768_a(CHANCE, chance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_SMELTER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeSmelterRecipe(ItemStack input, ItemStack input2) {
        if (input.func_190926_b() || input2.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(INPUT_2, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        input2.func_77955_b(toSend.func_74775_l(INPUT_2));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_SMELTER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addInsolatorRecipe(int energy, ItemStack input, ItemStack input2, ItemStack output) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, input, input2, output, ItemStack.field_190927_a, 0);
    }

    public static void addInsolatorRecipe(int energy, ItemStack input, ItemStack input2, ItemStack output, ItemStack output2) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, input, input2, output, output2, 100);
    }

    public static void addInsolatorRecipe(int energy, ItemStack input, ItemStack input2, ItemStack output, ItemStack output2, int chance) {
        if (input.func_190926_b() || input2.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(INPUT_2, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        input2.func_77955_b(toSend.func_74775_l(INPUT_2));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        if (!output2.func_190926_b()) {
            toSend.func_74782_a(OUTPUT_2, (NBTBase)new NBTTagCompound());
            output2.func_77955_b(toSend.func_74775_l(OUTPUT_2));
            toSend.func_74768_a(CHANCE, chance);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_INSOLATOR_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeInsolatorRecipe(ItemStack input, ItemStack input2) {
        if (input.func_190926_b() || input2.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(INPUT_2, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        input2.func_77955_b(toSend.func_74775_l(INPUT_2));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_INSOLATOR_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCompactorRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPACTOR_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCompactorPlateRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPACTOR_PLATE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCompactorCoinRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPACTOR_COIN_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCompactorGearRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPACTOR_GEAR_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCompactorRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPACTOR_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCompactorPlateRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPACTOR_PLATE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCompactorCoinRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPACTOR_COIN_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCompactorGearRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPACTOR_GEAR_RECIPE, (NBTTagCompound)toSend);
    }

    @Deprecated
    public static void addCompactorPressRecipe(int energy, ItemStack input, ItemStack output) {
        if (ItemHelper.isPlate(input)) {
            ThermalExpansionHelper.addCompactorPlateRecipe(energy, input, output);
        } else {
            ThermalExpansionHelper.addCompactorRecipe(energy, input, output);
        }
    }

    @Deprecated
    public static void addCompactorStorageRecipe(int energy, ItemStack input, ItemStack output) {
    }

    @Deprecated
    public static void addCompactorMintRecipe(int energy, ItemStack input, ItemStack output) {
        ThermalExpansionHelper.addCompactorCoinRecipe(energy, input, output);
    }

    @Deprecated
    public static void removeCompactorPressRecipe(ItemStack input) {
    }

    @Deprecated
    public static void removeCompactorStorageRecipe(ItemStack input) {
    }

    @Deprecated
    public static void removeCompactorMintRecipe(ItemStack input) {
        ThermalExpansionHelper.removeCompactorCoinRecipe(input);
    }

    public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        if (input.func_190926_b() || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.writeToNBT(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_CRUCIBLE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCrucibleRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_CRUCIBLE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addRefineryRecipe(int energy, FluidStack input, FluidStack output, ItemStack outputItem) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        if (!outputItem.func_190926_b()) {
            toSend.func_74782_a(OUTPUT_2, (NBTBase)new NBTTagCompound());
            outputItem.func_77955_b(toSend.func_74775_l(OUTPUT_2));
        }
        input.writeToNBT(toSend.func_74775_l(INPUT));
        output.writeToNBT(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_REFINERY_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeRefineryRecipe(FluidStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_REFINERY_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        toSend.func_74757_a(REVERSIBLE, reversible);
        fluid.writeToNBT(toSend.func_74775_l(FLUID));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_TRANSPOSER_FILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input.func_190926_b() || output.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        toSend.func_74757_a(REVERSIBLE, reversible);
        toSend.func_74768_a(CHANCE, chance);
        fluid.writeToNBT(toSend.func_74775_l(FLUID));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_TRANSPOSER_EXTRACT_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeTransposerFill(ItemStack input, FluidStack fluid) {
        if (input.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        fluid.writeToNBT(toSend.func_74775_l(FLUID));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_TRANSPOSER_FILL_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeTransposerExtract(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_TRANSPOSER_EXTRACT_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addChargerRecipe(int energy, ItemStack input, ItemStack output) {
        if (input.func_190926_b() || output.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_CHARGER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeChargerRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_CHARGER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addCentrifugeRecipe(int energy, ItemStack input, List<ItemStack> output) {
        ThermalExpansionHelper.addCentrifugeRecipe(energy, input, output, new ArrayList<Integer>(), null);
    }

    public static void addCentrifugeRecipe(int energy, ItemStack input, List<ItemStack> output, List<Integer> chance) {
        ThermalExpansionHelper.addCentrifugeRecipe(energy, input, output, chance, null);
    }

    public static void addCentrifugeRecipe(int energy, ItemStack input, FluidStack fluid) {
        ThermalExpansionHelper.addCentrifugeRecipe(energy, input, new ArrayList<ItemStack>(), new ArrayList<Integer>(), fluid);
    }

    public static void addCentrifugeRecipe(int energy, ItemStack input, List<ItemStack> output, List<Integer> chance, FluidStack fluid) {
        if (input.func_190926_b() || output.size() > 4 || chance.size() > 4 || !chance.isEmpty() && chance.size() != output.size() || output.isEmpty() && fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        if (!output.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < output.size(); ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                output.get(i).func_77955_b(tag);
                if (!chance.isEmpty()) {
                    tag.func_74768_a(CHANCE, chance.get(i).intValue());
                }
                list.func_74742_a((NBTBase)tag);
            }
            toSend.func_74782_a(OUTPUT, (NBTBase)list);
        }
        if (fluid != null) {
            toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
            fluid.writeToNBT(toSend.func_74775_l(FLUID));
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_CENTRIFUGE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeCentrifugeRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_CENTRIFUGE_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addBrewerRecipe(int energy, ItemStack input, FluidStack inputFluid, FluidStack outputFluid) {
        if (input.func_190926_b() || inputFluid == null || outputFluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(INPUT_2, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        inputFluid.writeToNBT(toSend.func_74775_l(INPUT_2));
        outputFluid.writeToNBT(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_BREWER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeBrewerRecipe(ItemStack input, FluidStack fluid) {
        if (input.func_190926_b() || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(FLUID, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        fluid.writeToNBT(toSend.func_74775_l(FLUID));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_BREWER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addEnchanterRecipe(int energy, ItemStack input, ItemStack input2, ItemStack output, int fluidExp) {
        if (input.func_190926_b() || input2.func_190926_b() || output.func_190926_b() || fluidExp < 0) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74768_a(EXPERIENCE, fluidExp);
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(INPUT_2, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(OUTPUT, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        input2.func_77955_b(toSend.func_74775_l(INPUT_2));
        output.func_77955_b(toSend.func_74775_l(OUTPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_ENCHANTER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void removeEnchanterRecipe(ItemStack input, ItemStack input2) {
        if (input.func_190926_b() || input2.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74782_a(INPUT_2, (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l(INPUT));
        input2.func_77955_b(toSend.func_74775_l(INPUT_2));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_ENCHANTER_RECIPE, (NBTTagCompound)toSend);
    }

    public static void addSteamFuel(ItemStack fuel, int energy) {
        if (fuel.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74768_a(ENERGY, energy);
        fuel.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_STEAM_FUEL, (NBTTagCompound)toSend);
    }

    public static void removeSteamFuel(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        fuel.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_STEAM_FUEL, (NBTTagCompound)toSend);
    }

    public static void addMagmaticFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_MAGMATIC_FUEL, (NBTTagCompound)toSend);
    }

    public static void removeMagmaticFuel(String fluidName) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID, fluidName);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_MAGMATIC_FUEL, (NBTTagCompound)toSend);
    }

    public static void addCompressionFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COMPRESSION_FUEL, (NBTTagCompound)toSend);
    }

    public static void removeCompressionFuel(String fluidName) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID, fluidName);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COMPRESSION_FUEL, (NBTTagCompound)toSend);
    }

    public static void addReactantFuel(ItemStack reactant, String fluidName, int energy) {
        if (reactant.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74778_a(FLUID, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        reactant.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_REACTANT_FUEL, (NBTTagCompound)toSend);
    }

    public static void removeReactantFuel(ItemStack reactant, String fluidName) {
        if (reactant.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74778_a(FLUID, fluidName);
        reactant.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_REACTANT_FUEL, (NBTTagCompound)toSend);
    }

    public static void addEnervationFuel(ItemStack fuel, int energy) {
        if (fuel.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74768_a(ENERGY, energy);
        fuel.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_ENERVATION_FUEL, (NBTTagCompound)toSend);
    }

    public static void removeEnervationFuel(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        fuel.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_ENERVATION_FUEL, (NBTTagCompound)toSend);
    }

    public static void addNumismaticFuel(ItemStack fuel, int energy) {
        if (fuel.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        toSend.func_74768_a(ENERGY, energy);
        fuel.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_NUMISMATIC_FUEL, (NBTTagCompound)toSend);
    }

    public static void removeNumismaticFuel(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a(INPUT, (NBTBase)new NBTTagCompound());
        fuel.func_77955_b(toSend.func_74775_l(INPUT));
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_NUMISMATIC_FUEL, (NBTTagCompound)toSend);
    }

    public static void addCoolant(String fluidName, int energy, int factor) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID, fluidName);
        toSend.func_74768_a(ENERGY, energy);
        toSend.func_74768_a(FACTOR, factor);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)ADD_COOLANT, (NBTTagCompound)toSend);
    }

    public static void removeCoolant(String fluidName) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a(FLUID, fluidName);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)REMOVE_COOLANT, (NBTTagCompound)toSend);
    }
}

