/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars;

import cpw.mods.compactsolars.blocks.BlockCompactSolar;
import cpw.mods.compactsolars.common.CommonProxy;
import cpw.mods.compactsolars.common.CompactSolarType;
import cpw.mods.compactsolars.common.gui.GuiHandler;
import cpw.mods.compactsolars.common.version.Version;
import cpw.mods.compactsolars.items.ItemCompactSolar;
import cpw.mods.compactsolars.items.ItemSolarHat;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
@Mod(modid="compactsolars", name="Compact Solar Arrays", dependencies="required-after:forge@[14.23.0.2491,);required-after:ic2@[2.8,)", acceptedMinecraftVersions="[1.12.2]")
public class CompactSolars {
    @SidedProxy(clientSide="cpw.mods.compactsolars.common.ClientProxy", serverSide="cpw.mods.compactsolars.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockCompactSolar compactSolarBlock;
    public static ItemCompactSolar compactSolarItemBlock;
    public static int productionRate;
    @Mod.Instance(value="compactsolars")
    public static CompactSolars instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent preinit) {
        Version.init(preinit.getVersionProperties());
        preinit.getModMetadata().version = Version.version();
        Configuration cfg = new Configuration(preinit.getSuggestedConfigurationFile());
        try {
            cfg.load();
            Property scale = cfg.get("general", "scaleFactor", 1);
            scale.setComment("The EU generation scaling factor. The average number of ticks needed to generate one EU packet.1 is every tick, 2 is every other tick etc. Each Solar will still generate a whole packet (8, 64, 512 EU).");
            productionRate = scale.getInt(1);
        }
        catch (Exception e) {
            preinit.getModLog().error("CompactSolars was unable to load it's configuration successfully", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            cfg.save();
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        compactSolarBlock = new BlockCompactSolar();
        compactSolarBlock.func_149663_c("compactsolars.compact_solar_block");
        compactSolarBlock.setRegistryName(new ResourceLocation("compactsolars", "compact_solar_block"));
        event.getRegistry().register((IForgeRegistryEntry)compactSolarBlock);
        for (CompactSolarType typ : CompactSolarType.values()) {
            GameRegistry.registerTileEntity(typ.clazz, (String)typ.tileEntityName());
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        compactSolarItemBlock = new ItemCompactSolar((Block)compactSolarBlock);
        compactSolarItemBlock.func_77655_b(compactSolarBlock.func_149739_a());
        compactSolarItemBlock.setRegistryName(compactSolarBlock.getRegistryName());
        event.getRegistry().register((IForgeRegistryEntry)compactSolarItemBlock);
        for (CompactSolarType typ : CompactSolarType.values()) {
            event.getRegistry().register((IForgeRegistryEntry)typ.buildHat());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent init) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent postinit) {
        CompactSolarType.generateRecipes(compactSolarBlock);
        CompactSolarType.generateHatRecipes(compactSolarBlock);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent evt) {
        ItemSolarHat.clearRaining();
    }

    static {
        productionRate = 1;
    }
}

