/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.buildcraft;

import buildcraft.energy.BCEnergyFluids;
import java.util.Arrays;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.Core;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.recipe.machines.DistillationTowerRecipe;
import techreborn.compat.ICompatModule;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ItemDynamicCell;

@RebornRegistry(modOnly="buildcraftenergy", modID="techreborn")
public class BuildCraftEnergyCompat
implements ICompatModule {
    @ConfigRegistry(config="compat", category="buildcraft", key="EnableDistillationTowerBuildCraftRecipes", comment="Enable distillation tower recipes related to BuildCraft fuels")
    public static boolean enableDistillationTowerBuildCraftRecipes = true;
    @ConfigRegistry(config="compat", category="buildcraft", key="EnableBuildcraftFuels", comment="Allow BuildCraft fuels to be used in fuel generators")
    public static boolean allowBuildCraftFuels = true;

    public void init(FMLInitializationEvent event) {
        if (enableDistillationTowerBuildCraftRecipes) {
            try {
                RecipeHandler.addRecipe((IBaseRecipeType)new DistillationTowerRecipe((Object)ItemDynamicCell.getCellWithFluid((Fluid)BCEnergyFluids.crudeOil[0], (int)16), (Object)ItemDynamicCell.getEmptyCell((int)33), RecipeMethods.getMaterial((String)"diesel", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"sulfuricAcid", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"glyceryl", (RecipeMethods.Type)RecipeMethods.Type.CELL), RecipeMethods.getMaterial((String)"methane", (int)16, (RecipeMethods.Type)RecipeMethods.Type.CELL), 16000, 16));
            }
            catch (NullPointerException exception) {
                Core.logHelper.error((Object)"Cannot create a distillation tower recipe for BuildCraft Oil. This might be caused by another mod messing with it (i.e. AsmodeusCore).");
            }
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (allowBuildCraftFuels) {
            Arrays.stream(BCEnergyFluids.crudeOil).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.SEMIFLUID, (Fluid)entry, (int)16));
            Arrays.stream(BCEnergyFluids.oilDense).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.SEMIFLUID, (Fluid)entry, (int)16));
            Arrays.stream(BCEnergyFluids.oilDistilled).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.SEMIFLUID, (Fluid)entry, (int)16));
            Arrays.stream(BCEnergyFluids.oilHeavy).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.SEMIFLUID, (Fluid)entry, (int)16));
            Arrays.stream(BCEnergyFluids.fuelDense).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.DIESEL, (Fluid)entry, (int)384));
            Arrays.stream(BCEnergyFluids.fuelLight).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.DIESEL, (Fluid)entry, (int)384));
            Arrays.stream(BCEnergyFluids.fuelMixedHeavy).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.DIESEL, (Fluid)entry, (int)384));
            Arrays.stream(BCEnergyFluids.fuelMixedLight).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.DIESEL, (Fluid)entry, (int)384));
            Arrays.stream(BCEnergyFluids.fuelGaseous).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.GAS, (Fluid)entry, (int)45));
            Arrays.stream(BCEnergyFluids.oilResidue).forEach(entry -> GeneratorRecipeHelper.registerFluidRecipe((EFluidGenerator)EFluidGenerator.SEMIFLUID, (Fluid)entry, (int)3));
        }
    }
}

