/*
 * Decompiled with CFR 0.152.
 */
package glmath.jglm;

import glmath.jglm.Vec;
import glmath.jglm.Vec3;

public class Vec4
extends Vec {
    public float x;
    public float y;
    public float z;
    public float w;

    public Vec4() {
    }

    public Vec4(float[] vec4) {
        this.vector = vec4;
        this.x = this.vector[0];
        this.y = this.vector[1];
        this.z = this.vector[2];
        this.w = this.vector[3];
    }

    public Vec4(float value) {
        this.vector = new float[]{value, value, value, value};
        this.x = this.vector[0];
        this.y = this.vector[1];
        this.z = this.vector[2];
        this.w = this.vector[3];
    }

    public Vec4(int[] floatArray) {
        this.x = floatArray[0];
        this.y = floatArray[1];
        this.z = floatArray[2];
        this.w = floatArray[3];
        this.vector = new float[]{this.x, this.y, this.z, this.w};
    }

    public Vec4(Vec3 vec3, float w) {
        this.x = vec3.x;
        this.y = vec3.y;
        this.z = vec3.z;
        this.w = w;
        this.vector = new float[]{this.x, this.y, this.z, this.w};
    }

    public Vec4(float[] floatArray, int i) {
        this.vector = new float[]{floatArray[i], floatArray[i + 1], floatArray[i + 2], floatArray[i + 3]};
        this.x = this.vector[0];
        this.y = this.vector[1];
        this.z = this.vector[2];
        this.w = this.vector[3];
    }

    public Vec4(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        this.vector = new float[]{this.x, this.y, this.z, this.w};
    }

    public Vec4 normalize() {
        return new Vec4(this.x / this.length(), this.y / this.length(), this.z / this.length(), this.w / this.length());
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public void print() {
        System.out.println("(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")");
    }

    public void print(String title) {
        System.out.println(title + " (" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")");
    }

    public Vec4 mult(float scalar) {
        return new Vec4(this.x * scalar, this.y * scalar, this.z * scalar, this.w * scalar);
    }

    public Vec4 mult(Vec4 vec4) {
        return new Vec4(this.x * vec4.x, this.y * vec4.y, this.z * vec4.z, this.w * vec4.w);
    }

    public Vec4 minus(Vec4 vec4) {
        return new Vec4(this.x - vec4.x, this.y - vec4.y, this.z - vec4.z, this.w - vec4.w);
    }

    public Vec4 minus(float scalar) {
        return new Vec4(this.x - scalar, this.y - scalar, this.z - scalar, this.w - scalar);
    }

    public Vec4 plus(Vec4 vec4) {
        return new Vec4(this.x + vec4.x, this.y + vec4.y, this.z + vec4.z, this.w + vec4.w);
    }

    public Vec4 divide(float scalar) {
        return new Vec4(this.x / scalar, this.y / scalar, this.z / scalar, this.w / scalar);
    }

    public float[] toFloatArray() {
        return new float[]{this.x, this.y, this.z, this.w};
    }
}

