/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator;

import com.hbm.world.generator.CellularDungeon;
import com.hbm.world.generator.DungeonToolbox;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class CellularDungeonRoom {
    protected CellularDungeon parent;
    protected CellularDungeonRoom daisyChain = null;
    protected EnumFacing daisyDirection = null;

    public CellularDungeonRoom(CellularDungeon parent) {
        this.parent = parent;
    }

    public void generate(World world, int x, int y, int z, EnumFacing door) {
        this.generateMain(world, x, y, z);
        for (int i = 2; i < 6; ++i) {
            EnumFacing dir;
            this.generateWall(world, x, y, z, dir, (dir = EnumFacing.func_82600_a((int)i)) == door);
        }
    }

    public void generateMain(World world, int x, int y, int z) {
        DungeonToolbox.generateBox(world, x, y, z, this.parent.width, 1, this.parent.width, this.parent.floor);
        DungeonToolbox.generateBox(world, x, y + 1, z, this.parent.width, this.parent.height - 1, this.parent.width, Blocks.field_150350_a.func_176223_P());
        DungeonToolbox.generateBox(world, x, y + this.parent.height - 1, z, this.parent.width, 1, this.parent.width, this.parent.ceiling);
    }

    public void generateWall(World world, int x, int y, int z, EnumFacing wall, boolean door) {
        if (wall == EnumFacing.NORTH) {
            DungeonToolbox.generateBox(world, x, y + 1, z, this.parent.width, this.parent.height - 2, 1, this.parent.wall);
            if (door) {
                DungeonToolbox.generateBox(world, x + this.parent.width / 2, y + 1, z, 1, 2, 1, Blocks.field_150350_a.func_176223_P());
            }
        }
        if (wall == EnumFacing.SOUTH) {
            DungeonToolbox.generateBox(world, x, y + 1, z + this.parent.width - 1, this.parent.width, this.parent.height - 2, 1, this.parent.wall);
            if (door) {
                DungeonToolbox.generateBox(world, x + this.parent.width / 2, y + 1, z + this.parent.width - 1, 1, 2, 1, Blocks.field_150350_a.func_176223_P());
            }
        }
        if (wall == EnumFacing.WEST) {
            DungeonToolbox.generateBox(world, x, y + 1, z, 1, this.parent.height - 2, this.parent.width, this.parent.wall);
            if (door) {
                DungeonToolbox.generateBox(world, x, y + 1, z + this.parent.width / 2, 1, 2, 1, Blocks.field_150350_a.func_176223_P());
            }
        }
        if (wall == EnumFacing.EAST) {
            DungeonToolbox.generateBox(world, x + this.parent.width - 1, y + 1, z, 1, this.parent.height - 2, this.parent.width, this.parent.wall);
            if (door) {
                DungeonToolbox.generateBox(world, x + this.parent.width - 1, y + 1, z + this.parent.width / 2, 1, 2, 1, Blocks.field_150350_a.func_176223_P());
            }
        }
    }
}

