/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator;

import com.hbm.world.generator.CellularDungeonRoom;
import com.hbm.world.generator.DungeonToolbox;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class CellularDungeon {
    CellularDungeonRoom[][] cells;
    EnumFacing[][] doors;
    private List<int[]> order = new ArrayList<int[]>();
    int dimX;
    int dimZ;
    public int width;
    public int height;
    public List<IBlockState> floor = new ArrayList<IBlockState>();
    public List<IBlockState> ceiling = new ArrayList<IBlockState>();
    public List<IBlockState> wall = new ArrayList<IBlockState>();
    public List<CellularDungeonRoom> rooms = new ArrayList<CellularDungeonRoom>();
    int tries;
    int branches;
    int rec = 0;

    public CellularDungeon(int width, int height, int dimX, int dimZ, int tries, int branches) {
        this.dimX = dimX;
        this.dimZ = dimZ;
        this.width = width;
        this.height = height;
        this.tries = tries;
        this.branches = branches;
    }

    public CellularDungeon(int width, int height, int dimX, int dimZ, int tries, int branches, Block floor, Block ceiling, Block wall) {
        this.dimX = dimX;
        this.dimZ = dimZ;
        this.width = width;
        this.height = height;
        this.tries = tries;
        this.branches = branches;
        this.floor.add(floor.func_176223_P());
        this.ceiling.add(ceiling.func_176223_P());
        this.wall.add(wall.func_176223_P());
    }

    public void generate(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        x -= this.dimX * this.width / 2;
        z -= this.dimZ * this.width / 2;
        this.compose(rand);
        for (int[] coord : this.order) {
            int dz;
            int dx;
            if (coord == null || coord.length != 2 || this.cells[dx = coord[0]][dz = coord[1]] == null) continue;
            this.cells[dx][dz].generate(world, x + dx * (this.width - 1), y, z + dz * (this.width - 1), this.doors[dx][dz]);
        }
    }

    public void compose(Random rand) {
        this.cells = new CellularDungeonRoom[this.dimX][this.dimZ];
        this.doors = new EnumFacing[this.dimX][this.dimZ];
        this.order.clear();
        int startX = this.dimX / 2;
        int startZ = this.dimZ / 2;
        this.cells[startX][startZ] = DungeonToolbox.getRandom(this.rooms, rand);
        this.doors[startX][startZ] = null;
        this.order.add(new int[]{startX, startZ});
        this.rec = 0;
        this.addRoom(startX, startZ, rand, null, DungeonToolbox.getRandom(this.rooms, rand));
    }

    private boolean addRoom(int x, int z, Random rand, EnumFacing door, CellularDungeonRoom room) {
        ++this.rec;
        if (this.rec > this.tries) {
            return false;
        }
        if (x < 0 || z < 0 || x >= this.dimX || z >= this.dimZ) {
            return false;
        }
        if (this.cells[x][z] != null) {
            EnumFacing dir = CellularDungeon.getRandomDir(rand);
            this.addRoom(x + dir.func_82601_c(), z + dir.func_82599_e(), rand, dir.func_176734_d(), DungeonToolbox.getRandom(this.rooms, rand));
            return false;
        }
        if (room.daisyChain == null || this.addRoom(x + room.daisyDirection.func_82601_c(), z + room.daisyDirection.func_82599_e(), rand, null, room.daisyChain)) {
            this.cells[x][z] = room;
            this.doors[x][z] = door;
            this.order.add(new int[]{x, z});
        }
        for (int i = 0; i < this.branches; ++i) {
            EnumFacing dir = CellularDungeon.getRandomDir(rand);
            this.addRoom(x + dir.func_82601_c(), z + dir.func_82599_e(), rand, dir.func_176734_d(), DungeonToolbox.getRandom(this.rooms, rand));
        }
        return true;
    }

    public static EnumFacing getRandomDir(Random rand) {
        return EnumFacing.func_82600_a((int)(rand.nextInt(4) + 2));
    }
}

