/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import api.hbm.energy.IEnergyUser;
import com.hbm.entity.logic.EntityBomber;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemTurretBiometry;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileEntityTurretBaseNT
extends TileEntityMachineBase
implements IEnergyUser,
IControllable,
IControlReceiver,
ITickable {
    public double rotationYaw;
    public double rotationPitch;
    public double lastRotationYaw;
    public double lastRotationPitch;
    public boolean isOn = false;
    public boolean aligned = false;
    public int searchTimer;
    public long power;
    public boolean targetPlayers = false;
    public boolean targetAnimals = false;
    public boolean targetMobs = true;
    public boolean targetMachines = true;
    public boolean manualOverride = false;
    public Entity target;
    public Vec3d tPos;
    public int stattrak;
    @SideOnly(value=Side.CLIENT)
    protected List<ItemStack> ammoStacks;

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.isUseableByPlayer(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("del")) {
            this.removeName(data.func_74762_e("del"));
        } else if (data.func_74764_b("name")) {
            this.addName(data.func_74779_i("name"));
        }
    }

    public TileEntityTurretBaseNT() {
        super(11);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.targetPlayers = nbt.func_74767_n("targetPlayers");
        this.targetAnimals = nbt.func_74767_n("targetAnimals");
        this.targetMobs = nbt.func_74767_n("targetMobs");
        this.targetMachines = nbt.func_74767_n("targetMachines");
        this.stattrak = nbt.func_74762_e("stattrak");
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("targetPlayers", this.targetPlayers);
        nbt.func_74757_a("targetAnimals", this.targetAnimals);
        nbt.func_74757_a("targetMobs", this.targetMobs);
        nbt.func_74757_a("targetMachines", this.targetMachines);
        nbt.func_74768_a("stattrak", this.stattrak);
        return super.func_189515_b(nbt);
    }

    public void manualSetup() {
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.lastRotationPitch = this.rotationPitch;
            this.lastRotationYaw = this.rotationYaw;
        }
        this.aligned = false;
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                ++this.stattrak;
            }
        }
        if (this.target != null && !this.entityInLOS(this.target)) {
            this.target = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.target != null) {
                this.tPos = this.getEntityPos(this.target);
            } else if (!this.manualOverride) {
                this.tPos = null;
            }
        }
        if (this.isOn() && this.hasPower()) {
            if (this.tPos != null) {
                this.alignTurret();
            }
        } else {
            this.target = null;
            this.tPos = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.target != null && !this.target.func_70089_S() && !this.manualOverride) {
                this.target = null;
                this.tPos = null;
                ++this.stattrak;
            }
            if (this.isOn() && this.hasPower()) {
                --this.searchTimer;
                this.setPower(this.getPower() - this.getConsumption());
                if (this.searchTimer <= 0) {
                    this.searchTimer = this.getDecetorInterval();
                    if (this.target == null && !this.manualOverride) {
                        this.seekNewTarget();
                    }
                }
            } else {
                this.searchTimer = 0;
            }
            if (this.aligned) {
                this.updateFiringTick();
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 10, this.power, this.getMaxPower());
            this.manualOverride = false;
            this.networkPack();
        } else {
            Vec3d vec = new Vec3d(this.getBarrelLength(), 0.0, 0.0);
            vec = vec.func_178789_a((float)(-this.rotationPitch));
            vec = vec.func_178785_b((float)(-(this.rotationYaw + 1.5707963267948966)));
            if (Math.abs(this.lastRotationYaw - this.rotationYaw) > Math.PI) {
                this.lastRotationYaw = this.lastRotationYaw < this.rotationYaw ? (this.lastRotationYaw += Math.PI * 2) : (this.lastRotationYaw -= Math.PI * 2);
            }
        }
    }

    public void networkPack() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.tPos != null) {
            data.func_74780_a("tX", this.tPos.field_72450_a);
            data.func_74780_a("tY", this.tPos.field_72448_b);
            data.func_74780_a("tZ", this.tPos.field_72449_c);
        }
        data.func_74772_a("power", this.power);
        data.func_74757_a("isOn", this.isOn);
        data.func_74757_a("targetPlayers", this.targetPlayers);
        data.func_74757_a("targetAnimals", this.targetAnimals);
        data.func_74757_a("targetMobs", this.targetMobs);
        data.func_74757_a("targetMachines", this.targetMachines);
        data.func_74768_a("stattrak", this.stattrak);
        this.networkPack(data, 250);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.targetPlayers = nbt.func_74767_n("targetPlayers");
        this.targetAnimals = nbt.func_74767_n("targetAnimals");
        this.targetMobs = nbt.func_74767_n("targetMobs");
        this.targetMachines = nbt.func_74767_n("targetMachines");
        this.stattrak = nbt.func_74762_e("stattrak");
        this.tPos = nbt.func_74764_b("tX") ? new Vec3d(nbt.func_74769_h("tX"), nbt.func_74769_h("tY"), nbt.func_74769_h("tZ")) : null;
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        switch (meta) {
            case 0: {
                this.isOn = !this.isOn;
                break;
            }
            case 1: {
                this.targetPlayers = !this.targetPlayers;
                break;
            }
            case 2: {
                this.targetAnimals = !this.targetAnimals;
                break;
            }
            case 3: {
                this.targetMobs = !this.targetMobs;
                break;
            }
            case 4: {
                this.targetMachines = !this.targetMachines;
            }
        }
    }

    protected void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * -1, 0, dir.offsetZ * -1), dir.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * -1 + rot.offsetX * -1, 0, dir.offsetZ * -1 + rot.offsetZ * -1), dir.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * -2, 0, rot.offsetZ * -2), rot.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 1 + rot.offsetX * -2, 0, dir.offsetZ * 1 + rot.offsetZ * -2), rot.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(rot.offsetX * 1, 0, rot.offsetZ * 1), rot);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 1 + rot.offsetX * 1, 0, dir.offsetZ * 1 + rot.offsetZ * 1), rot);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 2, 0, dir.offsetZ * 2), dir);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX * 2 + rot.offsetX * -1, 0, dir.offsetZ * 2 + rot.offsetZ * -1), dir);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 0), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, dir.offsetZ - rot.offsetZ), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX - rot.offsetX, -1, 0), ForgeDirection.DOWN);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(dir.offsetX - rot.offsetX, -1, dir.offsetZ - rot.offsetZ), ForgeDirection.DOWN);
    }

    public abstract void updateFiringTick();

    public BulletConfiguration getFirstConfigLoaded() {
        List<Integer> list = this.getAmmoList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (int i = 1; i < 10; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            for (Integer c : list) {
                BulletConfiguration conf = BulletConfigSyncingUtil.pullConfig(c);
                if (conf.ammo != this.inventory.getStackInSlot(i).func_77973_b()) continue;
                return conf;
            }
        }
        return null;
    }

    public void spawnBullet(BulletConfiguration bullet) {
        this.spawnBullet(bullet, 0.0f);
    }

    public void spawnBullet(BulletConfiguration bullet, float overrideDamage) {
        Vec3 pos = new Vec3(this.getTurretPos());
        Vec3 vec = Vec3.createVectorHelper(this.getBarrelLength(), 0.0, 0.0);
        vec.rotateAroundZ((float)(-this.rotationPitch));
        vec.rotateAroundY((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityBulletBase proj = new EntityBulletBase(this.field_145850_b, BulletConfigSyncingUtil.getKey(bullet));
        proj.func_70080_a(pos.xCoord + vec.xCoord, pos.yCoord + vec.yCoord, pos.zCoord + vec.zCoord, 0.0f, 0.0f);
        if (overrideDamage > 0.0f) {
            proj.overrideDamage = overrideDamage;
        }
        proj.func_70186_c(vec.xCoord, vec.yCoord, vec.zCoord, bullet.velocity, bullet.spread);
        this.field_145850_b.func_72838_d((Entity)proj);
    }

    public void conusmeAmmo(Item ammo) {
        for (int i = 1; i < 10; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() != ammo) continue;
            this.inventory.getStackInSlot(i).func_190918_g(1);
            if (this.inventory.getStackInSlot(i).func_190926_b()) {
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            return;
        }
        this.func_70296_d();
    }

    public List<String> getWhitelist() {
        if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.turret_chip) {
            String[] array = ItemTurretBiometry.getNames(this.inventory.getStackInSlot(0));
            if (array == null) {
                return null;
            }
            return Arrays.asList(ItemTurretBiometry.getNames(this.inventory.getStackInSlot(0)));
        }
        return null;
    }

    public void addName(String name) {
        if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.turret_chip) {
            ItemTurretBiometry.addName(this.inventory.getStackInSlot(0), name);
        }
    }

    public void removeName(int index) {
        if (this.inventory.getStackInSlot(0).func_77973_b() == ModItems.turret_chip) {
            String[] array = ItemTurretBiometry.getNames(this.inventory.getStackInSlot(0));
            if (array == null) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(array));
            ItemTurretBiometry.clearNames(this.inventory.getStackInSlot(0));
            names.remove(index);
            for (String name : names) {
                ItemTurretBiometry.addName(this.inventory.getStackInSlot(0), name);
            }
        }
    }

    protected void seekNewTarget() {
        Vec3d pos = this.getTurretPos();
        double range = this.getDecetorRange();
        List entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_72314_b(range, range, range));
        Entity target = null;
        double closest = range;
        for (Entity entity : entities) {
            Vec3d ent = this.getEntityPos(entity);
            Vec3d delta = new Vec3d(ent.field_72450_a - pos.field_72450_a, ent.field_72448_b - pos.field_72448_b, ent.field_72449_c - pos.field_72449_c);
            double dist = delta.func_72433_c();
            if (dist > range || !this.entityAcceptableTarget(entity) || !this.entityInLOS(entity) || !(dist < closest)) continue;
            closest = dist;
            target = entity;
        }
        this.target = target;
        if (target != null) {
            this.tPos = this.getEntityPos(this.target);
        }
    }

    protected void alignTurret() {
        this.turnTowards(this.tPos);
    }

    public void turnTowards(Vec3d ent) {
        double turnYaw = Math.toRadians(this.getTurretYawSpeed());
        double turnPitch = Math.toRadians(this.getTurretPitchSpeed());
        double pi2 = Math.PI * 2;
        Vec3d pos = this.getTurretPos();
        Vec3d delta = new Vec3d(ent.field_72450_a - pos.field_72450_a, ent.field_72448_b - pos.field_72448_b, ent.field_72449_c - pos.field_72449_c);
        double targetPitch = Math.asin(delta.field_72448_b / delta.func_72433_c());
        double targetYaw = -Math.atan2(delta.field_72450_a, delta.field_72449_c);
        this.rotationPitch = Math.abs(this.rotationPitch - targetPitch) < turnPitch || Math.abs(this.rotationPitch - targetPitch) > pi2 - turnPitch ? targetPitch : (targetPitch > this.rotationPitch ? (this.rotationPitch += turnPitch) : (this.rotationPitch -= turnPitch));
        double deltaYaw = (targetYaw - this.rotationYaw) % pi2;
        int dir = 0;
        if (deltaYaw < -Math.PI) {
            dir = 1;
        } else if (deltaYaw < 0.0) {
            dir = -1;
        } else if (deltaYaw > Math.PI) {
            dir = -1;
        } else if (deltaYaw > 0.0) {
            dir = 1;
        }
        this.rotationYaw = Math.abs(this.rotationYaw - targetYaw) < turnYaw || Math.abs(this.rotationYaw - targetYaw) > pi2 - turnYaw ? targetYaw : (this.rotationYaw += turnYaw * (double)dir);
        double deltaPitch = targetPitch - this.rotationPitch;
        deltaYaw = targetYaw - this.rotationYaw;
        double deltaAngle = Math.sqrt(deltaYaw * deltaYaw + deltaPitch * deltaPitch);
        this.rotationYaw %= pi2;
        this.rotationPitch %= pi2;
        if (deltaAngle <= Math.toRadians(this.getAcceptableInaccuracy())) {
            this.aligned = true;
        }
    }

    public boolean entityInLOS(Entity e) {
        if (e.field_70128_L || !e.func_70089_S()) {
            return false;
        }
        if (!this.hasThermalVision() && e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70644_a(MobEffects.field_76441_p)) {
            return false;
        }
        Vec3d pos = this.getTurretPos();
        Vec3d ent = this.getEntityPos(e);
        Vec3d delta = new Vec3d(ent.field_72450_a - pos.field_72450_a, ent.field_72448_b - pos.field_72448_b, ent.field_72449_c - pos.field_72449_c);
        double length = delta.func_72433_c();
        if (length < this.getDecetorGrace() || length > this.getDecetorRange() * 1.1) {
            return false;
        }
        double pitch = Math.asin(delta.field_72448_b / (delta = delta.func_72432_b()).func_72433_c());
        double pitchDeg = Math.toDegrees(pitch);
        if (pitchDeg < -this.getTurretDepression() || pitchDeg > this.getTurretElevation()) {
            return false;
        }
        return !Library.isObstructed(this.field_145850_b, ent.field_72450_a, ent.field_72448_b, ent.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public boolean entityAcceptableTarget(Entity e) {
        if (e.field_70128_L || !e.func_70089_S()) {
            return false;
        }
        if (this.targetAnimals) {
            if (e instanceof IAnimals) {
                return true;
            }
            if (e instanceof INpc) {
                return true;
            }
        }
        if (this.targetMobs) {
            if (e instanceof EntityDragon) {
                return false;
            }
            if (e instanceof MultiPartEntityPart) {
                return true;
            }
            if (e instanceof IMob) {
                return true;
            }
        }
        if (this.targetMachines) {
            if (e instanceof EntityMissileBaseAdvanced) {
                return true;
            }
            if (e instanceof EntityMissileCustom) {
                return true;
            }
            if (e instanceof EntityMinecart) {
                return true;
            }
            if (e instanceof EntityBomber) {
                return true;
            }
        }
        if (this.targetPlayers && e instanceof EntityPlayer) {
            if (e instanceof FakePlayer) {
                return false;
            }
            List<String> wl = this.getWhitelist();
            if (wl == null || wl.isEmpty()) {
                return true;
            }
            return !wl.contains(((EntityPlayer)e).func_145748_c_().func_150260_c());
        }
        return false;
    }

    public double getAcceptableInaccuracy() {
        return 5.0;
    }

    public double getTurretYawSpeed() {
        return 4.5;
    }

    public double getTurretPitchSpeed() {
        return 3.0;
    }

    public double getTurretDepression() {
        return 30.0;
    }

    public double getTurretElevation() {
        return 30.0;
    }

    public int getDecetorInterval() {
        return 10;
    }

    public double getDecetorRange() {
        return 32.0;
    }

    public double getDecetorGrace() {
        return 3.0;
    }

    public double getHeightOffset() {
        return 1.5;
    }

    public double getBarrelLength() {
        return 1.0;
    }

    public boolean hasThermalVision() {
        return true;
    }

    public Vec3d getTurretPos() {
        Vec3d offset = this.getHorizontalOffset();
        return new Vec3d((double)this.field_174879_c.func_177958_n() + offset.field_72450_a, (double)this.field_174879_c.func_177956_o() + this.getHeightOffset(), (double)this.field_174879_c.func_177952_p() + offset.field_72449_c);
    }

    public Vec3d getHorizontalOffset() {
        int meta = this.func_145832_p() - 10;
        if (meta == 2) {
            return new Vec3d(1.0, 0.0, 1.0);
        }
        if (meta == 4) {
            return new Vec3d(1.0, 0.0, 0.0);
        }
        if (meta == 5) {
            return new Vec3d(0.0, 0.0, 1.0);
        }
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public Vec3d getEntityPos(Entity e) {
        return new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5 - e.func_70033_W(), e.field_70161_v);
    }

    protected abstract List<Integer> getAmmoList();

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAmmoTypesForDisplay() {
        if (this.ammoStacks != null) {
            return this.ammoStacks;
        }
        this.ammoStacks = new ArrayList<ItemStack>();
        for (Integer i : this.getAmmoList()) {
            BulletConfiguration config = BulletConfigSyncingUtil.pullConfig(i);
            if (config == null || config.ammo == null) continue;
            this.ammoStacks.add(new ItemStack(config.ammo));
        }
        return this.ammoStacks;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return true;
    }

    public boolean hasPower() {
        return this.getPower() >= this.getConsumption();
    }

    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public int getPowerScaled(int scale) {
        return (int)(this.power * (long)scale / this.getMaxPower());
    }

    public long getConsumption() {
        return 100L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public BlockPos getControlPos() {
        return this.func_174877_v();
    }

    @Override
    public World getControlWorld() {
        return this.func_145831_w();
    }

    @Override
    public void receiveEvent(BlockPos from, ControlEvent e) {
        if (e.name.equals("turret_set_target")) {
            this.targetPlayers = e.vars.get("players").getBoolean();
            this.targetMobs = e.vars.get("hostile").getBoolean();
            this.targetAnimals = e.vars.get("passive").getBoolean();
            this.targetMachines = e.vars.get("machines").getBoolean();
        } else if (e.name.equals("turret_switch")) {
            this.isOn = e.vars.get("isOn").getBoolean();
        }
    }

    @Override
    public List<String> getInEvents() {
        return Arrays.asList("turret_set_target", "turret_switch");
    }

    public void func_145829_t() {
        super.func_145829_t();
        ControlEventSystem.get(this.field_145850_b).addControllable(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        ControlEventSystem.get(this.field_145850_b).removeControllable(this);
    }
}

