/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneRouter;
import com.hbm.inventory.gui.GUICraneRouter;
import com.hbm.modules.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCraneRouter
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
ITickable {
    public ModulePatternMatcher[] patterns = new ModulePatternMatcher[6];
    public int[] modes = new int[6];
    public static final int MODE_NONE = 0;
    public static final int MODE_WHITELIST = 1;
    public static final int MODE_BLACKLIST = 2;
    public static final int MODE_WILDCARD = 3;

    public TileEntityCraneRouter() {
        super(30);
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = new ModulePatternMatcher(5);
        }
    }

    @Override
    public String getName() {
        return "container.craneRouter";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound data = new NBTTagCompound();
            for (int i = 0; i < this.patterns.length; ++i) {
                NBTTagCompound compound = new NBTTagCompound();
                this.patterns[i].writeToNBT(compound);
                data.func_74782_a("pattern" + i, (NBTBase)compound);
            }
            data.func_74783_a("modes", this.modes);
            this.networkPack(data, 15);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        super.networkUnpack(data);
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = data.func_74775_l("pattern" + i);
            this.patterns[i].readFromNBT(compound);
        }
        this.modes = data.func_74759_k("modes");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneRouter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneRouter(player.field_71071_by, this);
    }

    public void nextMode(int index) {
        int matcher = index / 5;
        int mIndex = index % 5;
        this.patterns[matcher].nextMode(this.field_145850_b, this.inventory.getStackInSlot(index), mIndex);
    }

    public void initPattern(ItemStack stack, int index) {
        int matcher = index / 5;
        int mIndex = index % 5;
        this.patterns[matcher].initPatternSmart(this.field_145850_b, stack, mIndex);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = nbt.func_74775_l("pattern" + i);
            this.patterns[i].readFromNBT(compound);
        }
        this.modes = nbt.func_74759_k("modes");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            this.patterns[i].writeToNBT(compound);
            nbt.func_74782_a("pattern" + i, (NBTBase)compound);
        }
        nbt.func_74783_a("modes", this.modes);
        return nbt;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        int xCoord = this.field_174879_c.func_177958_n();
        int yCoord = this.field_174879_c.func_177956_o();
        int zCoord = this.field_174879_c.func_177952_p();
        return new Vec3d((double)xCoord - player.field_70165_t, (double)yCoord - player.field_70163_u, (double)zCoord - player.field_70161_v).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int i;
        int n = i = data.func_74762_e("toggle");
        this.modes[n] = this.modes[n] + 1;
        if (this.modes[i] > 3) {
            this.modes[i] = 0;
        }
    }
}

