/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneGrabber;
import com.hbm.inventory.gui.GUICraneGrabber;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.modules.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCraneGrabber
extends TileEntityCraneBase
implements IGUIProvider,
IControlReceiver {
    public boolean isWhitelist = false;
    public ModulePatternMatcher matcher = new ModulePatternMatcher(9);
    private int tickCounter = 0;
    private int delay = 20;

    public TileEntityCraneGrabber() {
        super(11);
    }

    @Override
    public String getName() {
        return "container.craneGrabber";
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickCounter;
            if (this.tickCounter >= this.delay && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
                this.tickCounter = 0;
                int amount = 1;
                if (this.inventory.getStackInSlot(9) != null && !this.inventory.getStackInSlot(9).func_190926_b()) {
                    if (this.inventory.getStackInSlot(9).func_77973_b() == ModItems.upgrade_stack_1) {
                        amount = 4;
                    } else if (this.inventory.getStackInSlot(9).func_77973_b() == ModItems.upgrade_stack_2) {
                        amount = 16;
                    } else if (this.inventory.getStackInSlot(9).func_77973_b() == ModItems.upgrade_stack_3) {
                        amount = 64;
                    }
                }
                this.delay = 20;
                if (this.inventory.getStackInSlot(10) != null && !this.inventory.getStackInSlot(10).func_190926_b()) {
                    if (this.inventory.getStackInSlot(10).func_77973_b() == ModItems.upgrade_ejector_1) {
                        this.delay = 10;
                    } else if (this.inventory.getStackInSlot(10).func_77973_b() == ModItems.upgrade_ejector_2) {
                        this.delay = 5;
                    } else if (this.inventory.getStackInSlot(10).func_77973_b() == ModItems.upgrade_ejector_3) {
                        this.delay = 2;
                    }
                }
                EnumFacing inputSide = this.getInputSide();
                double reach = 1.0;
                Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(inputSide)).func_177230_c();
                if (b == ModBlocks.conveyor_double) {
                    reach = 0.5;
                }
                if (b == ModBlocks.conveyor_triple) {
                    reach = 0.33;
                }
                double x = (double)(this.field_174879_c.func_177972_a(inputSide).func_177958_n() - this.field_174879_c.func_177958_n()) * reach + (double)this.field_174879_c.func_177958_n();
                double y = (double)(this.field_174879_c.func_177972_a(inputSide).func_177956_o() - this.field_174879_c.func_177956_o()) * reach + (double)this.field_174879_c.func_177956_o();
                double z = (double)(this.field_174879_c.func_177972_a(inputSide).func_177952_p() - this.field_174879_c.func_177952_p()) * reach + (double)this.field_174879_c.func_177952_p();
                List items = this.field_145850_b.func_72872_a(EntityMovingItem.class, new AxisAlignedBB(x + 0.1875, y + 0.1875, z + 0.1875, x + 0.8125, y + 0.8125, z + 0.8125));
                for (EntityMovingItem item : items) {
                    ItemStack stack = item.getItemStack().func_77946_l();
                    boolean match = this.matchesFilter(stack);
                    if (this.isWhitelist && !match || !this.isWhitelist && match) continue;
                    int count = stack.func_190916_E();
                    int toAdd = Math.min(count, amount);
                    stack.func_190920_e(toAdd);
                    this.tryFillTe(stack);
                    if (count - toAdd + stack.func_190916_E() <= 0) {
                        item.func_70106_y();
                        continue;
                    }
                    stack.func_190920_e(count - toAdd + stack.func_190916_E());
                    item.setItemStack(stack);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isWhitelist", this.isWhitelist);
            this.matcher.writeToNBT(data);
            this.networkPack(data, 15);
        }
    }

    public boolean tryFillTe(ItemStack stack) {
        TileEntity capte;
        EnumFacing outputSide = this.getOutputSide();
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(outputSide));
        if (te != null && (capte = te).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputSide)) {
            IItemHandler cap = (IItemHandler)capte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputSide);
            return this.tryInsertItemCap(cap, stack);
        }
        return false;
    }

    public boolean tryInsertItemCap(IItemHandler chest, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack outputStack = stack.func_77946_l();
            if (outputStack.func_190926_b() || outputStack.func_190916_E() == 0) {
                return true;
            }
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            int fillAmount = Math.min(chestItem.func_77976_d() - chestItem.func_190916_E(), outputStack.func_190916_E());
            outputStack.func_190920_e(fillAmount);
            ItemStack rest = chest.insertItem(i, outputStack, true);
            if (rest.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a)) continue;
            stack.func_190918_g(outputStack.func_190916_E());
            chest.insertItem(i, outputStack, false);
        }
        return false;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.modes = new String[this.matcher.modes.length];
        this.matcher.readFromNBT(nbt);
    }

    public boolean matchesFilter(ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.inventory.getStackInSlot(i);
            if (filter == null || !this.matcher.isValidForFilter(filter, i, stack)) continue;
            return true;
        }
        return false;
    }

    public void nextMode(int i) {
        this.matcher.nextMode(this.field_145850_b, this.inventory.getStackInSlot(i), i);
    }

    public void initPattern(ItemStack stack, int index) {
        this.matcher.initPatternSmart(this.field_145850_b, stack, index);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneGrabber(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneGrabber(player.field_71071_by, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isWhitelist", this.isWhitelist);
        this.matcher.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        int xCoord = this.field_174879_c.func_177958_n();
        int yCoord = this.field_174879_c.func_177956_o();
        int zCoord = this.field_174879_c.func_177952_p();
        return new Vec3d((double)xCoord - player.field_70165_t, (double)yCoord - player.field_70163_u, (double)zCoord - player.field_70161_v).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("isWhitelist")) {
            this.isWhitelist = !this.isWhitelist;
        }
    }
}

