/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.block.IConveyorBelt;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneExtractor;
import com.hbm.inventory.gui.GUICraneExtractor;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.modules.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCraneExtractor
extends TileEntityCraneBase
implements IGUIProvider,
IControlReceiver {
    public boolean isWhitelist = false;
    private int tickCounter = 0;
    public ModulePatternMatcher matcher = new ModulePatternMatcher(9);
    public static int[] allowed_slots = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};

    public TileEntityCraneExtractor() {
        super(20);
    }

    @Override
    public String getName() {
        return "container.craneExtractor";
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickCounter;
            int xCoord = this.field_174879_c.func_177958_n();
            int yCoord = this.field_174879_c.func_177956_o();
            int zCoord = this.field_174879_c.func_177952_p();
            int delay = 20;
            if (this.inventory.getStackInSlot(19) != null && this.inventory.getStackInSlot(19) != ItemStack.field_190927_a) {
                if (this.inventory.getStackInSlot(19).func_77973_b() == ModItems.upgrade_ejector_1) {
                    delay = 10;
                } else if (this.inventory.getStackInSlot(19).func_77973_b() == ModItems.upgrade_ejector_2) {
                    delay = 5;
                } else if (this.inventory.getStackInSlot(19).func_77973_b() == ModItems.upgrade_ejector_3) {
                    delay = 2;
                }
            }
            if (this.tickCounter >= delay && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
                int toSend;
                boolean match;
                ItemStack stack;
                TileEntity capte;
                this.tickCounter = 0;
                int amount = 1;
                if (this.inventory.getStackInSlot(18) != null && this.inventory.getStackInSlot(18) != ItemStack.field_190927_a) {
                    if (this.inventory.getStackInSlot(18).func_77973_b() == ModItems.upgrade_stack_1) {
                        amount = 4;
                    } else if (this.inventory.getStackInSlot(18).func_77973_b() == ModItems.upgrade_stack_2) {
                        amount = 16;
                    } else if (this.inventory.getStackInSlot(18).func_77973_b() == ModItems.upgrade_stack_3) {
                        amount = 64;
                    }
                }
                EnumFacing inputSide = this.getInputSide();
                EnumFacing outputSide = this.getOutputSide();
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(inputSide));
                Block b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(outputSide)).func_177230_c();
                int[] access = null;
                ISidedInventory sided = null;
                if (te instanceof ISidedInventory && !(te instanceof TileEntityCraneExtractor)) {
                    sided = (ISidedInventory)te;
                    access = TileEntityCraneExtractor.masquerade(sided, EnumFacing.func_82600_a((int)inputSide.func_176734_d().ordinal()));
                }
                if (te != null && (capte = te).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inputSide)) {
                    IItemHandler inv = (IItemHandler)capte.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inputSide);
                    int size = access == null ? inv.getSlots() : access.length;
                    for (int i = 0; i < size; ++i) {
                        int fill;
                        ItemStack excrated;
                        int index = access == null ? i : access[i];
                        stack = inv.getStackInSlot(index);
                        if (stack == ItemStack.field_190927_a || sided != null && !sided.func_180461_b(index, stack, EnumFacing.func_82600_a((int)inputSide.func_176734_d().ordinal()))) continue;
                        match = this.matchesFilter(stack);
                        if ((!this.isWhitelist || !match) && (this.isWhitelist || match) || (excrated = inv.extractItem(i, toSend = stack.func_190916_E(), true)) == null || excrated.func_190926_b() || (fill = this.tryInsertItemCap((IItemHandler)this.inventory, excrated.func_77946_l(), allowed_slots)) <= 0 || fill > toSend) continue;
                        inv.extractItem(i, fill, false);
                    }
                }
                if (b instanceof IConveyorBelt) {
                    IConveyorBelt belt = (IConveyorBelt)b;
                    for (int index : allowed_slots) {
                        stack = this.inventory.getStackInSlot(index);
                        if (stack == ItemStack.field_190927_a || sided != null && !sided.func_180461_b(index, stack, EnumFacing.func_82600_a((int)inputSide.func_176734_d().ordinal()))) continue;
                        match = this.matchesFilter(stack);
                        if ((!this.isWhitelist || !match) && (this.isWhitelist || match)) continue;
                        toSend = Math.min(amount, stack.func_190916_E());
                        ItemStack cStack = stack.func_77946_l();
                        stack.func_190918_g(toSend);
                        if (stack.func_190916_E() == 0) {
                            this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
                        }
                        cStack.func_190920_e(toSend);
                        EntityMovingItem moving = new EntityMovingItem(this.field_145850_b);
                        Vec3d pos = new Vec3d((double)xCoord + 0.5 + (double)outputSide.func_176730_m().func_177958_n() * 0.55, (double)yCoord + 0.5 + (double)outputSide.func_176730_m().func_177956_o() * 0.55, (double)zCoord + 0.5 + (double)outputSide.func_176730_m().func_177952_p() * 0.55);
                        Vec3d snap = belt.getClosestSnappingPosition(this.field_145850_b, new BlockPos(xCoord + outputSide.func_176730_m().func_177958_n(), yCoord + outputSide.func_176730_m().func_177956_o(), zCoord + outputSide.func_176730_m().func_177952_p()), pos);
                        moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                        moving.setItemStack(cStack);
                        this.field_145850_b.func_72838_d((Entity)moving);
                        break;
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isWhitelist", this.isWhitelist);
            this.matcher.writeToNBT(data);
            this.networkPack(data, 15);
        }
    }

    public int tryInsertItemCap(IItemHandler chest, ItemStack stack, int[] allowed_slots) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int filledAmount = 0;
        for (int i : allowed_slots) {
            if (stack.func_190926_b() || stack.func_190916_E() < 1) {
                return filledAmount;
            }
            ItemStack outputStack = stack.func_77946_l();
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            int fillAmount = Math.min(chestItem.func_77976_d() - chestItem.func_190916_E(), outputStack.func_190916_E());
            outputStack.func_190920_e(fillAmount);
            ItemStack rest = chest.insertItem(i, outputStack, true);
            stack.func_190918_g(fillAmount - rest.func_190916_E());
            filledAmount += fillAmount - rest.func_190916_E();
            chest.insertItem(i, outputStack, false);
        }
        return filledAmount;
    }

    public static int[] masquerade(ISidedInventory sided, EnumFacing side) {
        if (sided instanceof TileEntityFurnace) {
            return new int[]{2};
        }
        return sided.func_180463_a(side);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.modes = new String[this.matcher.modes.length];
        this.matcher.readFromNBT(nbt);
    }

    public boolean matchesFilter(ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.inventory.getStackInSlot(i);
            if (filter == null || !this.matcher.isValidForFilter(filter, i, stack)) continue;
            return true;
        }
        return false;
    }

    public void nextMode(int i) {
        this.matcher.nextMode(this.field_145850_b, this.inventory.getStackInSlot(i), i);
    }

    public void initPattern(ItemStack stack, int index) {
        this.matcher.initPatternSmart(this.field_145850_b, stack, index);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        return i > 8 && i < 18;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneExtractor(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneExtractor(player.field_71071_by, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isWhitelist", this.isWhitelist);
        this.matcher.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        int xCoord = this.field_174879_c.func_177958_n();
        int yCoord = this.field_174879_c.func_177956_o();
        int zCoord = this.field_174879_c.func_177952_p();
        return new Vec3d((double)xCoord - player.field_70165_t, (double)yCoord - player.field_70163_u, (double)zCoord - player.field_70161_v).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("isWhitelist")) {
            this.isWhitelist = !this.isWhitelist;
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return allowed_slots;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return false;
    }
}

