/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.HeatRecipes;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemForgeFluidIdentifier;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityRBMKHeater
extends TileEntityRBMKSlottedBase
implements IFluidHandler,
ITankPacketAcceptor {
    public static final double TU_PER_DEGREE = 3000.0;
    public FluidTank[] tanks = new FluidTank[2];
    public Fluid[] tankTypes = new Fluid[2];

    public TileEntityRBMKHeater() {
        super(1);
        this.tanks[0] = new FluidTank(ModForgeFluids.coolant, 0, 16000);
        this.tankTypes[0] = ModForgeFluids.coolant;
        this.tanks[1] = new FluidTank(ModForgeFluids.hotcoolant, 0, 16000);
        this.tankTypes[1] = ModForgeFluids.hotcoolant;
    }

    @Override
    public String getName() {
        return "container.rbmkHeater";
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Fluid hotFluid;
            double tempRange;
            this.setFluidType();
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0], this.tanks[1]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            if (HeatRecipes.hasBoilRecipe(this.tankTypes[0]) && (tempRange = this.heat - (double)((hotFluid = HeatRecipes.getBoilFluid(this.tankTypes[0])).getTemperature() - 273)) > 0.0) {
                int heatReq = HeatRecipes.getRequiredHeat(this.tankTypes[0]);
                int inputAmount = HeatRecipes.getInputAmountHot(this.tankTypes[0]);
                int outputAmount = HeatRecipes.getOutputAmountHot(this.tankTypes[0]);
                int inputOps = this.tanks[0].getFluidAmount() / inputAmount;
                int outputOps = (this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount()) / outputAmount;
                int tempOps = (int)Math.floor(tempRange * 3000.0 / (double)heatReq);
                int ops = Math.min(inputOps, Math.min(outputOps, tempOps));
                this.tanks[0].drain(inputAmount * ops, true);
                this.tanks[1].fill(new FluidStack(this.tankTypes[1], outputAmount * ops), true);
                this.heat -= (double)(heatReq * ops) / 3000.0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            data.func_74778_a("tankTypes0", this.tankTypes[0].getName());
            data.func_74778_a("tankTypes1", this.tankTypes[1].getName());
            this.networkPack(data, 25);
            if (this.tanks[1].getFluidAmount() > 0) {
                this.fillFluidInit(this.tanks[1]);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        super.networkUnpack(nbt);
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        if (nbt.func_74764_b("tankTypes0")) {
            this.tankTypes[0] = FluidRegistry.getFluid((String)nbt.func_74779_i("tankTypes0"));
        }
        if (nbt.func_74764_b("tankTypes1")) {
            this.tankTypes[1] = FluidRegistry.getFluid((String)nbt.func_74779_i("tankTypes1"));
        }
    }

    public void setFluidType() {
        ItemStack inFluid = this.inventory.getStackInSlot(0);
        if (inFluid.func_77973_b() == ModItems.forge_fluid_identifier) {
            this.setFluidTypes(ItemForgeFluidIdentifier.getType(inFluid));
        }
        if (this.tankTypes[0] == null) {
            this.setFluidTypes(ModForgeFluids.coolant);
        }
    }

    public void setFluidTypes(Fluid f) {
        if (HeatRecipes.hasBoilRecipe(f) && this.tankTypes[0] != f) {
            this.tankTypes[0] = f;
            this.tankTypes[1] = HeatRecipes.getBoilFluid(f);
            this.tanks[0].setFluid(new FluidStack(f, 0));
            this.tanks[1].setFluid(new FluidStack(this.tankTypes[1], 0));
            this.func_70296_d();
        }
    }

    public void fillFluidInit(FluidTank tank) {
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + rbmkHeight + 1, this.field_174879_c.func_177952_p(), tank);
        if (this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p())).func_177230_c() == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
        }
        if (this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p())).func_177230_c() == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p() + 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p() - 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 3, this.field_174879_c.func_177952_p(), tank);
        }
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), tank.getCapacity());
    }

    @Override
    public void getDiagData(NBTTagCompound nbt) {
        this.func_189515_b(nbt);
        nbt.func_82580_o("jumpheight");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tanks0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tanks1"));
        if (nbt.func_74764_b("tankTypes0")) {
            this.tankTypes[0] = FluidRegistry.getFluid((String)nbt.func_74779_i("tankTypes0"));
        }
        if (nbt.func_74764_b("tankTypes1")) {
            this.tankTypes[1] = FluidRegistry.getFluid((String)nbt.func_74779_i("tankTypes1"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("tanks0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tanks1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74778_a("tankTypes0", this.tankTypes[0].getName());
        nbt.func_74778_a("tankTypes1", this.tankTypes[1].getName());
        return nbt;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 2) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
    }

    @Override
    public void onMelt(int reduce) {
        int count = 1 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        super.onMelt(reduce);
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.HEATEX;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("inputFluidAmount", this.tanks[0].getFluidAmount());
        data.func_74768_a("inputFluidMax", this.tanks[0].getCapacity());
        data.func_74768_a("outputFluidAmount", this.tanks[1].getFluidAmount());
        data.func_74768_a("outputFluidMax", this.tanks[1].getCapacity());
        data.func_74778_a("inputFluid", this.tankTypes[0].getLocalizedName(new FluidStack(this.tankTypes[0], 0)));
        data.func_74778_a("outputFluid", this.tankTypes[1].getLocalizedName(new FluidStack(this.tankTypes[1], 0)));
        return data;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.amount > 0 && resource.getFluid() == this.tankTypes[0] && HeatRecipes.hasBoilRecipe(resource.getFluid())) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.amount > 0 && resource.getFluid() == this.tankTypes[1]) {
            return this.tanks[1].drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain > 0) {
            return this.tanks[1].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Map<String, DataValue> getQueryData() {
        Map<String, DataValue> data = super.getQueryData();
        data.put("t0_fluidType", new DataValueString(this.tankTypes[0].getName()));
        data.put("t0_fluidAmount", new DataValueFloat(this.tanks[0].getFluidAmount()));
        data.put("t1_fluidType", new DataValueString(this.tankTypes[1].getName()));
        data.put("t1_fluidAmount", new DataValueFloat(this.tanks[1].getFluidAmount()));
        return data;
    }
}

