/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.lib.Library;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBoiler;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControlManual;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKCooler;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKHeater;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKOutgasser;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKConsole
extends TileEntityMachineBase
implements IControlReceiver,
ITickable,
SimpleComponent {
    private int targetX;
    private int targetY;
    private int targetZ;
    protected static int lookbackLength = 40;
    public RBMKColumn[] columns = new RBMKColumn[225];
    public RBMKScreen[] screens = new RBMKScreen[6];
    public RBMKGraph graph = new RBMKGraph();

    public TileEntityRBMKConsole() {
        super(0);
        for (int i = 0; i < this.screens.length; ++i) {
            this.screens[i] = new RBMKScreen();
        }
    }

    @Override
    public String getName() {
        return null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.rescan();
                this.prepareScreenInfo();
                this.prepareGraphInfo();
            }
            this.prepareNetworkPack();
        }
    }

    private void rescan() {
        for (int i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + i, this.targetY, this.targetZ + j));
                int index = i + 7 + (j + 7) * 15;
                if (te instanceof TileEntityRBMKBase) {
                    TileEntityRBMKBase rbmk = (TileEntityRBMKBase)te;
                    this.columns[index] = new RBMKColumn(rbmk.getConsoleType(), rbmk.getNBTForConsole());
                    this.columns[index].data.func_74780_a("heat", rbmk.heat);
                    this.columns[index].data.func_74780_a("maxHeat", rbmk.maxHeat());
                    this.columns[index].data.func_74780_a("realSimWater", (double)rbmk.water);
                    this.columns[index].data.func_74780_a("realSimSteam", (double)rbmk.steam);
                    if (!rbmk.isModerated()) continue;
                    this.columns[index].data.func_74757_a("moderated", true);
                    continue;
                }
                this.columns[index] = null;
            }
        }
    }

    public void setupDisplays() {
        this.rescan();
        this.setupScreensAndGraph();
        this.prepareScreenInfo();
        this.prepareGraphInfo();
        this.prepareNetworkPack();
    }

    public void setupScreensAndGraph() {
        ArrayList<Integer> fuelRods = new ArrayList<Integer>();
        ArrayList<Integer> controlRods = new ArrayList<Integer>();
        block4: for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            switch (this.columns[i].type) {
                case FUEL: 
                case FUEL_SIM: {
                    fuelRods.add(i);
                    continue block4;
                }
                case CONTROL: 
                case CONTROL_AUTO: {
                    controlRods.add(i);
                }
            }
        }
        Integer[] fuelIndices = fuelRods.toArray(new Integer[fuelRods.size()]);
        Integer[] controlIndices = controlRods.toArray(new Integer[controlRods.size()]);
        this.screens[0] = new RBMKScreen(ScreenType.COL_TEMP, fuelIndices, null);
        this.screens[1] = new RBMKScreen(ScreenType.FUEL_TEMP, fuelIndices, null);
        this.screens[2] = new RBMKScreen(ScreenType.ROD_EXTRACTION, controlIndices, null);
        this.screens[3] = new RBMKScreen(ScreenType.FLUX, fuelIndices, null);
        this.screens[4] = new RBMKScreen(ScreenType.FUEL_DEPLETION, fuelIndices, null);
        this.screens[5] = new RBMKScreen(ScreenType.FUEL_POISON, fuelIndices, null);
        this.graph = new RBMKGraph(ScreenType.FLUX, fuelIndices);
    }

    private void prepareGraphInfo() {
        if (this.graph.type == ScreenType.NONE) {
            this.graph.dataBuffer = new int[lookbackLength];
            return;
        }
        double value = 0.0;
        int count = 0;
        block8: for (Integer i : this.graph.columns) {
            RBMKColumn col = this.columns[i];
            if (col == null) continue;
            switch (this.graph.type) {
                case COL_TEMP: {
                    ++count;
                    value += col.data.func_74769_h("heat");
                    continue block8;
                }
                case FUEL_DEPLETION: {
                    if (!col.data.func_74764_b("enrichment")) continue block8;
                    ++count;
                    value += 100.0 - col.data.func_74769_h("enrichment") * 100.0;
                    continue block8;
                }
                case FUEL_POISON: {
                    if (!col.data.func_74764_b("xenon")) continue block8;
                    ++count;
                    value += col.data.func_74769_h("xenon");
                    continue block8;
                }
                case FUEL_TEMP: {
                    if (!col.data.func_74764_b("c_heat")) continue block8;
                    ++count;
                    value += col.data.func_74769_h("c_heat");
                    continue block8;
                }
                case FLUX: {
                    if (!col.data.func_74764_b("flux")) continue block8;
                    ++count;
                    value += col.data.func_74769_h("flux");
                    continue block8;
                }
                case ROD_EXTRACTION: {
                    if (!col.data.func_74764_b("level")) continue block8;
                    ++count;
                    value += col.data.func_74769_h("level") * 100.0;
                }
            }
        }
        double result = value / (double)count;
        for (int i = 0; i < this.graph.dataBuffer.length - 1; ++i) {
            this.graph.dataBuffer[i] = this.graph.dataBuffer[i + 1];
        }
        this.graph.dataBuffer[this.graph.dataBuffer.length - 1] = (int)result;
    }

    private void prepareScreenInfo() {
        for (RBMKScreen screen : this.screens) {
            if (screen.type == ScreenType.NONE) {
                screen.display = null;
                continue;
            }
            double value = 0.0;
            int count = 0;
            block17: for (Integer i : screen.columns) {
                RBMKColumn col = this.columns[i];
                if (col == null) continue;
                switch (screen.type) {
                    case COL_TEMP: {
                        ++count;
                        value += col.data.func_74769_h("heat");
                        continue block17;
                    }
                    case FUEL_DEPLETION: {
                        if (!col.data.func_74764_b("enrichment")) continue block17;
                        ++count;
                        value += 100.0 - col.data.func_74769_h("enrichment") * 100.0;
                        continue block17;
                    }
                    case FUEL_POISON: {
                        if (!col.data.func_74764_b("xenon")) continue block17;
                        ++count;
                        value += col.data.func_74769_h("xenon");
                        continue block17;
                    }
                    case FUEL_TEMP: {
                        if (!col.data.func_74764_b("c_heat")) continue block17;
                        ++count;
                        value += col.data.func_74769_h("c_heat");
                        continue block17;
                    }
                    case FLUX: {
                        if (!col.data.func_74764_b("flux")) continue block17;
                        ++count;
                        value += col.data.func_74769_h("flux");
                        continue block17;
                    }
                    case ROD_EXTRACTION: {
                        if (!col.data.func_74764_b("level")) continue block17;
                        ++count;
                        value += col.data.func_74769_h("level") * 100.0;
                    }
                }
            }
            double result = value / (double)count;
            String text = (double)((int)(result * 10.0)) / 10.0 + "";
            switch (screen.type) {
                case COL_TEMP: {
                    text = "rbmk.screen.temp=" + text + "\u00b0C";
                    break;
                }
                case FUEL_DEPLETION: {
                    text = "rbmk.screen.depletion=" + text + "%";
                    break;
                }
                case FUEL_POISON: {
                    text = "rbmk.screen.xenon=" + text + "%";
                    break;
                }
                case FUEL_TEMP: {
                    text = "rbmk.screen.core=" + text + "\u00b0C";
                    break;
                }
                case FLUX: {
                    text = "rbmk.screen.flux=" + text;
                    break;
                }
                case ROD_EXTRACTION: {
                    text = "rbmk.screen.rod=" + text + "%";
                }
            }
            screen.display = text;
        }
    }

    private void prepareNetworkPack() {
        RBMKScreen screen;
        int i;
        NBTTagCompound data = new NBTTagCompound();
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            data.func_74757_a("full", true);
            for (i = 0; i < this.columns.length; ++i) {
                if (this.columns[i] == null) continue;
                data.func_74782_a("column_" + i, (NBTBase)this.columns[i].data);
                data.func_74777_a("type_" + i, (short)this.columns[i].type.ordinal());
            }
            data.func_74783_a("buffer", this.graph.dataBuffer);
            for (i = 0; i < this.screens.length; ++i) {
                screen = this.screens[i];
                if (screen.display == null) continue;
                data.func_74778_a("t" + i, screen.display);
            }
        }
        for (i = 0; i < this.screens.length; ++i) {
            screen = this.screens[i];
            data.func_74774_a("s" + i, (byte)screen.type.ordinal());
        }
        data.func_74774_a("g", (byte)this.graph.type.ordinal());
        this.networkPack(data, 50);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        RBMKScreen screen;
        int i;
        if (data.func_74767_n("full")) {
            this.columns = new RBMKColumn[225];
            for (i = 0; i < this.columns.length; ++i) {
                if (!data.func_74764_b("type_" + i)) continue;
                this.columns[i] = new RBMKColumn(ColumnType.values()[data.func_74765_d("type_" + i)], (NBTTagCompound)data.func_74781_a("column_" + i));
            }
            this.graph.dataBuffer = data.func_74759_k("buffer");
            for (i = 0; i < this.screens.length; ++i) {
                screen = this.screens[i];
                screen.display = data.func_74779_i("t" + i);
            }
        }
        for (i = 0; i < this.screens.length; ++i) {
            screen = this.screens[i];
            screen.type = ScreenType.values()[data.func_74771_c("s" + i)];
        }
        this.graph.type = ScreenType.values()[data.func_74771_c("g")];
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.createVectorHelper((double)this.field_174879_c.func_177958_n() - player.field_70165_t, (double)this.field_174879_c.func_177956_o() - player.field_70163_u, (double)this.field_174879_c.func_177952_p() - player.field_70161_v).lengthVector() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("level")) {
            Set keys = data.func_150296_c();
            for (String key : keys) {
                int z;
                int x;
                TileEntity te;
                if (!key.startsWith("sel_") || !((te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + (x = data.func_74762_e(key) % 15 - 7), this.targetY, this.targetZ + (z = data.func_74762_e(key) / 15 - 7)))) instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                rod.setTarget(MathHelper.func_151237_a((double)data.func_74769_h("level"), (double)0.0, (double)1.0));
                te.func_70296_d();
            }
        }
        if (data.func_74764_b("toggle")) {
            ScreenType type;
            byte slot = data.func_74771_c("toggle");
            if (slot == 99) {
                int next = this.graph.type.ordinal() + 1;
                this.graph.type = type = ScreenType.values()[next % ScreenType.values().length];
                this.graph.dataBuffer = new int[lookbackLength];
                Arrays.fill(this.graph.dataBuffer, 0);
            } else {
                int next = this.screens[slot].type.ordinal() + 1;
                this.screens[slot].type = type = ScreenType.values()[next % ScreenType.values().length];
            }
        }
        if (data.func_74764_b("id")) {
            byte slot = data.func_74771_c("id");
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < 225; ++i) {
                if (!data.func_74767_n("s" + i)) continue;
                list.add(i);
            }
            Integer[] cols = list.toArray(new Integer[0]);
            if (slot == 99) {
                this.graph.columns = cols;
            } else {
                this.screens[slot].columns = cols;
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 3), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetX = nbt.func_74762_e("tX");
        this.targetY = nbt.func_74762_e("tY");
        this.targetZ = nbt.func_74762_e("tZ");
        for (int i = 0; i < this.screens.length; ++i) {
            this.screens[i].type = ScreenType.values()[nbt.func_74771_c("t" + i)];
            this.screens[i].columns = (Integer[])Arrays.stream(nbt.func_74759_k("s" + i)).boxed().toArray(Integer[]::new);
        }
        this.graph.type = ScreenType.values()[nbt.func_74771_c("g")];
        this.graph.columns = (Integer[])Arrays.stream(nbt.func_74759_k("gc")).boxed().toArray(Integer[]::new);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tY", this.targetY);
        nbt.func_74768_a("tZ", this.targetZ);
        for (int i = 0; i < this.screens.length; ++i) {
            nbt.func_74774_a("t" + i, (byte)this.screens[i].type.ordinal());
            nbt.func_74783_a("s" + i, Arrays.stream(this.screens[i].columns).mapToInt(Integer::intValue).toArray());
        }
        nbt.func_74774_a("g", (byte)this.graph.type.ordinal());
        nbt.func_74783_a("gc", Arrays.stream(this.graph.columns).mapToInt(Integer::intValue).toArray());
        return nbt;
    }

    public String getComponentName() {
        return "rbmk_console";
    }

    @Callback(direct=true, doc="getColumnData(x:int, y:int); retrieves data for column @(x,y) 0,0 is in left bottom and y is up and x is right")
    public Object[] getColumnData(Context context, Arguments args) {
        int x = args.checkInteger(0) - 7;
        int y = -args.checkInteger(1) + 7;
        int i = (y + 7) * 15 + (x + 7);
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + x, this.targetY, this.targetZ + y));
        if (te instanceof TileEntityRBMKBase) {
            TileEntityRBMKBase column = (TileEntityRBMKBase)te;
            NBTTagCompound column_data = this.columns[i].data;
            LinkedHashMap<String, Object> data_table = new LinkedHashMap<String, Object>();
            data_table.put("type", column.getConsoleType().name());
            data_table.put("hullTemp", column_data.func_74769_h("heat"));
            data_table.put("realSimWater", column_data.func_74769_h("realSimWater"));
            data_table.put("realSimSteam", column_data.func_74769_h("realSimSteam"));
            data_table.put("moderated", column_data.func_74767_n("moderated"));
            data_table.put("level", column_data.func_74769_h("level"));
            data_table.put("color", column_data.func_74765_d("color"));
            data_table.put("enrichment", column_data.func_74769_h("enrichment"));
            data_table.put("xenon", column_data.func_74769_h("xenon"));
            data_table.put("coreSkinTemp", column_data.func_74769_h("c_heat"));
            data_table.put("coreTemp", column_data.func_74769_h("c_coreHeat"));
            data_table.put("coreMaxTemp", column_data.func_74769_h("c_maxHeat"));
            if (te instanceof TileEntityRBMKRod) {
                TileEntityRBMKRod fuelChannel = (TileEntityRBMKRod)te;
                data_table.put("fluxSlow", fuelChannel.fluxSlow);
                data_table.put("fluxFast", fuelChannel.fluxFast);
            }
            if (te instanceof TileEntityRBMKBoiler) {
                TileEntityRBMKBoiler boiler = (TileEntityRBMKBoiler)te;
                data_table.put("water", boiler.feed.getFluidAmount());
                data_table.put("steam", boiler.steam.getFluidAmount());
            }
            if (te instanceof TileEntityRBMKOutgasser) {
                TileEntityRBMKOutgasser irradiationChannel = (TileEntityRBMKOutgasser)te;
                data_table.put("fluxProgress", irradiationChannel.progress);
                data_table.put("requiredFlux", irradiationChannel.duration);
            }
            if (te instanceof TileEntityRBMKCooler) {
                TileEntityRBMKCooler coolingChannel = (TileEntityRBMKCooler)te;
                data_table.put("degreesCooledPerTick", coolingChannel.lastCooled);
                data_table.put("cryogel", coolingChannel.tank.getFluidAmount());
            }
            if (te instanceof TileEntityRBMKHeater) {
                TileEntityRBMKHeater heaterChannel = (TileEntityRBMKHeater)te;
                data_table.put("coolant", heaterChannel.tanks[0].getFluidAmount());
                data_table.put("hotcoolant", heaterChannel.tanks[1].getFluidAmount());
            }
            return new Object[]{data_table};
        }
        return new Object[]{"No rbmkrod found at " + (x + 7) + "," + (7 - y)};
    }

    @Callback(doc="getRBMKPos(); retrieves position of connected center rbmk rod")
    public Object[] getRBMKPos(Context context, Arguments args) {
        if (this.targetX != 0 || this.targetY != 0 || this.targetZ != 0) {
            LinkedHashMap<String, Integer> data_table = new LinkedHashMap<String, Integer>();
            data_table.put("rbmkCenterX", this.targetX);
            data_table.put("rbmkCenterY", this.targetY);
            data_table.put("rbmkCenterZ", this.targetZ);
            return new Object[]{data_table};
        }
        return new Object[]{null};
    }

    @Callback(doc="setLevel(level:double); set retraction of all control rods given 0\u2264level\u22641")
    public Object[] setLevel(Context context, Arguments args) {
        double new_level = args.checkDouble(0);
        boolean foundRods = false;
        for (int i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + i, this.targetY, this.targetZ + j));
                if (!(te instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                new_level = Math.min(1.0, Math.max(0.0, new_level));
                rod.setTarget(new_level);
                te.func_70296_d();
                foundRods = true;
            }
        }
        if (foundRods) {
            return new Object[]{"Controlrods set to " + new_level * 100.0 + "%"};
        }
        return new Object[]{"No controlrods found"};
    }

    @Callback(doc="setColumnLevel(x:int, y:int, level:double); set retraction of control rod @(x,y) given 0\u2264level\u22641")
    public Object[] setColumnLevel(Context context, Arguments args) {
        int x = args.checkInteger(0) - 7;
        int y = -args.checkInteger(1) + 7;
        double new_level = args.checkDouble(2);
        TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + x, this.targetY, this.targetZ + y));
        if (te instanceof TileEntityRBMKControlManual) {
            TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
            rod.startingLevel = rod.level;
            new_level = Math.min(1.0, Math.max(0.0, new_level));
            rod.setTarget(new_level);
            te.func_70296_d();
            return new Object[]{"Controlrod at " + (x + 7) + "," + (7 - y) + " set to " + new_level * 100.0 + "%"};
        }
        return new Object[]{"No controlrod found at " + (x + 7) + "," + (7 - y)};
    }

    @Callback(doc="setColorLevel(color:int, level:double); set retraction of control rods of color given 0\u2264level\u22641. Color is (RED:0, YELLOW:1, GREEN:2, BLUE:3, PURPLE:4)")
    public Object[] setColorLevel(Context context, Arguments args) {
        int color = args.checkInteger(0);
        double new_level = args.checkDouble(1);
        boolean foundRods = false;
        if (color >= 0 && color <= 4) {
            for (int i = -7; i <= 7; ++i) {
                for (int j = -7; j <= 7; ++j) {
                    TileEntityRBMKControlManual rod;
                    TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + i, this.targetY, this.targetZ + j));
                    if (!(te instanceof TileEntityRBMKControlManual) || !(rod = (TileEntityRBMKControlManual)te).isSameColor(color)) continue;
                    rod.startingLevel = rod.level;
                    new_level = Math.min(1.0, Math.max(0.0, new_level));
                    rod.setTarget(new_level);
                    te.func_70296_d();
                    foundRods = true;
                }
            }
            if (foundRods) {
                return new Object[]{"Color " + color + " set to " + new_level};
            }
            return new Object[]{"No rods for color " + color + " found"};
        }
        return new Object[]{"Color " + color + " does not exist"};
    }

    @Callback(doc="setColor(x:int, y:int, color:int); set color of control rod @(x,y) where color is (RED:0, YELLOW:1, GREEN:2, BLUE:3, PURPLE:4)")
    public Object[] setColor(Context context, Arguments args) {
        int x = args.checkInteger(0) - 7;
        int y = -args.checkInteger(1) + 7;
        int new_color = args.checkInteger(2);
        if (new_color >= 0 && new_color <= 4) {
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + x, this.targetY, this.targetZ + y));
            if (te instanceof TileEntityRBMKControlManual) {
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.setColor(new_color);
                te.func_70296_d();
                return new Object[]{"Rod at " + (x + 7) + "," + (7 - y) + " set to color " + new_color};
            }
            return new Object[]{"No controlrod found at " + (x + 7) + "," + (7 - y)};
        }
        return new Object[]{"Color " + new_color + " does not exist"};
    }

    @Callback(doc="pressAZ5(); shut down EVERYTHING!!")
    public Object[] pressAZ5(Context context, Arguments args) {
        boolean hasRods = false;
        for (int i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.targetX + i, this.targetY, this.targetZ + j));
                if (!(te instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                rod.setTarget(0.0);
                te.func_70296_d();
                hasRods = true;
            }
        }
        if (hasRods) {
            return new Object[]{"All rods inserted"};
        }
        return new Object[]{"No rods found"};
    }

    public static enum ScreenType {
        NONE(0),
        COL_TEMP(18),
        FUEL_TEMP(90),
        ROD_EXTRACTION(36),
        FLUX(108),
        FUEL_DEPLETION(54),
        FUEL_POISON(72);

        public int offset;

        private ScreenType(int offset) {
            this.offset = offset;
        }
    }

    public class RBMKGraph {
        public ScreenType type = ScreenType.NONE;
        public Integer[] columns = new Integer[0];
        public int[] dataBuffer = new int[lookbackLength];

        public RBMKGraph() {
            Arrays.fill(this.dataBuffer, 0);
        }

        public RBMKGraph(ScreenType type, Integer[] columns) {
            this.type = type;
            this.columns = columns;
            Arrays.fill(this.dataBuffer, 0);
        }

        public RBMKGraph(ScreenType type, Integer[] columns, int[] dataBuffer) {
            this.type = type;
            this.columns = columns;
            this.dataBuffer = dataBuffer;
        }
    }

    public class RBMKScreen {
        public ScreenType type = ScreenType.NONE;
        public Integer[] columns = new Integer[0];
        public String display = null;

        public RBMKScreen() {
        }

        public RBMKScreen(ScreenType type, Integer[] columns, String display) {
            this.type = type;
            this.columns = columns;
            this.display = display;
        }
    }

    public static enum ColumnType {
        BLANK(0),
        FUEL(10),
        FUEL_SIM(90),
        CONTROL(20),
        CONTROL_AUTO(30),
        BOILER(40),
        MODERATOR(50),
        ABSORBER(60),
        REFLECTOR(70),
        OUTGASSER(80),
        BREEDER(100),
        STORAGE(110),
        COOLER(120),
        HEATEX(130);

        public int offset;

        private ColumnType(int offset) {
            this.offset = offset;
        }
    }

    public static class RBMKColumn {
        public ColumnType type;
        public NBTTagCompound data;

        public RBMKColumn(ColumnType type) {
            this.type = type;
        }

        public RBMKColumn(ColumnType type, NBTTagCompound data) {
            this.type = type;
            this.data = data != null ? data : new NBTTagCompound();
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getFancyStats() {
            if (this.data == null) {
                return null;
            }
            ArrayList<String> stats = new ArrayList<String>();
            stats.add(TextFormatting.YELLOW + I18nUtil.resolveKey("rbmk.heat", (double)((int)(this.data.func_74769_h("heat") * 10.0)) / 10.0 + "\u00b0C"));
            switch (this.type) {
                case HEATEX: {
                    stats.add(TextFormatting.AQUA + I18nUtil.resolveKey("rbmk.heater.fluid", this.data.func_74779_i("inputFluid"), this.data.func_74762_e("inputFluidAmount"), this.data.func_74762_e("inputFluidMax")));
                    stats.add(TextFormatting.RED + I18nUtil.resolveKey("rbmk.heater.fluid", this.data.func_74779_i("outputFluid"), this.data.func_74762_e("outputFluidAmount"), this.data.func_74762_e("outputFluidMax")));
                    break;
                }
                case FUEL: 
                case FUEL_SIM: {
                    if (this.data.func_74764_b("rod_name")) {
                        stats.add("\u00a73" + I18n.func_135052_a((String)"rbmk.rod.name", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)(this.data.func_74779_i("rod_name") + ".name"), (Object[])new Object[0]));
                    } else {
                        stats.add("\u00a73" + I18n.func_135052_a((String)"rbmk.rod.name", (Object[])new Object[0]));
                    }
                    stats.add(TextFormatting.GREEN + I18nUtil.resolveKey("rbmk.rod.flux", (int)this.data.func_74769_h("flux")));
                    stats.add(TextFormatting.DARK_GREEN + I18nUtil.resolveKey("rbmk.rod.depletion", (double)((int)((1.0 - this.data.func_74769_h("enrichment")) * 100000.0)) / 1000.0 + "%"));
                    stats.add(TextFormatting.DARK_PURPLE + I18nUtil.resolveKey("rbmk.rod.xenon", (double)((int)(this.data.func_74769_h("xenon") * 1000.0)) / 1000.0 + "%"));
                    stats.add(TextFormatting.RED + I18nUtil.resolveKey("rbmk.rod.skinTemp", (double)((int)(this.data.func_74769_h("c_heat") * 10.0)) / 10.0 + "\u00b0C", (double)((int)(this.data.func_74769_h("c_maxHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    stats.add(TextFormatting.DARK_RED + I18nUtil.resolveKey("rbmk.rod.coreTemp", (double)((int)(this.data.func_74769_h("c_coreHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    stats.add(TextFormatting.DARK_RED + I18nUtil.resolveKey("trait.rbmk.meltdown", (double)((int)(this.data.func_74769_h("meltdown") * 1000.0)) / 1000.0 + "%"));
                    break;
                }
                case BOILER: {
                    stats.add(TextFormatting.BLUE + I18nUtil.resolveKey("rbmk.boiler.water", this.data.func_74762_e("water"), this.data.func_74762_e("maxWater")));
                    stats.add(TextFormatting.WHITE + I18nUtil.resolveKey("rbmk.boiler.steam", this.data.func_74762_e("steam"), this.data.func_74762_e("maxSteam")));
                    stats.add(TextFormatting.YELLOW + I18nUtil.resolveKey("rbmk.boiler.type", I18nUtil.resolveKey(FluidRegistry.getFluid((String)this.data.func_74779_i("type")).getUnlocalizedName(), new Object[0])));
                    break;
                }
                case COOLER: {
                    stats.add(TextFormatting.AQUA + I18nUtil.resolveKey("rbmk.cooler.cooling", this.data.func_74762_e("cooled") * 20));
                    stats.add(TextFormatting.DARK_AQUA + I18nUtil.resolveKey("rbmk.cooler.cryo", this.data.func_74762_e("cryo")));
                    break;
                }
                case OUTGASSER: {
                    double flux = this.data.func_74769_h("usedFlux");
                    double progress = this.data.func_74769_h("progress");
                    double maxProgress = this.data.func_74769_h("maxProgress");
                    int eta = 0;
                    if (flux > 0.0) {
                        eta = (int)((maxProgress - progress) / flux);
                    }
                    stats.add("\u00a76" + I18nUtil.resolveKey("rbmk.outgasser.eta", BobMathUtil.toDate(BobMathUtil.ticksToDate(eta, 72000))));
                    stats.add(TextFormatting.AQUA + I18nUtil.resolveKey("rbmk.outgasser.flux", Library.getShortNumber((long)flux)));
                    stats.add(TextFormatting.DARK_AQUA + I18nUtil.resolveKey("rbmk.outgasser.progress", Library.getShortNumber((long)progress), Library.getShortNumber((long)maxProgress), Library.getPercentage(progress / maxProgress)));
                    stats.add(TextFormatting.YELLOW + I18nUtil.resolveKey("rbmk.outgasser.gas", this.data.func_74762_e("gas"), this.data.func_74762_e("maxGas")));
                    break;
                }
                case CONTROL: {
                    short col;
                    if (this.data.func_74764_b("color") && (col = this.data.func_74765_d("color")) >= 0 && col < TileEntityRBMKControlManual.RBMKColor.values().length) {
                        stats.add(TextFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control." + TileEntityRBMKControlManual.RBMKColor.values()[col].name().toLowerCase(), new Object[0]));
                    }
                }
                case CONTROL_AUTO: {
                    stats.add(TextFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control.level", (int)(this.data.func_74769_h("level") * 100.0) + "%"));
                }
            }
            if (this.data.func_74767_n("moderated")) {
                stats.add(TextFormatting.YELLOW + I18nUtil.resolveKey("rbmk.moderated", new Object[0]));
            }
            return stats;
        }
    }
}

