/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockSiloHatch;
import com.hbm.blocks.machine.DummyBlockSiloHatch;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.IAnimatedDoor;
import com.hbm.interfaces.IDoor;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEDoorAnimationPacket;
import com.hbm.tileentity.machine.TileEntityDummy;
import com.hbm.tileentity.machine.TileEntityLockableBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySiloHatch
extends TileEntityLockableBase
implements ITickable,
IAnimatedDoor {
    public IDoor.DoorState state = IDoor.DoorState.CLOSED;
    public long sysTime;
    public int timer = -1;
    public EnumFacing facing = null;
    public AxisAlignedBB renderBox = null;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isLocked()) {
                boolean rs;
                boolean bl = rs = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
                if (rs) {
                    this.tryOpen();
                } else {
                    this.tryClose();
                }
            }
            IDoor.DoorState oldState = this.state;
            if (this.timer < 0) {
                oldState = null;
            }
            if (this.state.isStationaryState()) {
                this.timer = 0;
            } else {
                if (this.facing == null) {
                    this.facing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSiloHatch.FACING)).func_176734_d();
                }
                ++this.timer;
                if (this.state == IDoor.DoorState.CLOSING) {
                    if (this.timer == 1) {
                        BlockPos hydrolics = this.field_174879_c.func_177967_a(this.facing, 5);
                        this.field_145850_b.func_184148_a(null, (double)hydrolics.func_177958_n(), (double)hydrolics.func_177956_o(), (double)hydrolics.func_177952_p(), HBMSoundHandler.siloclose, SoundCategory.BLOCKS, 3.0f, 1.0f);
                    }
                    if (this.timer == 50) {
                        BlockPos mid = this.field_174879_c.func_177967_a(this.facing, 3);
                        for (int i = -1; i <= 1; ++i) {
                            for (int j = -1; j <= 1; ++j) {
                                this.placeDummy(mid.func_177982_a(i, 0, j));
                            }
                        }
                    }
                    if (this.timer > 100) {
                        this.state = IDoor.DoorState.CLOSED;
                        if (this.state != oldState) {
                            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
                        }
                    }
                } else if (this.state == IDoor.DoorState.OPENING) {
                    if (this.timer == 1) {
                        BlockPos hydrolics = this.field_174879_c.func_177967_a(this.facing, 5);
                        this.field_145850_b.func_184148_a(null, (double)hydrolics.func_177958_n(), (double)hydrolics.func_177956_o(), (double)hydrolics.func_177952_p(), HBMSoundHandler.siloopen, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    }
                    if (this.timer == 70) {
                        BlockPos mid = this.field_174879_c.func_177967_a(this.facing, 3);
                        for (int i = -1; i <= 1; ++i) {
                            for (int j = -1; j <= 1; ++j) {
                                this.removeDummy(mid.func_177982_a(i, 0, j));
                            }
                        }
                    }
                    if (this.timer > 100) {
                        this.state = IDoor.DoorState.OPEN;
                    }
                }
            }
            if (oldState != this.state) {
                PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TEDoorAnimationPacket(this.field_174879_c, (byte)this.state.ordinal()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
            }
        }
    }

    public void tryToggle() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.tryOpen();
        } else if (this.state == IDoor.DoorState.OPEN) {
            this.tryClose();
        }
    }

    public void tryOpen() {
        if (this.state == IDoor.DoorState.CLOSED && !this.field_145850_b.field_72995_K) {
            this.open();
            this.timer = -1;
        }
    }

    public void tryClose() {
        if (this.state == IDoor.DoorState.OPEN && !this.field_145850_b.field_72995_K) {
            this.close();
            this.timer = -1;
        }
    }

    public boolean placeDummy(BlockPos pos) {
        if (!this.field_145850_b.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos)) {
            return false;
        }
        this.field_145850_b.func_175656_a(pos, ModBlocks.dummy_block_silo_hatch.func_176223_P());
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof TileEntityDummy) {
            TileEntityDummy dummy = (TileEntityDummy)te;
            dummy.target = this.field_174879_c;
        }
        return true;
    }

    public void removeDummy(BlockPos pos) {
        if (this.field_145850_b.func_180495_p(pos).func_177230_c() == ModBlocks.dummy_block_silo_hatch) {
            DummyBlockSiloHatch.safeBreak = true;
            this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            DummyBlockSiloHatch.safeBreak = false;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.state = IDoor.DoorState.values()[compound.func_74771_c("state")];
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("state", (byte)this.state.ordinal());
        return super.func_189515_b(compound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.facing == null) {
            this.facing = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSiloHatch.FACING)).func_176734_d();
        }
        if (this.renderBox == null) {
            this.renderBox = new AxisAlignedBB(-3.3, 0.0, -3.3, 4.3, 2.0, 4.3).func_186670_a(this.field_174879_c.func_177967_a(this.facing, 3));
        }
        return this.renderBox;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void open() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.toggle();
        }
    }

    @Override
    public void close() {
        if (this.state == IDoor.DoorState.OPEN) {
            this.toggle();
        }
    }

    @Override
    public IDoor.DoorState getState() {
        return this.state;
    }

    @Override
    public void toggle() {
        if (this.state == IDoor.DoorState.CLOSED) {
            this.state = IDoor.DoorState.OPENING;
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        } else if (this.state == IDoor.DoorState.OPEN) {
            this.state = IDoor.DoorState.CLOSING;
            RadiationSystemNT.markChunkForRebuild(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void handleNewState(IDoor.DoorState newState) {
        if (this.state != newState) {
            if (this.state.isStationaryState() && newState.isMovingState()) {
                this.sysTime = System.currentTimeMillis();
            }
            this.state = newState;
        }
    }
}

