/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.machine.MachineNukeFurnace;
import com.hbm.inventory.BreederRecipes;
import com.hbm.util.ContaminationUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityNukeFurnace
extends TileEntity
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TileEntityNukeFurnace.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public int dualCookTime;
    public int dualPower;
    public static final int maxPower = 1000;
    public static final int processingSpeed = 30;
    private String customName;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.nukeFurnace";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean hasItemPower(ItemStack itemStack) {
        return TileEntityNukeFurnace.getItemPower(itemStack) > 0;
    }

    private static int getItemPower(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        int[] power = BreederRecipes.getFuelValue(stack);
        if (power == null) {
            return (int)Math.max(0.0, Math.sqrt(ContaminationUtil.getStackRads(stack)) - 7.0);
        }
        return power[0] * power[1] * 5;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.dualPower = compound.func_74765_d("powerTime");
        this.dualCookTime = compound.func_74765_d("CookTime");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74777_a("powerTime", (short)this.dualPower);
        compound.func_74777_a("cookTime", (short)this.dualCookTime);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 30;
    }

    public int getPowerRemainingScaled(int i) {
        return this.dualPower * i / 1000;
    }

    public boolean canProcess() {
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(1));
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190926_b()) {
            return true;
        }
        if (!this.inventory.getStackInSlot(2).func_77969_a(itemStack)) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getSlotLimit(2) && this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getStackInSlot(2).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(2).func_190916_E() < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(1));
            if (this.inventory.getStackInSlot(2).func_190926_b()) {
                this.inventory.setStackInSlot(2, itemStack.func_77946_l());
            } else if (this.inventory.getStackInSlot(2).func_77969_a(itemStack)) {
                this.inventory.getStackInSlot(2).func_190917_f(itemStack.func_190916_E());
            }
            for (int i = 1; i < 2; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) {
                    this.inventory.setStackInSlot(i, new ItemStack(this.inventory.getStackInSlot(i).func_77973_b().func_77664_n()));
                } else {
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                }
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            --this.dualPower;
        }
    }

    public boolean hasPower() {
        return this.dualPower > 0;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasItemPower(this.inventory.getStackInSlot(0)) && this.dualPower == 0) {
                this.dualPower += TileEntityNukeFurnace.getItemPower(this.inventory.getStackInSlot(0));
                if (!this.inventory.getStackInSlot(0).func_190926_b()) {
                    flag1 = true;
                    ItemStack container = this.inventory.getStackInSlot(0).func_77973_b().getContainerItem(this.inventory.getStackInSlot(0));
                    this.inventory.getStackInSlot(0).func_190918_g(1);
                    if (this.inventory.getStackInSlot(0).func_190926_b()) {
                        this.inventory.setStackInSlot(0, container);
                    }
                }
            }
            if (this.hasPower() && this.canProcess()) {
                ++this.dualCookTime;
                if (this.dualCookTime == 30) {
                    this.dualCookTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.dualCookTime = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
                MachineNukeFurnace.updateBlockState(this.dualCookTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }
}

