/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.PressRecipes;
import com.hbm.items.machine.ItemStamp;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEPressPacket;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineEPress
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public int progress = 0;
    public long power = 0L;
    public static final int maxProgress = 200;
    public static final long maxPower = 50000L;
    public int item;
    public int meta;
    boolean isRetracting = false;
    private int detectProgress;
    private long detectPower;
    private boolean detectIsRetracting;
    private String detectCustomName;
    private ItemStack detectItem;

    public TileEntityMachineEPress() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.epress";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemStamp && i == 1) {
            return true;
        }
        if (i == 0 && stack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return !(stack.func_77973_b() instanceof ItemStamp) && i == 2;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int[] nArray;
        if (e.ordinal() == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        return nArray;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 3;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("progress", this.progress);
        compound.func_74772_a("power", this.power);
        compound.func_74757_a("ret", this.isRetracting);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.progress = compound.func_74762_e("progress");
        this.power = compound.func_74762_e("power");
        this.isRetracting = compound.func_74767_n("ret");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 0, this.power, 50000L);
            if (this.power >= 100L && this.field_145850_b.func_175687_A(this.field_174879_c) <= 0) {
                int speed = 25;
                if (!this.inventory.getStackInSlot(1).func_190926_b() && !this.inventory.getStackInSlot(2).func_190926_b()) {
                    ItemStack stack = PressRecipes.getPressResult(this.inventory.getStackInSlot(2).func_77946_l(), this.inventory.getStackInSlot(1).func_77946_l());
                    if (stack != null && (this.inventory.getStackInSlot(3).func_190926_b() || this.inventory.getStackInSlot(3).func_77973_b() == stack.func_77973_b() && this.inventory.getStackInSlot(3).func_190916_E() + stack.func_190916_E() <= this.inventory.getStackInSlot(3).func_77976_d())) {
                        this.power -= 100L;
                        if (this.progress >= 200) {
                            this.isRetracting = true;
                            if (this.inventory.getStackInSlot(3).func_190926_b()) {
                                this.inventory.setStackInSlot(3, stack.func_77946_l());
                            } else {
                                this.inventory.getStackInSlot(3).func_190917_f(stack.func_190916_E());
                            }
                            this.inventory.getStackInSlot(2).func_190918_g(1);
                            if (this.inventory.getStackInSlot(2).func_190926_b()) {
                                this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
                            }
                            if (this.inventory.getStackInSlot(1).func_77958_k() > 0) {
                                this.inventory.getStackInSlot(1).func_77964_b(this.inventory.getStackInSlot(1).func_77952_i() + 1);
                                if (this.inventory.getStackInSlot(1).func_77952_i() >= this.inventory.getStackInSlot(1).func_77958_k()) {
                                    this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                                }
                            }
                            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.pressOperate, SoundCategory.BLOCKS, 1.5f, 1.0f);
                        }
                        if (!this.isRetracting) {
                            this.progress += speed;
                        }
                    } else {
                        this.isRetracting = true;
                    }
                } else {
                    this.isRetracting = true;
                }
                if (this.isRetracting) {
                    this.progress -= speed;
                }
            } else {
                this.isRetracting = true;
            }
            if (this.progress <= 0) {
                this.isRetracting = false;
                this.progress = 0;
            }
            this.detectAndSendChanges();
        }
    }

    protected void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectProgress != this.progress) {
            mark = true;
            this.detectProgress = this.progress;
        }
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        if (this.detectIsRetracting != this.isRetracting) {
            mark = true;
            this.detectIsRetracting = this.isRetracting;
        }
        if (!Library.areItemsEqual(this.inventory.getStackInSlot(2), this.detectItem)) {
            this.detectItem = this.inventory.getStackInSlot(2).func_77946_l();
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEPressPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.inventory.getStackInSlot(2), this.progress), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 50000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 200;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 3, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return super.getCapability(capability, facing);
    }
}

