/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyGenerator;
import com.hbm.blocks.machine.MachineCoal;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineCoal
extends TileEntityMachineBase
implements ITickable,
ITankPacketAcceptor,
IEnergyGenerator,
IFluidHandler {
    public long power;
    public int burnTime;
    public static final long maxPower = 100000L;
    public FluidTank tank;
    public Fluid tankType = FluidRegistry.WATER;
    public boolean needsUpdate = false;
    String customName = null;
    private long detectPower;
    private int detectBurnTime;
    private FluidTank detectTank = null;

    public TileEntityMachineCoal() {
        super(4);
        this.tank = new FluidTank(5000);
    }

    @Override
    public String getName() {
        return "container.machineCoal";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 0) {
            return this.isValidFluid(FluidUtil.getFluidContained((ItemStack)stack));
        }
        if (i == 1 && TileEntityFurnace.func_145952_a((ItemStack)stack) > 0) {
            return true;
        }
        if (i == 2) {
            return stack.func_77973_b() instanceof IBatteryItem;
        }
        return true;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 3;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendPower(this.field_145850_b, this.field_174879_c);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tank}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            if (this.inputValidForTank(-1, 0)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tank, 0, 3);
            }
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 2, this.power, 100000L);
            boolean trigger = true;
            if (this.isItemValid() && this.burnTime == 0) {
                trigger = false;
            }
            if (trigger) {
                MachineCoal.updateBlockState(this.burnTime > 0, this.field_145850_b, this.field_174879_c);
            }
            this.generate();
            this.detectAndSendChanges();
        }
    }

    public void generate() {
        if (this.inventory.getStackInSlot(1) != ItemStack.field_190927_a && TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(1)) > 0 && this.burnTime <= 0) {
            this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(1)) / 2;
            Item containerItem = this.inventory.getStackInSlot(1).func_77973_b().func_77668_q();
            this.inventory.getStackInSlot(1).func_190918_g(1);
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                if (containerItem != null) {
                    this.inventory.setStackInSlot(1, new ItemStack(containerItem));
                } else {
                    this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                }
            }
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.tank.getFluidAmount() > 0) {
                this.tank.drain(1, true);
                this.power = this.power + 25L <= 100000L ? (this.power += 25L) : 100000L;
            }
        }
    }

    public boolean isItemValid() {
        return this.inventory.getStackInSlot(1) != ItemStack.field_190927_a && TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(1)) > 0;
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return this.inventory.getStackInSlot(slot) != null && !this.inventory.getStackInSlot(slot).func_190926_b() && this.isValidFluid(FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        this.power = nbt.func_74763_f("powerTime");
        this.detectPower = this.power + 1L;
        this.burnTime = nbt.func_74762_e("burnTime");
        this.detectBurnTime = this.burnTime + 1;
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("burnTime", this.burnTime);
        this.tank.writeToNBT(nbt);
        NBTTagCompound tag = this.inventory.serializeNBT();
        nbt.func_74782_a("inventory", (NBTBase)tag);
        return super.func_189515_b(nbt);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return super.func_189518_D_();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isValidFluid(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    private boolean isValidFluid(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.getFluid() == FluidRegistry.WATER;
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (this.detectBurnTime != this.burnTime) {
            mark = true;
            this.detectBurnTime = this.burnTime;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.burnTime, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (!FFUtils.areTanksEqual(this.tank, this.detectTank)) {
            mark = true;
            this.detectTank = FFUtils.copyTank(this.tank);
            this.needsUpdate = true;
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }
}

