/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.CentrifugeRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityMachineCentrifuge
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public int progress;
    public long power;
    public boolean isProgressing;
    public static final int maxPower = 1000000;
    public static final int processingSpeed = 200;
    private long detectPower;
    private int detectCookTime;
    private boolean detectIsProgressing;

    public TileEntityMachineCentrifuge() {
        super(8);
    }

    @Override
    public String getName() {
        return "container.centrifuge";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / 200;
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 1000000L;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 2 || i == 3 || i == 4 || i == 5) {
            return false;
        }
        if (i == 1) {
            return stack.func_77973_b() instanceof IBatteryItem;
        }
        return !(stack.func_77973_b() instanceof IBatteryItem);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot > 1 && slot < 6;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        compound.func_74777_a("progressTime", (short)this.progress);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.progress = compound.func_74765_d("progressTime");
        super.func_145839_a(compound);
    }

    public boolean canProcess() {
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack[] itemStack = CentrifugeRecipes.getOutput(this.inventory.getStackInSlot(0));
        if (itemStack == null) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190926_b() && this.inventory.getStackInSlot(3).func_190926_b() && this.inventory.getStackInSlot(4).func_190926_b() && this.inventory.getStackInSlot(5).func_190926_b()) {
            return true;
        }
        return (this.inventory.getStackInSlot(2).func_190926_b() || itemStack.length > 0 && itemStack[0] != null && this.inventory.getStackInSlot(2).func_77969_a(itemStack[0]) && this.inventory.getStackInSlot(2).func_190916_E() + itemStack[0].func_190916_E() <= itemStack[0].func_77976_d()) && (this.inventory.getStackInSlot(3).func_190926_b() || itemStack.length < 2 || itemStack.length > 1 && itemStack[1] != null && this.inventory.getStackInSlot(3).func_77969_a(itemStack[1]) && this.inventory.getStackInSlot(3).func_190916_E() + itemStack[1].func_190916_E() <= itemStack[1].func_77976_d()) && (this.inventory.getStackInSlot(4).func_190926_b() || itemStack.length < 3 || itemStack.length > 2 && itemStack[2] != null && this.inventory.getStackInSlot(4).func_77969_a(itemStack[2]) && this.inventory.getStackInSlot(4).func_190916_E() + itemStack[2].func_190916_E() <= itemStack[2].func_77976_d()) && (this.inventory.getStackInSlot(5).func_190926_b() || itemStack.length < 4 || itemStack.length > 3 && itemStack[3] != null && this.inventory.getStackInSlot(5).func_77969_a(itemStack[3]) && this.inventory.getStackInSlot(5).func_190916_E() + itemStack[3].func_190916_E() <= itemStack[3].func_77976_d());
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack[] itemStack = CentrifugeRecipes.getOutput(this.inventory.getStackInSlot(0));
            if (this.inventory.getStackInSlot(2).func_190926_b() && itemStack[0] != null) {
                this.inventory.setStackInSlot(2, itemStack[0].func_77946_l());
            } else if (itemStack[0] != null && this.inventory.getStackInSlot(2).func_77969_a(itemStack[0])) {
                this.inventory.getStackInSlot(2).func_190917_f(itemStack[0].func_190916_E());
            }
            if (itemStack.length > 1) {
                if (this.inventory.getStackInSlot(3).func_190926_b() && itemStack[1] != null) {
                    this.inventory.setStackInSlot(3, itemStack[1].func_77946_l());
                } else if (itemStack[1] != null && this.inventory.getStackInSlot(3).func_77969_a(itemStack[1])) {
                    this.inventory.getStackInSlot(3).func_190917_f(itemStack[1].func_190916_E());
                }
            }
            if (itemStack.length > 2) {
                if (this.inventory.getStackInSlot(4).func_190926_b() && itemStack[2] != null) {
                    this.inventory.setStackInSlot(4, itemStack[2].func_77946_l());
                } else if (itemStack[2] != null && this.inventory.getStackInSlot(4).func_77969_a(itemStack[2])) {
                    this.inventory.getStackInSlot(4).func_190917_f(itemStack[2].func_190916_E());
                }
            }
            if (itemStack.length > 3) {
                if (this.inventory.getStackInSlot(5).func_190926_b() && itemStack[3] != null) {
                    this.inventory.setStackInSlot(5, itemStack[3].func_77946_l());
                } else if (itemStack[3] != null && this.inventory.getStackInSlot(5).func_77969_a(itemStack[3])) {
                    this.inventory.getStackInSlot(5).func_190917_f(itemStack[3].func_190916_E());
                }
            }
            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            } else {
                this.inventory.getStackInSlot(0).func_190918_g(1);
            }
        }
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public int getSpeedLvl() {
        int level = 0;
        for (int i = 6; i <= 7; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_1) {
                ++level;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_2) {
                level += 2;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_speed_3) {
                level += 3;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_screm) continue;
            level += 6;
        }
        return Math.min(level, 6);
    }

    public int getPowerLvl() {
        int level = 0;
        for (int i = 6; i <= 7; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_power_1) {
                ++level;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_power_2) {
                level += 2;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_power_3) continue;
            level += 3;
        }
        return Math.min(level, 3);
    }

    public int getOverdriveLvl() {
        int level = 0;
        for (int i = 6; i <= 7; ++i) {
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_overdrive_1) {
                ++level;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() == ModItems.upgrade_overdrive_2) {
                level += 2;
            }
            if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.upgrade_overdrive_3) continue;
            level += 3;
        }
        return Math.min(level, 3);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            if (this.inventory.getSlots() < 7) {
                this.inventory = this.getNewInventory(8, 64);
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 1, this.power, 1000000L);
            int speed = 1;
            int consumption = 200;
            int speedLvl = this.getSpeedLvl();
            int powerLvl = this.getPowerLvl();
            int overdriveLvl = this.getOverdriveLvl();
            speed += speedLvl;
            consumption += speedLvl * 200;
            speed *= 1 + overdriveLvl * 2;
            consumption += overdriveLvl * 10000;
            consumption /= 1 + powerLvl;
            if (this.hasPower() && this.isProcessing()) {
                this.power -= (long)consumption;
                if (this.power < 0L) {
                    this.power = 0L;
                }
            }
            this.isProgressing = this.hasPower() && this.canProcess();
            if (this.isProgressing) {
                this.progress += speed;
                if (this.progress >= 200) {
                    this.progress = 0;
                    this.processItem();
                }
            } else {
                this.progress = 0;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new LoopedSoundPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 200.0));
            this.detectAndSendChanges();
        }
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        if (this.detectCookTime != this.progress) {
            mark = true;
            this.detectCookTime = this.progress;
        }
        if (this.detectIsProgressing != this.isProgressing) {
            mark = true;
            this.detectIsProgressing = this.isProgressing;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.progress, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.isProgressing ? 1 : 0, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 4, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }
}

