/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.HeatRecipes;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.INBTPacketReceiver;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHeatBoiler
extends TileEntity
implements INBTPacketReceiver,
ITickable,
IFluidHandler {
    public FluidTank[] tanks;
    public Fluid[] types = new Fluid[2];
    public int heat;
    public static int maxHeat = 12800000;
    public static final double diffusion = 0.1;
    AxisAlignedBB bb = null;

    public TileEntityHeatBoiler() {
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(FluidRegistry.WATER, 0, 640000);
        this.types[0] = FluidRegistry.WATER;
        this.tanks[1] = new FluidTank(ModForgeFluids.steam, 0, 64000000);
        this.types[1] = ModForgeFluids.steam;
    }

    public void setTankType(int idx, Fluid type) {
        if (this.types[idx] != type) {
            this.types[idx] = type;
            if (type != null) {
                this.tanks[idx].setFluid(new FluidStack(type, 0));
            } else {
                this.tanks[idx].setFluid(null);
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.setupTanks();
            this.tryPullHeat();
            this.tryConvert();
            this.fillFluidInit(this.tanks[1]);
            this.networkPack();
        }
    }

    public void fillFluidInit(FluidTank tank) {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10).getRotation(ForgeDirection.UP);
        this.fillFluid(tank, this.field_174879_c.func_177982_a(dir.offsetX * 2, 0, dir.offsetZ * 2));
        this.fillFluid(tank, this.field_174879_c.func_177982_a(dir.offsetX * -2, 0, dir.offsetZ * -2));
        this.fillFluid(tank, this.field_174879_c.func_177982_a(0, 4, 0));
    }

    public void fillFluid(FluidTank tank, BlockPos pos) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, pos, 64000000);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == this.types[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drain = null;
        if (resource.getFluid() == this.types[1]) {
            drain = this.tanks[1].drain(resource, doDrain);
        }
        return drain;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drain = this.tanks[1].drain(maxDrain, doDrain);
        return drain;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.types[i] = this.tanks[i].getFluid() != null ? this.tanks[i].getFluid().getFluid() : null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.types[i] != null) {
                this.tanks[i].setFluid(new FluidStack(this.types[i], this.tanks[i].getFluidAmount()));
                continue;
            }
            this.tanks[i].setFluid(null);
        }
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return nbt;
    }

    public void networkPack() {
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < this.tanks.length; ++i) {
            if (this.types[i] != null) {
                this.tanks[i].setFluid(new FluidStack(this.types[i], this.tanks[i].getFluidAmount()));
                continue;
            }
            this.tanks[i].setFluid(null);
        }
        data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        data.func_74768_a("heat", this.heat);
        INBTPacketReceiver.networkPack(this, data, 25);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.types[i] = this.tanks[i].getFluid() != null ? this.tanks[i].getFluid().getFluid() : null;
        }
        this.heat = nbt.func_74762_e("heat");
    }

    private void setupTanks() {
        Fluid fluid = HeatRecipes.getBoilFluid(this.types[0]);
        if (fluid != null) {
            this.setTankType(0, this.types[0]);
            this.setTankType(1, fluid);
        } else {
            this.setTankType(0, null);
            this.setTankType(1, null);
        }
    }

    private void tryConvert() {
        if (HeatRecipes.hasBoilRecipe(this.types[0])) {
            Fluid hotFluid = HeatRecipes.getBoilFluid(this.types[0]);
            int heatReq = HeatRecipes.getRequiredHeat(this.types[0]);
            int inputAmount = HeatRecipes.getInputAmountHot(this.types[0]);
            int outputAmount = HeatRecipes.getOutputAmountHot(this.types[0]);
            int inputOps = this.tanks[0].getFluidAmount() / inputAmount;
            int outputOps = (this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount()) / outputAmount;
            int tempOps = (int)Math.floor(this.heat / heatReq);
            int ops = Math.min(inputOps, Math.min(outputOps, tempOps));
            this.tanks[0].drain(inputAmount * ops, true);
            this.tanks[1].fill(new FluidStack(this.types[1], outputAmount * ops), true);
            this.heat -= heatReq * ops;
        }
    }

    protected void tryPullHeat() {
        if (this.heat >= maxHeat) {
            return;
        }
        BlockPos blockBelow = this.field_174879_c.func_177977_b();
        TileEntity con = this.field_145850_b.func_175625_s(blockBelow);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if (diff > 0) {
                diff = (int)Math.ceil((double)diff * 0.1);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > maxHeat) {
                    this.heat = maxHeat;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

