/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.container.ContainerFurnaceIron;
import com.hbm.inventory.gui.GUIFurnaceIron;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.ForgeDirection;
import com.hbm.modules.ModuleBurnTime;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFurnaceIron
extends TileEntityMachineBase
implements IGUIProvider,
ITickable {
    public int maxBurnTime;
    public int burnTime;
    public boolean wasOn = false;
    public int progress;
    public int processingTime;
    public static final int baseTime = 200;
    public ModuleBurnTime burnModule = new ModuleBurnTime().setLigniteTimeMod(1.25).setCoalTimeMod(1.25).setCokeTimeMod(1.5).setSolidTimeMod(2.0).setRocketTimeMod(2.0).setBalefireTimeMod(2.0);
    AxisAlignedBB bb = null;

    public TileEntityFurnaceIron() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.furnaceIron";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.processingTime = 200 - 15 * ItemMachineUpgrade.getSpeed(this.inventory.getStackInSlot(4));
            this.wasOn = false;
            if (this.burnTime <= 0) {
                for (int i = 1; i < 3; ++i) {
                    int fuel;
                    ItemStack input = this.inventory.getStackInSlot(i);
                    if (input == null || (fuel = this.burnModule.getBurnTime(input)) <= 0) continue;
                    this.maxBurnTime = this.burnTime = fuel;
                    input.func_190918_g(1);
                    break;
                }
            }
            if (this.canSmelt()) {
                this.wasOn = true;
                ++this.progress;
                --this.burnTime;
                if (this.progress % 15 == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
                }
                if (this.progress >= this.processingTime) {
                    ItemStack outputs = this.inventory.getStackInSlot(3);
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0));
                    ItemStack copy = outputs;
                    if (outputs == ItemStack.field_190927_a) {
                        copy = result.func_77946_l();
                        this.inventory.setStackInSlot(3, copy);
                    } else {
                        outputs.func_190920_e(copy.func_190916_E() + result.func_190916_E());
                    }
                    this.inventory.getStackInSlot(0).func_190918_g(1);
                    this.progress = 0;
                    this.func_70296_d();
                }
            } else {
                this.progress = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("maxBurnTime", this.maxBurnTime);
            data.func_74768_a("burnTime", this.burnTime);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("processingTime", this.processingTime);
            data.func_74757_a("wasOn", this.wasOn);
            this.networkPack(data, 50);
        } else if (this.progress > 0) {
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            double offset = this.progress % 2 == 0 ? 1.0 : 0.5;
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * offset - (double)rot.offsetX * 0.1875, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * offset - (double)rot.offsetZ * 0.1875, 0.0, 0.01, 0.0, new int[0]);
            if (this.progress % 5 == 0) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 0.25 + (double)rot.offsetX * this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.25, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 0.25 + (double)rot.offsetZ * this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.progress = nbt.func_74762_e("progress");
        this.processingTime = nbt.func_74762_e("processingTime");
        this.wasOn = nbt.func_74767_n("wasOn");
    }

    public boolean canSmelt() {
        if (this.burnTime <= 0) {
            return false;
        }
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0));
        if (result == null || result.func_190926_b()) {
            return false;
        }
        if (this.inventory.getStackInSlot(3).func_190926_b()) {
            return true;
        }
        if (!result.func_77969_a(this.inventory.getStackInSlot(3))) {
            return false;
        }
        if (this.inventory.getStackInSlot(3).func_190916_E() < this.inventory.getSlotLimit(3) && this.inventory.getStackInSlot(3).func_190916_E() < this.inventory.getStackInSlot(3).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(3).func_190916_E() < result.func_77976_d();
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        if (i == 0) {
            return FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
        }
        if (i < 3) {
            return this.burnModule.getBurnTime(itemStack) > 0;
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i == 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("maxBurnTime", this.maxBurnTime);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("progress", this.progress);
        return nbt;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFurnaceIron(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFurnaceIron(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

