/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.SAFERecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFWatzCore;
import com.hbm.lib.Library;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.world.FWatz;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityFWatzCore
extends TileEntityLoadedBase
implements IControlReceiver,
ITickable,
IEnergyGenerator,
IFluidHandler,
ITankPacketAcceptor,
INBTPacketReceiver {
    public long power;
    public static final long maxPower = 1000000000000L;
    public boolean cooldown = false;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public boolean needsUpdate;
    public boolean isOn = false;
    public ItemStackHandler inventory = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            TileEntityFWatzCore.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    private String customName;

    public TileEntityFWatzCore() {
        this.tanks = new FluidTank[3];
        this.tankTypes = new Fluid[3];
        this.tanks[0] = new FluidTank(128000);
        this.tankTypes[0] = ModForgeFluids.coolant;
        this.tanks[1] = new FluidTank(64000);
        this.tankTypes[1] = ModForgeFluids.amat;
        this.tanks[2] = new FluidTank(64000);
        this.tankTypes[2] = ModForgeFluids.aschrab;
        this.needsUpdate = false;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return true;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        this.isOn = !this.isOn;
        this.func_70296_d();
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.fusionaryWatzPlant";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public int getSingularityType() {
        Item item = this.inventory.getStackInSlot(2).func_77973_b();
        if (item instanceof ItemFWatzCore) {
            return ((ItemFWatzCore)item).type;
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.isOn = compound.func_74767_n("isOn");
        this.tankTypes[0] = ModForgeFluids.coolant;
        this.tankTypes[1] = ModForgeFluids.amat;
        this.tankTypes[2] = ModForgeFluids.aschrab;
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74757_a("isOn", this.isOn);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isStructureValid(this.field_145850_b)) {
            this.sendSAFEPower();
            if (this.isRunning()) {
                ItemStack stack = this.inventory.getStackInSlot(2);
                if (stack.func_77973_b() == ModItems.meteorite_sword_baleful) {
                    this.inventory.setStackInSlot(2, new ItemStack(ModItems.meteorite_sword_warped));
                } else if (stack.func_77942_o()) {
                    NBTTagCompound nbt = stack.func_77978_p();
                    if (nbt.func_74767_n("ntmContagion")) {
                        nbt.func_82580_o("ntmContagion");
                    }
                    if (nbt.func_82582_d()) {
                        stack.func_77982_d(null);
                    }
                }
            }
            if (this.isOn && this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemFWatzCore) {
                ItemFWatzCore itemCore = (ItemFWatzCore)this.inventory.getStackInSlot(2).func_77973_b();
                if (this.cooldown) {
                    this.tanks[0].fill(new FluidStack(this.tankTypes[0], itemCore.coolantRefill), true);
                    if (this.tanks[0].getFluidAmount() >= this.tanks[0].getCapacity()) {
                        this.cooldown = false;
                    }
                } else {
                    if (this.tanks[1].getFluidAmount() > itemCore.amatDrain && this.tanks[2].getFluidAmount() > itemCore.aschrabDrain) {
                        this.tanks[0].drain(itemCore.coolantDrain, true);
                        this.tanks[1].drain(itemCore.amatDrain, true);
                        this.tanks[2].drain(itemCore.aschrabDrain, true);
                        this.needsUpdate = true;
                        this.power += itemCore.powerOutput;
                    }
                    if (this.power > 1000000000000L) {
                        this.power = 1000000000000L;
                    }
                    if (this.tanks[0].getFluidAmount() <= 0) {
                        this.cooldown = true;
                    }
                    if (this.field_145850_b.field_73012_v.nextInt(4096) == 0) {
                        this.tryGrowCore();
                    }
                }
            }
            if (this.power > 1000000000000L) {
                this.power = 1000000000000L;
            }
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 0, this.power, 1000000000000L);
            if (this.inputValidForTank(1, 3) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 3, 5)) {
                this.needsUpdate = true;
            }
            if (this.inputValidForTank(2, 4) && FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[2], 4, 6)) {
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.func_70296_d();
            }
            if (this.isRunning() && (this.tanks[1].getFluidAmount() <= 0 || this.tanks[2].getFluidAmount() <= 0 || !this.isOn || !(this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemFWatzCore)) || this.cooldown || !this.isStructureValid(this.field_145850_b)) {
                this.emptyPlasma();
            }
            if (!this.isRunning() && this.tanks[1].getFluidAmount() >= 100 && this.tanks[2].getFluidAmount() >= 100 && this.isOn && this.inventory.getStackInSlot(2).func_77973_b() instanceof ItemFWatzCore && !this.cooldown && this.isStructureValid(this.field_145850_b)) {
                this.fillPlasma();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
            data.func_74757_a("isOn", this.isOn);
            INBTPacketReceiver.networkPack(this, data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.isOn = data.func_74767_n("isOn");
        if (data.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(data.func_150295_c("tanks", 10), this.tanks);
        }
    }

    private void sendSAFEPower() {
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(7, -1, 0), Library.POS_X);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(-7, -1, 0), Library.NEG_X);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 7), Library.POS_Z);
        this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, -7), Library.NEG_Z);
    }

    private void tryGrowCore() {
        ItemStack output = SAFERecipes.getOutput(this.inventory.getStackInSlot(2));
        if (output != null) {
            this.inventory.setStackInSlot(2, output.func_77946_l());
        }
    }

    public boolean isStructureValid(World world) {
        return FWatz.checkHull(world, this.field_174879_c);
    }

    public long getPowerScaled(long i) {
        return this.power / 100L * i / 10000000000L;
    }

    public void fillPlasma() {
        if (!this.field_145850_b.field_72995_K) {
            FWatz.fillPlasma(this.field_145850_b, this.field_174879_c);
        }
    }

    public void emptyPlasma() {
        if (!this.field_145850_b.field_72995_K) {
            FWatz.emptyPlasma(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean isRunning() {
        return FWatz.getPlasma(this.field_145850_b, this.field_174879_c) && this.isStructureValid(this.field_145850_b);
    }

    protected boolean inputValidForTank(int tank, int slot) {
        return this.tanks[tank] != null && (this.inventory.getStackInSlot(slot).func_77973_b() == ModItems.fluid_barrel_infinite || this.isValidFluidForTank(tank, FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot))));
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tanks[tank] == null) {
            return false;
        }
        return stack.getFluid() == this.tankTypes[tank];
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == this.tankTypes[0]) {
            this.needsUpdate = true;
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == this.tankTypes[1]) {
            this.needsUpdate = true;
            return this.tanks[1].fill(resource, doFill);
        }
        if (resource.getFluid() == this.tankTypes[2]) {
            this.needsUpdate = true;
            return this.tanks[2].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 3) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
        this.tanks[2].readFromNBT(tags[2]);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this) : super.getCapability(capability, facing));
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000000000L;
    }
}

