/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineDiFurnace;
import com.hbm.inventory.DiFurnaceRecipes;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityDiFurnace
extends TileEntityMachineBase
implements ITickable,
ICapabilityProvider {
    public int dualCookTime;
    public int dualPower;
    public static final int maxPower = 12800;
    public static final int processingSpeed = 400;
    private static final int[] slots_top = new int[]{0, 1};
    private static final int[] slots_bottom = new int[]{3};
    private static final int[] slots_side = new int[]{2};
    private int detectDualCookTime;
    private int detectDualPower;

    public TileEntityDiFurnace() {
        super(4);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.dualPower = compound.func_74762_e("dualPower");
        this.detectDualCookTime = this.dualCookTime = compound.func_74762_e("cookTime");
        this.detectDualPower = this.dualPower;
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT((NBTTagCompound)compound.func_74781_a("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("dualPower", this.dualPower);
        compound.func_74768_a("cookTime", this.dualCookTime);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        boolean extension;
        boolean flag = this.hasPower();
        boolean bl = extension = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == ModBlocks.machine_difurnace_ext;
        if (this.dualPower > 0) {
            --this.dualPower;
        }
        int itemPower = DiFurnaceRecipes.getItemPower(this.inventory.getStackInSlot(2));
        if (this.hasItemPower(this.inventory.getStackInSlot(2)) && this.dualPower <= 12800 - itemPower) {
            this.dualPower += itemPower;
            if (!this.inventory.getStackInSlot(2).func_190926_b()) {
                ItemStack copy = this.inventory.getStackInSlot(2).func_77946_l();
                this.inventory.getStackInSlot(2).func_190918_g(1);
                if (this.inventory.getStackInSlot(2).func_190926_b()) {
                    this.inventory.setStackInSlot(2, copy.func_77973_b().getContainerItem(copy));
                }
            }
        }
        if (flag && this.canProcess()) {
            this.dualCookTime += extension ? 3 : 1;
            if (this.dualCookTime >= 400) {
                this.dualCookTime = 0;
                this.processItem();
            }
        } else {
            this.dualCookTime = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean trigger = true;
            if (flag && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (trigger) {
                MachineDiFurnace.updateBlockState(this.dualCookTime > 0, extension, this.field_145850_b, this.field_174879_c);
            }
        }
        this.detectAndSendChanges();
    }

    public boolean hasItemPower(ItemStack itemStack) {
        return DiFurnaceRecipes.getItemPower(itemStack) > 0;
    }

    @Override
    public String getName() {
        return "container.diFurnace";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i == 3) {
            return false;
        }
        if (i == 2) {
            return this.hasItemPower(stack);
        }
        return true;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        if (slot == 0 && this.isItemValidForSlot(slot, itemStack)) {
            return this.inventory.getStackInSlot(1).func_77973_b() != itemStack.func_77973_b();
        }
        if (slot == 1 && this.isItemValidForSlot(slot, itemStack)) {
            return this.inventory.getStackInSlot(0).func_77973_b() != itemStack.func_77973_b();
        }
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        return slot == 3;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 400;
    }

    public int getPowerRemainingScaled(int i) {
        return this.dualPower * i / 12800;
    }

    public boolean canProcess() {
        if (this.inventory.getStackInSlot(0) == null || this.inventory.getStackInSlot(1) == null) {
            return false;
        }
        ItemStack itemStack = DiFurnaceRecipes.getFurnaceProcessingResult(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1));
        if (itemStack == null) {
            return false;
        }
        if (this.inventory.getStackInSlot(3) == ItemStack.field_190927_a) {
            return true;
        }
        if (this.inventory.getStackInSlot(3).func_77973_b() != ItemStack.field_190927_a.func_77973_b() && !this.inventory.getStackInSlot(3).func_77969_a(itemStack)) {
            return false;
        }
        if (this.inventory.getStackInSlot(3).func_190916_E() < this.inventory.getSlotLimit(3) && this.inventory.getStackInSlot(3).func_190916_E() < this.inventory.getStackInSlot(3).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(3).func_190916_E() < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = DiFurnaceRecipes.getFurnaceProcessingResult(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1));
            if (this.inventory.getStackInSlot(3).func_190926_b()) {
                this.inventory.setStackInSlot(3, itemStack.func_77946_l());
            } else if (this.inventory.getStackInSlot(3).func_77969_a(itemStack)) {
                this.inventory.getStackInSlot(3).func_190917_f(itemStack.func_190916_E());
            }
            for (int i = 0; i < 2; ++i) {
                if (this.inventory.getStackInSlot(i).func_190916_E() <= 0) {
                    this.inventory.setStackInSlot(i, new ItemStack(this.inventory.getStackInSlot(i).func_77973_b().func_77664_n()));
                } else {
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                }
                if (this.inventory.getStackInSlot(i).func_190916_E() > 0) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public boolean hasPower() {
        return this.dualPower > 0;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectDualCookTime != this.dualCookTime) {
            mark = true;
            this.detectDualCookTime = this.dualCookTime;
        }
        if (this.detectDualPower != this.dualPower) {
            mark = true;
            this.detectDualPower = this.dualPower;
        }
        if (mark) {
            this.func_70296_d();
        }
    }
}

