/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCoreInjector
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    public FluidTank[] tanks = new FluidTank[2];
    public static final int range = 15;
    public int beam;

    public TileEntityCoreInjector() {
        super(0);
        this.tanks[0] = new FluidTank(2560000);
        this.tanks[1] = new FluidTank(2560000);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.beam = 0;
            EnumFacing dir = EnumFacing.func_82600_a((int)this.func_145832_p());
            for (int i = 1; i <= 15; ++i) {
                int z;
                int y;
                int x = this.field_174879_c.func_177958_n() + dir.func_82601_c() * i;
                BlockPos pos1 = new BlockPos(x, y = this.field_174879_c.func_177956_o() + dir.func_96559_d() * i, z = this.field_174879_c.func_177952_p() + dir.func_82599_e() * i);
                TileEntity te = this.field_145850_b.func_175625_s(pos1);
                if (te instanceof TileEntityCore) {
                    this.fillDFC((TileEntityCore)te);
                    this.beam = i;
                    break;
                }
                if (this.field_145850_b.func_180495_p(pos1).func_177230_c() != Blocks.field_150350_a) break;
            }
            this.func_70296_d();
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxGaugePacket(this.field_174879_c, this.beam, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
        }
    }

    public void fillDFC(TileEntityCore core) {
        Fluid tank0 = null;
        Fluid tank1 = null;
        Fluid dfcTank0 = null;
        Fluid dfcTank1 = null;
        if (this.tanks[0].getFluid() != null) {
            tank0 = this.tanks[0].getFluid().getFluid();
        }
        if (this.tanks[1].getFluid() != null) {
            tank1 = this.tanks[1].getFluid().getFluid();
        }
        if (tank0 == null && tank1 == null) {
            return;
        }
        if (core.tanks[0].getFluid() != null) {
            dfcTank0 = core.tanks[0].getFluid().getFluid();
        }
        if (core.tanks[1].getFluid() != null) {
            dfcTank1 = core.tanks[1].getFluid().getFluid();
        }
        if ((tank0 == dfcTank0 || dfcTank0 == null) && tank0 != dfcTank1 && this.tanks[0].drain(core.tanks[0].fill(this.tanks[0].getFluid(), true), true) != null) {
            dfcTank0 = tank0;
            core.func_70296_d();
        }
        if ((tank1 == dfcTank1 || dfcTank1 == null) && tank1 != dfcTank0 && this.tanks[1].drain(core.tanks[1].fill(this.tanks[1].getFluid(), true), true) != null) {
            dfcTank1 = tank1;
            core.func_70296_d();
        }
        if ((tank0 == dfcTank1 || dfcTank1 == null) && tank0 != dfcTank0 && this.tanks[0].drain(core.tanks[1].fill(this.tanks[0].getFluid(), true), true) != null) {
            core.func_70296_d();
        }
        if ((tank1 == dfcTank0 || dfcTank0 == null) && tank1 != dfcTank1 && this.tanks[1].drain(core.tanks[0].fill(this.tanks[1].getFluid(), true), true) != null) {
            core.func_70296_d();
        }
    }

    @Override
    public String getName() {
        return "container.dfcInjector";
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.tanks[0].getFluid() == null || this.tanks[0].getFluid().getFluid() == resource.getFluid()) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (this.tanks[1].getFluid() == null || this.tanks[1].getFluid().getFluid() == resource.getFluid()) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.tanks[0].readFromNBT(tags[0]);
            this.tanks[1].readFromNBT(tags[1]);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(compound.func_150295_c("tanks", 10), this.tanks);
        }
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(compound);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }
}

