/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item;

import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.item.TEISRBase;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ItemRenderMissileGeneric
extends TEISRBase {
    public static HashMap<RecipesCommon.ComparableStack, Consumer<TextureManager>> renderers = new HashMap();
    protected RenderMissileType category;

    public ItemRenderMissileGeneric(RenderMissileType category) {
        this.category = category;
    }

    public void func_179022_a(ItemStack item) {
        Consumer<TextureManager> renderer = renderers.get(new RecipesCommon.ComparableStack(item).makeSingular());
        if (renderer == null) {
            return;
        }
        GL11.glPushMatrix();
        double guiScale = 1.0;
        double guiOffset = 0.0;
        switch (this.category) {
            case TYPE_TIER0: {
                guiScale = 4.2;
                guiOffset = 1.0;
                break;
            }
            case TYPE_TIER1: {
                guiScale = 2.75;
                guiOffset = 0.5;
                break;
            }
            case TYPE_TIER2: {
                guiScale = 1.1;
                guiOffset = 0.5;
                break;
            }
            case TYPE_TIER3: {
                guiScale = 1.0;
                guiOffset = 0.0;
                break;
            }
            case TYPE_ABM: {
                guiScale = 2.25;
                guiOffset = 0.5;
                break;
            }
            case TYPE_NUCLEAR: {
                guiScale = 1.75;
                guiOffset = 0.0;
                break;
            }
            case TYPE_THERMAL: {
                guiScale = 1.75;
                guiOffset = 1.0;
                break;
            }
            case TYPE_DOOMSDAY: {
                guiScale = 1.5;
                guiOffset = 1.0;
                break;
            }
            case TYPE_CARRIER: {
                guiScale = 0.625;
            }
        }
        GL11.glEnable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glEnable((int)3008);
        boolean l = false;
        switch (this.type) {
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                double s = 0.15;
                GL11.glTranslated((double)0.5, (double)-0.25, (double)0.25);
                GL11.glScaled((double)s, (double)s, (double)s);
                GL11.glScaled((double)guiScale, (double)guiScale, (double)guiScale);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                double heldScale = 0.1;
                GL11.glTranslated((double)0.5, (double)0.25, (double)0.3);
                GL11.glScaled((double)heldScale, (double)heldScale, (double)heldScale);
                GL11.glScaled((double)guiScale, (double)guiScale, (double)guiScale);
                break;
            }
            case GROUND: 
            case FIXED: 
            case HEAD: {
                double s2 = 0.15;
                GL11.glScaled((double)s2, (double)s2, (double)s2);
                break;
            }
            case GUI: {
                RenderHelper.func_74520_c();
                double s3 = 0.0625;
                GL11.glScaled((double)s3, (double)s3, (double)s3);
                GL11.glTranslated((double)(15.0 - guiOffset), (double)(1.0 + guiOffset), (double)0.0);
                GL11.glScaled((double)guiScale, (double)guiScale, (double)guiScale);
                GL11.glRotated((double)45.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotatef((float)(System.currentTimeMillis() / 15L % 360L), (float)0.0f, (float)1.0f, (float)0.0f);
                l = true;
                break;
            }
        }
        GL11.glDisable((int)2884);
        renderer.accept(Minecraft.func_71410_x().field_71446_o);
        GL11.glEnable((int)2884);
        if (l) {
            RenderHelper.func_74519_b();
        }
        GL11.glPopMatrix();
    }

    public static Consumer<TextureManager> generateStandard(ResourceLocation texture, IModelCustom model) {
        return ItemRenderMissileGeneric.generateWithScale(texture, model, 1.0f);
    }

    public static Consumer<TextureManager> generateLarge(ResourceLocation texture, IModelCustom model) {
        return ItemRenderMissileGeneric.generateWithScale(texture, model, 1.5f);
    }

    public static Consumer<TextureManager> generateDouble(ResourceLocation texture, IModelCustom model) {
        return ItemRenderMissileGeneric.generateWithScale(texture, model, 2.0f);
    }

    public static Consumer<TextureManager> generateWithScale(ResourceLocation texture, IModelCustom model, float scale) {
        return x -> {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glShadeModel((int)7425);
            x.func_110577_a(texture);
            model.renderAll();
            GL11.glShadeModel((int)7424);
        };
    }

    public static void init() {
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_taint), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileTaint_tex, ResourceManager.missileTaint));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_micro), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicro_tex, ResourceManager.missileTaint));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_bhole), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroBHole_tex, ResourceManager.missileTaint));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_schrabidium), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroSchrab_tex, ResourceManager.missileTaint));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_emp), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileMicroEMP_tex, ResourceManager.missileTaint));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_generic), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_HE_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_incendiary), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_IN_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_cluster), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_CL_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_buster), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileV2_BU_tex, ResourceManager.missileV2));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_anti_ballistic), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileAA_tex, ResourceManager.missileAB));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_HE_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_incendiary_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_IN_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_cluster_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_CL_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_buster_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_BU_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_emp_strong), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileStrong_EMP_tex, ResourceManager.missileStrong));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_burst), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_HE_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_inferno), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_IN_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_rain), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_CL_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_drill), ItemRenderMissileGeneric.generateStandard(ResourceManager.missileHuge_BU_tex, ResourceManager.missileHuge));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_nuclear), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileNuclear_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_nuclear_cluster), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileMIRV_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_volcano), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileVolcano_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_n2), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileN2_tex, ResourceManager.missileNuclear));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_endo), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileEndo_tex, ResourceManager.missileThermo));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_exo), ItemRenderMissileGeneric.generateLarge(ResourceManager.missileExo_tex, ResourceManager.missileThermo));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_doomsday), ItemRenderMissileGeneric.generateDouble(ResourceManager.missileDoomsday_tex, ResourceManager.missileDoomsday));
        renderers.put(new RecipesCommon.ComparableStack(ModItems.missile_carrier), x -> {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            x.func_110577_a(ResourceManager.missileCarrier_tex);
            ResourceManager.missileCarrier.renderAll();
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
            GL11.glTranslated((double)1.25, (double)0.0, (double)0.0);
            x.func_110577_a(ResourceManager.missileBooster_tex);
            ResourceManager.missileBooster.renderAll();
            GL11.glTranslated((double)-2.5, (double)0.0, (double)0.0);
            ResourceManager.missileBooster.renderAll();
            GL11.glTranslated((double)1.25, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)1.25);
            ResourceManager.missileBooster.renderAll();
            GL11.glTranslated((double)0.0, (double)0.0, (double)-2.5);
            ResourceManager.missileBooster.renderAll();
            GL11.glTranslated((double)0.0, (double)0.0, (double)1.25);
        });
    }

    public static enum RenderMissileType {
        TYPE_TIER0,
        TYPE_TIER1,
        TYPE_TIER2,
        TYPE_TIER3,
        TYPE_ABM,
        TYPE_NUCLEAR,
        TYPE_THERMAL,
        TYPE_DOOMSDAY,
        TYPE_CARRIER;

    }
}

