/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.physics;

import com.hbm.physics.Collider;
import com.hbm.physics.GJK;
import com.hbm.physics.RigidBody;
import com.hbm.render.amlfrom1710.Vec3;
import net.minecraft.util.math.MathHelper;

public class Contact {
    public RigidBody bodyA;
    public RigidBody bodyB;
    public Collider a;
    public Collider b;
    public Vec3 localA;
    public Vec3 localB;
    public Vec3 globalA;
    public Vec3 globalB;
    public Vec3 normal;
    public float depth;
    public Vec3 tangent;
    public Vec3 bitangent;
    public Vec3 rA;
    public Vec3 rB;
    public Jacobian normalContact;
    public Jacobian tangentContact;
    public Jacobian bitangentContact;

    public Contact(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, GJK.GJKInfo info) {
        this.a = a;
        this.b = b;
        if (bodyA == null) {
            bodyA = RigidBody.DUMMY;
        }
        if (bodyB == null) {
            bodyB = RigidBody.DUMMY;
        }
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.localA = bodyA.globalToLocalPos(info.contactPointA);
        this.localB = bodyB.globalToLocalPos(info.contactPointB);
        this.globalA = info.contactPointA;
        this.globalB = info.contactPointB;
        this.normal = info.normal;
        this.depth = info.depth;
        this.tangent = Math.abs(this.normal.xCoord) >= 0.57735 ? new Vec3(this.normal.yCoord, -this.normal.xCoord, 0.0).normalize() : new Vec3(0.0, this.normal.zCoord, -this.normal.yCoord).normalize();
        this.bitangent = this.normal.crossProduct(this.tangent);
        this.normalContact = new Jacobian(false);
        this.tangentContact = new Jacobian(true);
        this.bitangentContact = new Jacobian(true);
    }

    public void init(float dt) {
        this.rA = this.globalA.subtract(this.bodyA == RigidBody.DUMMY ? this.a.localCentroid : this.bodyA.globalCentroid);
        this.rB = this.globalB.subtract(this.bodyB == RigidBody.DUMMY ? this.b.localCentroid : this.bodyB.globalCentroid);
        this.normalContact.init(this, this.normal, dt);
        this.tangentContact.init(this, this.tangent, dt);
        this.bitangentContact.init(this, this.bitangent, dt);
    }

    public void solve(float dt) {
        this.normalContact.solve(this, dt);
        this.tangentContact.solve(this, dt);
        this.bitangentContact.solve(this, dt);
    }

    public static class Jacobian {
        boolean tangent;
        Vec3 j_va;
        Vec3 j_wa;
        Vec3 j_vb;
        Vec3 j_wb;
        float bias;
        double effectiveMass;
        double totalLambda;

        public Jacobian(boolean tangent) {
            this.tangent = tangent;
        }

        public void init(Contact c, Vec3 dir, float dt) {
            this.j_va = dir.negate();
            this.j_wa = c.rA.crossProduct(dir).negate();
            this.j_vb = dir;
            this.j_wb = c.rB.crossProduct(dir);
            if (!this.tangent) {
                float closingVel = (float)c.bodyA.linearVelocity.negate().subtract(c.bodyA.angularVelocity.crossProduct(c.rA)).add(c.bodyB.linearVelocity).add(c.bodyB.angularVelocity.crossProduct(c.rB)).dotProduct(c.normal);
                float restitution = c.bodyA.restitution * c.bodyB.restitution;
                float beta = 0.2f;
                float dslop = 5.0E-4f;
                float rslop = 0.5f;
                this.bias = -(beta / dt) * Math.max(c.depth - dslop, 0.0f) + Math.max(restitution * closingVel - rslop, 0.0f);
            }
            this.effectiveMass = (double)c.bodyA.inv_mass + this.j_wa.dotProduct(this.j_wa.matTransform(c.bodyA.inv_globalInertiaTensor)) + (double)c.bodyB.inv_mass + this.j_wb.dotProduct(this.j_wb.matTransform(c.bodyB.inv_globalInertiaTensor));
            this.effectiveMass = 1.0 / this.effectiveMass;
            this.totalLambda = 0.0;
        }

        public void solve(Contact c, float dt) {
            double jv = this.j_va.dotProduct(c.bodyA.linearVelocity) + this.j_wa.dotProduct(c.bodyA.angularVelocity) + this.j_vb.dotProduct(c.bodyB.linearVelocity) + this.j_wb.dotProduct(c.bodyB.angularVelocity);
            double lambda = this.effectiveMass * -(jv + (double)this.bias);
            double oldTotalLambda = this.totalLambda;
            if (this.tangent) {
                float friction = c.bodyA.friction * c.bodyB.friction;
                double maxFriction = (double)friction * c.normalContact.totalLambda;
                this.totalLambda = MathHelper.func_151237_a((double)(this.totalLambda + lambda), (double)(-maxFriction), (double)maxFriction);
            } else {
                this.totalLambda = Math.max(0.0, oldTotalLambda + lambda);
            }
            lambda = this.totalLambda - oldTotalLambda;
            c.bodyA.addLinearVelocity(this.j_va.multd((double)c.bodyA.inv_mass * lambda));
            c.bodyA.addAngularVelocity(this.j_wa.matTransform(c.bodyA.inv_globalInertiaTensor).multd(lambda));
            c.bodyB.addLinearVelocity(this.j_vb.multd((double)c.bodyB.inv_mass * lambda));
            c.bodyB.addAngularVelocity(this.j_wb.matTransform(c.bodyB.inv_globalInertiaTensor).multd(lambda));
        }
    }
}

