/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle_instanced;

import com.google.common.collect.Queues;
import com.hbm.config.GeneralConfig;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.main.ResourceManager;
import com.hbm.particle_instanced.ParticleInstanced;
import com.hbm.render.GLCompat;
import com.hbm.render.RenderHelper;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="hbm")
public class InstancedParticleRenderer {
    private static final int BYTES_PER_PARTICLE = 38;
    public static float partialTicks;
    private static int faceCount;
    private static int vao;
    private static int particleDataVbo;
    private static ByteBuffer particleBuffer;
    protected static ArrayDeque<ParticleInstanced> particles;
    private static final Queue<ParticleInstanced> queue;
    private static boolean init;

    public static void addParticle(ParticleInstanced p) {
        if (p != null) {
            queue.add(p);
        }
    }

    public static void updateParticles() {
        Iterator<ParticleInstanced> itr = particles.iterator();
        while (itr.hasNext()) {
            ParticleInstanced p = itr.next();
            p.func_189213_a();
            if (p.func_187113_k()) continue;
            faceCount -= p.getFaceCount();
            itr.remove();
        }
        if (!queue.isEmpty()) {
            ParticleInstanced particle = queue.poll();
            while (particle != null) {
                if (particles.size() > 16384) {
                    ParticleInstanced p = particles.removeFirst();
                    faceCount -= p.getFaceCount();
                }
                faceCount += particle.getFaceCount();
                particles.add(particle);
                particle = queue.poll();
            }
        }
    }

    public static void renderParticles(Entity entityIn, float partialTicks) {
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        RenderHelper.bindBlockTexture();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bufferSize = faceCount * 38;
        if (particleBuffer.capacity() < bufferSize) {
            particleBuffer = GLAllocation.func_74524_c((int)bufferSize);
        }
        particleBuffer.limit(bufferSize);
        for (ParticleInstanced p : particles) {
            p.addDataToBuffer(particleBuffer, partialTicks);
        }
        particleBuffer.rewind();
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, particleDataVbo);
        GLCompat.bufferData(GLCompat.GL_ARRAY_BUFFER, particleBuffer, GLCompat.GL_DYNAMIC_DRAW);
        GLCompat.bindVertexArray(vao);
        ResourceManager.lit_particles.use();
        GLCompat.drawArraysInstanced(7, 0, 4, faceCount);
        HbmShaderManager2.releaseShader();
        GLCompat.bindVertexArray(0);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public static void setup() {
        int particleQuadVbo = GLCompat.genBuffers();
        int particleDataVbo = GLCompat.genBuffers();
        float[] vertexData = new float[]{-0.5f, -0.5f, 0.0f, 0.5f, -0.5f, 0.0f, 0.5f, 0.5f, 0.0f, -0.5f, 0.5f, 0.0f};
        ByteBuffer data = GLAllocation.func_74524_c((int)(4 * vertexData.length));
        for (float f : vertexData) {
            data.putFloat(f);
        }
        data.rewind();
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, particleQuadVbo);
        GLCompat.bufferData(GLCompat.GL_ARRAY_BUFFER, data, GLCompat.GL_STATIC_DRAW);
        int vao = GLCompat.genVertexArrays();
        GLCompat.bindVertexArray(vao);
        GLCompat.vertexAttribPointer(0, 3, 5126, false, 12, 0L);
        GLCompat.enableVertexAttribArray(0);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, particleDataVbo);
        GLCompat.vertexAttribPointer(1, 3, 5126, false, 38, 0L);
        GLCompat.enableVertexAttribArray(1);
        GLCompat.vertexAttribPointer(2, 1, 5126, false, 38, 12L);
        GLCompat.enableVertexAttribArray(2);
        GLCompat.vertexAttribPointer(3, 4, 5126, false, 38, 16L);
        GLCompat.enableVertexAttribArray(3);
        GLCompat.vertexAttribPointer(4, 4, 5121, true, 38, 32L);
        GLCompat.enableVertexAttribArray(4);
        GLCompat.vertexAttribPointer(5, 2, 5121, true, 38, 36L);
        GLCompat.enableVertexAttribArray(5);
        GLCompat.vertexAttribDivisor(1, 1);
        GLCompat.vertexAttribDivisor(2, 1);
        GLCompat.vertexAttribDivisor(3, 1);
        GLCompat.vertexAttribDivisor(4, 1);
        GLCompat.vertexAttribDivisor(5, 1);
        GLCompat.bindVertexArray(0);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
        InstancedParticleRenderer.vao = vao;
        InstancedParticleRenderer.particleDataVbo = particleDataVbo;
    }

    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        if (GeneralConfig.instancedParticles) {
            partialTicks = event.getPartialTicks();
            InstancedParticleRenderer.renderParticles(Minecraft.func_71410_x().func_175606_aa(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (GeneralConfig.instancedParticles && event.phase == TickEvent.Phase.START) {
            if (init) {
                InstancedParticleRenderer.setup();
                init = false;
            }
            if (!Minecraft.func_71410_x().func_147113_T()) {
                InstancedParticleRenderer.updateParticles();
            }
        }
    }

    static {
        faceCount = 0;
        particleBuffer = GLAllocation.func_74524_c((int)0);
        particles = Queues.newArrayDeque();
        queue = Queues.newArrayDeque();
        init = true;
    }
}

