/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.items.machine.ItemCassette;
import com.hbm.sound.SoundLoopSiren;
import com.hbm.tileentity.machine.TileEntityMachineSiren;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TESirenPacket
implements IMessage {
    int x;
    int y;
    int z;
    int id;
    boolean active;

    public TESirenPacket() {
    }

    public TESirenPacket(int x, int y, int z, int id, boolean active) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.id = id;
        this.active = active;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.id = buf.readInt();
        this.active = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.id);
        buf.writeBoolean(this.active);
    }

    public static class Handler
    implements IMessageHandler<TESirenPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(TESirenPacket m, MessageContext ctx) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(m.x, m.y, m.z));
            if (te != null && te instanceof TileEntityMachineSiren) {
                SoundLoopSiren sound = null;
                for (int i = 0; i < SoundLoopSiren.list.size(); ++i) {
                    if (SoundLoopSiren.list.get(i).getTE() != te) continue;
                    sound = SoundLoopSiren.list.get(i);
                }
                if (m.active) {
                    if (sound == null) {
                        if (m.id > 0) {
                            boolean b = ItemCassette.TrackType.getEnum(m.id).getType().name().equals(ItemCassette.SoundType.LOOP.name());
                            SoundLoopSiren s = new SoundLoopSiren(ItemCassette.TrackType.getEnum(m.id).getSoundLocation(), te, ItemCassette.TrackType.getEnum(m.id).getType());
                            s.setRepeat(b);
                            s.intendedVolume = ItemCassette.TrackType.getEnum(m.id).getVolume();
                            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)s);
                        }
                    } else {
                        SoundEvent loc = ItemCassette.TrackType.getEnum(m.id).getSoundLocation();
                        if (loc != null) {
                            String path = loc.func_187503_a().toString();
                            if (!sound.getPath().equals(path)) {
                                sound.endSound();
                                if (m.id > 0) {
                                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SoundLoopSiren(ItemCassette.TrackType.getEnum(m.id).getSoundLocation(), te, ItemCassette.TrackType.getEnum(m.id).getType()));
                                }
                            }
                        }
                        sound.intendedVolume = ItemCassette.TrackType.getEnum(m.id).getVolume();
                    }
                } else if (sound != null) {
                    sound.endSound();
                    SoundLoopSiren.list.remove((Object)sound);
                }
            }
            return null;
        }
    }
}

