/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.main.ModEventHandlerClient;
import com.hbm.main.ResourceManager;
import com.hbm.particle.DisintegrationParticleHandler;
import com.hbm.particle.ParticleBlood;
import com.hbm.particle.ParticleSlicedMob;
import com.hbm.particle.bullet_hit.EntityHitDataHandler;
import com.hbm.particle.bullet_hit.ParticleMobGib;
import com.hbm.physics.RigidBody;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.util.ModelRendererUtil;
import com.hbm.render.util.Triangle;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Matrix4f;

public class PacketSpecialDeath
implements IMessage {
    public static Method rGetHurtSound;
    Entity serverEntity;
    int entId;
    int effectId;
    float[] auxData;
    Object auxObj;

    public PacketSpecialDeath() {
    }

    public PacketSpecialDeath(Entity ent, int effectId, float ... auxData) {
        this.serverEntity = ent;
        this.effectId = effectId;
        this.entId = ent.func_145782_y();
        this.auxData = auxData;
    }

    public void fromBytes(ByteBuf buf) {
        this.entId = buf.readInt();
        this.effectId = buf.readInt();
        int len = buf.readByte();
        this.auxData = new float[len];
        for (int i = 0; i < len; ++i) {
            this.auxData[i] = buf.readFloat();
        }
        if (this.effectId == 4) {
            this.auxObj = EntityHitDataHandler.decodeData(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entId);
        buf.writeInt(this.effectId);
        buf.writeByte(this.auxData.length);
        for (float f : this.auxData) {
            buf.writeFloat(f);
        }
        if (this.effectId == 4) {
            EntityHitDataHandler.encodeData(this.serverEntity, buf);
        }
    }

    public static float pointLightFalloff(float radius, float dist) {
        float distOverRad = dist / radius;
        float distOverRad2 = distOverRad * distOverRad;
        float distOverRad4 = distOverRad2 * distOverRad2;
        float falloff = MathHelper.func_76131_a((float)(1.0f - distOverRad4), (float)0.0f, (float)1.0f);
        return falloff * falloff / (dist * dist + 1.0f);
    }

    public static class Handler
    implements IMessageHandler<PacketSpecialDeath, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketSpecialDeath m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(m.entId);
                if (ent instanceof EntityLivingBase) {
                    switch (m.effectId) {
                        case 0: {
                            ent.func_70106_y();
                            ModEventHandlerClient.specialDeathEffectEntities.add((EntityLivingBase)ent);
                            DisintegrationParticleHandler.spawnGluonDisintegrateParticles(ent);
                            break;
                        }
                        case 1: {
                            ((EntityLivingBase)ent).field_70737_aN = 2;
                            try {
                                if (rGetHurtSound == null) {
                                    rGetHurtSound = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"getHurtSound", (String)"func_184601_bQ", (Class[])new Class[]{DamageSource.class});
                                }
                                SoundEvent s = (SoundEvent)rGetHurtSound.invoke((Object)ent, ModDamageSource.radiation);
                                Minecraft.func_71410_x().field_71441_e.func_184134_a(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, s, SoundCategory.MASTER, 1.0f, 1.0f, false);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        case 2: {
                            ent.func_70106_y();
                            ModEventHandlerClient.specialDeathEffectEntities.add((EntityLivingBase)ent);
                            DisintegrationParticleHandler.spawnLightningDisintegrateParticles(ent, new Vec3(m.auxData[0], m.auxData[1], m.auxData[2]));
                            break;
                        }
                        case 3: {
                            ParticleSlicedMob[] particles;
                            ent.func_70106_y();
                            float[] data = m.auxData;
                            int id = Float.floatToIntBits(data[4]);
                            ResourceLocation capTex = id == 0 ? ResourceManager.gore_generic : ResourceManager.crucible_cap;
                            for (ParticleSlicedMob p : particles = ModelRendererUtil.generateCutParticles(ent, data, capTex, id == 1 ? 1.0f : 0.0f, capTris -> {
                                int cCount;
                                int bloodCount = 5;
                                int n = cCount = id == 1 ? 8 : 0;
                                if (capTris.isEmpty()) {
                                    return;
                                }
                                for (int i = 0; i < bloodCount + cCount; ++i) {
                                    Triangle randTriangle = (Triangle)capTris.get(ent.field_70170_p.field_73012_v.nextInt(capTris.size()));
                                    float rand1 = ent.field_70170_p.field_73012_v.nextFloat();
                                    float rand2 = ent.field_70170_p.field_73012_v.nextFloat();
                                    if (rand2 < rand1) {
                                        float tmp = rand2;
                                        rand2 = rand1;
                                        rand1 = tmp;
                                    }
                                    Vec3d pos = randTriangle.p1.pos.func_186678_a((double)rand1);
                                    pos = pos.func_178787_e(randTriangle.p2.pos.func_186678_a((double)(rand2 - rand1)));
                                    pos = pos.func_178787_e(randTriangle.p3.pos.func_186678_a((double)(1.0f - rand2)));
                                    pos = pos.func_72441_c(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                                    Random rand = ent.field_70170_p.field_73012_v;
                                    if (i < bloodCount) {
                                        ParticleBlood blood = new ParticleBlood(ent.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0f, 0.4f + rand.nextFloat() * 0.4f, 18 + rand.nextInt(10), 0.05f);
                                        Vec3d direction = Minecraft.func_71410_x().field_71439_g.func_70676_i(1.0f).func_72431_c(new Vec3d((double)data[0], (double)data[1], (double)data[2])).func_72432_b().func_186678_a((double)-0.6f);
                                        Vec3d randMotion = new Vec3d(rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0, rand.nextDouble() * 2.0 - 1.0).func_186678_a((double)0.2f);
                                        direction = direction.func_178787_e(randMotion);
                                        blood.motion((float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c);
                                        blood.color(0.5f, 0.1f, 0.1f, 1.0f);
                                        blood.func_189213_a();
                                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)blood);
                                        continue;
                                    }
                                    Vec3d direction = ((Triangle)capTris.get((int)0)).p2.pos.func_178788_d(((Triangle)capTris.get((int)0)).p1.pos).func_72431_c(((Triangle)capTris.get((int)2)).p2.pos.func_178788_d(((Triangle)capTris.get((int)0)).p1.pos)).func_72432_b().func_186678_a(i % 2 == 0 ? 0.4 : -0.4);
                                    NBTTagCompound tag = new NBTTagCompound();
                                    tag.func_74778_a("type", "spark");
                                    tag.func_74778_a("mode", "coneBurst");
                                    tag.func_74780_a("posX", pos.field_72450_a);
                                    tag.func_74780_a("posY", pos.field_72448_b);
                                    tag.func_74780_a("posZ", pos.field_72449_c);
                                    tag.func_74780_a("dirX", direction.field_72450_a);
                                    tag.func_74780_a("dirY", direction.field_72448_b);
                                    tag.func_74780_a("dirZ", direction.field_72449_c);
                                    tag.func_74776_a("r", 0.8f);
                                    tag.func_74776_a("g", 0.6f);
                                    tag.func_74776_a("b", 0.5f);
                                    tag.func_74776_a("a", 1.5f);
                                    tag.func_74768_a("lifetime", 20);
                                    tag.func_74776_a("width", 0.02f);
                                    tag.func_74776_a("length", 0.8f);
                                    tag.func_74776_a("randLength", 1.3f);
                                    tag.func_74776_a("gravity", 0.1f);
                                    tag.func_74776_a("angle", 60.0f);
                                    tag.func_74768_a("count", 12);
                                    tag.func_74776_a("randomVelocity", 0.3f);
                                    MainRegistry.proxy.effectNT(tag);
                                }
                            })) {
                                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
                            }
                            break;
                        }
                        case 4: {
                            ent.func_70106_y();
                            List bHits = (List)m.auxObj;
                            List<Pair<Matrix4f, ModelRenderer>> boxes = ModelRendererUtil.getBoxesFromMob(ent);
                            RigidBody[] bodies = ModelRendererUtil.generateRigidBodiesFromBoxes(ent, boxes);
                            int[] displayLists = ModelRendererUtil.generateDisplayListsFromBoxes(boxes);
                            ResourceLocation tex = ModelRendererUtil.getEntityTexture(ent);
                            for (int i = 0; i < bodies.length; ++i) {
                                for (EntityHitDataHandler.BulletHit b : bHits) {
                                    float dist = (float)b.pos.func_72438_d(bodies[i].globalCentroid.toVec3d());
                                    float falloff = PacketSpecialDeath.pointLightFalloff(1.0f, dist);
                                    float regular = 1.5f * falloff;
                                    bodies[i].impulseVelocityDirect(new Vec3(b.direction.func_186678_a((double)regular)), new Vec3(b.pos));
                                }
                                bodies[i].angularVelocity = bodies[i].angularVelocity.min(10.0).max(-10.0);
                                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleMobGib(ent.field_70170_p, bodies[i], tex, displayLists[i]));
                            }
                            break;
                        }
                    }
                }
            });
            return null;
        }
    }
}

