/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.items.weapon.ItemCrucible;
import com.hbm.items.weapon.ItemSwordCutter;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.PacketSpecialDeath;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketMobSlicer
implements IMessage {
    public Vec3d pos;
    public Vec3d norm;
    public byte tex;

    public PacketMobSlicer() {
    }

    public PacketMobSlicer(Vec3d position, Vec3d normal, byte tex) {
        this.pos = position;
        this.norm = normal;
        this.tex = tex;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.norm = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.tex = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.pos.field_72450_a);
        buf.writeDouble(this.pos.field_72448_b);
        buf.writeDouble(this.pos.field_72449_c);
        buf.writeDouble(this.norm.field_72450_a);
        buf.writeDouble(this.norm.field_72448_b);
        buf.writeDouble(this.norm.field_72449_c);
        buf.writeByte((int)this.tex);
    }

    public static class Handler
    implements IMessageHandler<PacketMobSlicer, IMessage> {
        public IMessage onMessage(PacketMobSlicer m, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            ItemStack heldStack = p.func_184614_ca();
            if (!(heldStack.func_77973_b() instanceof ItemSwordCutter)) {
                return null;
            }
            p.func_184102_h().func_152344_a(() -> {
                ArrayList<EntityLivingBase> attack = new ArrayList<EntityLivingBase>();
                Vec3d eye = p.func_174824_e(1.0f);
                Vec3d v1 = p.func_70040_Z();
                Vec3d v2 = m.pos.func_178788_d(eye);
                for (float i = 0.0f; i <= 1.0f; i += 0.1f) {
                    Vec3d dir = new Vec3d(v1.field_72450_a + (v2.field_72450_a - v1.field_72450_a) * (double)i, v1.field_72448_b + (v2.field_72448_b - v1.field_72448_b) * (double)i, v1.field_72449_c + (v2.field_72449_c - v1.field_72449_c) * (double)i).func_72432_b();
                    RayTraceResult r = Library.rayTraceIncludeEntities(p.field_70170_p, eye, eye.func_178787_e(dir.func_186678_a(3.0)), (Entity)p);
                    if (r == null || r.field_72313_a != RayTraceResult.Type.ENTITY || !(r.field_72308_g instanceof EntityLivingBase) || attack.contains(r.field_72308_g)) continue;
                    attack.add((EntityLivingBase)r.field_72308_g);
                }
                if (heldStack.func_77973_b() instanceof ItemCrucible) {
                    if (ItemCrucible.getCharges(heldStack) == 0) {
                        return;
                    }
                    if (!attack.isEmpty()) {
                        ItemCrucible.discharge(heldStack);
                    }
                }
                for (EntityLivingBase victim : attack) {
                    Vec3d pos = m.pos.func_178786_a(victim.field_70165_t, victim.field_70163_u, victim.field_70161_v);
                    float[] data = new float[]{(float)m.norm.field_72450_a, (float)m.norm.field_72448_b, (float)m.norm.field_72449_c, -((float)m.norm.func_72430_b(pos)), Float.intBitsToFloat(m.tex)};
                    DamageSource source = m.tex == 1 ? ModDamageSource.crucible : ModDamageSource.slicer;
                    victim.func_110142_aN().func_94547_a(source, victim.func_110143_aJ(), victim.func_110143_aJ());
                    victim.func_70106_y();
                    victim.func_70606_j(0.0f);
                    victim.func_70645_a(source);
                    victim.func_174812_G();
                    PacketDispatcher.wrapper.sendToAllTracking((IMessage)new PacketSpecialDeath((Entity)victim, 3, data), (Entity)victim);
                    if (!(victim instanceof EntityPlayerMP)) continue;
                    PacketDispatcher.wrapper.sendTo((IMessage)new PacketSpecialDeath((Entity)victim, 3, data), (EntityPlayerMP)victim);
                }
            });
            return null;
        }
    }
}

