/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.items.weapon.ItemGunBase;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GunFXPacket
implements IMessage {
    public String playerUUID;
    public EnumHand hand;
    public FXType type;

    public GunFXPacket() {
    }

    public GunFXPacket(EntityPlayer player, EnumHand hand, FXType type) {
        this.hand = hand;
        this.playerUUID = player.func_110124_au().toString();
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        byte[] bytes = new byte[buf.readInt()];
        buf.readBytes(bytes);
        this.playerUUID = new String(bytes);
        this.type = FXType.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
        byte[] bytes = this.playerUUID.getBytes();
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
        buf.writeInt(this.type.ordinal());
    }

    public static enum FXType {
        FIRE;

    }

    public static class Handler
    implements IMessageHandler<GunFXPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(GunFXPacket m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(UUID.fromString(m.playerUUID));
                ItemStack stack = player.func_184586_b(m.hand);
                if (stack.func_77973_b() instanceof ItemGunBase) {
                    boolean isThirdPerson;
                    boolean bl = isThirdPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O > 0 || player != Minecraft.func_71410_x().field_71439_g;
                    if (m.type == FXType.FIRE) {
                        ((ItemGunBase)stack.func_77973_b()).onFireClient(stack, player, isThirdPerson);
                    }
                }
            });
            return null;
        }
    }
}

