/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.config.CompatibilityConfig;
import com.hbm.handler.GunConfiguration;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.main.ModEventHandlerClient;
import com.hbm.main.ResourceManager;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.GunFXPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.tau.ParticleTauBeam;
import com.hbm.particle.tau.ParticleTauHit;
import com.hbm.particle.tau.ParticleTauLightning;
import com.hbm.particle.tau.ParticleTauMuzzleLightning;
import com.hbm.particle.tau.ParticleTauParticleFirstPerson;
import com.hbm.particle.tau.ParticleTauRay;
import com.hbm.render.RenderHelper;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.sound.AudioWrapper;
import com.hbm.util.BobMathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ItemGunGauss
extends ItemGunBase {
    private AudioWrapper chargeLoop;
    public static int firstPersonFireCounter = -1;

    public ItemGunGauss(GunConfiguration config, GunConfiguration alt, String s) {
        super(config, alt, s);
    }

    @Override
    public void endAction(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
        if (ItemGunGauss.getHasShot(stack)) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.sparkShoot, SoundCategory.PLAYERS, 1.0f, 1.0f);
            ItemGunGauss.setHasShot(stack, false);
        }
        if (!main2 && ItemGunGauss.getStored(stack) > 0) {
            this.doTauShot(player.field_70170_p, (Entity)player, player.func_174824_e(MainRegistry.proxy.partialTicks()), player.func_70676_i(MainRegistry.proxy.partialTicks()), (float)Math.min(ItemGunGauss.getStored(stack), 13) * 3.5f);
            PacketDispatcher.sendTo(new GunAnimationPacket(HbmAnimations.AnimType.ALT_CYCLE.ordinal(), hand), (EntityPlayerMP)player);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.tauShoot, SoundCategory.PLAYERS, 1.0f, 0.75f);
            ItemGunGauss.setItemWear(stack, ItemGunGauss.getItemWear(stack) + ItemGunGauss.getCharge(stack) * 2);
            ItemGunGauss.setCharge(stack, 0);
        }
    }

    public void doTauShot(World world, @Nullable Entity player, Vec3d prevPos, Vec3d direction, float damage) {
        RayTraceResult r;
        int MAX_BOUNCES = 4;
        for (int i = 0; i < 4 && (r = Library.rayTraceIncludeEntities(world, prevPos, direction.func_186678_a(40.0).func_178787_e(prevPos), player)) != null && r.field_72313_a != RayTraceResult.Type.MISS; ++i) {
            if (r.field_72313_a == RayTraceResult.Type.ENTITY && CompatibilityConfig.isWarDim(world)) {
                try {
                    if (hurtResistantTime == null) {
                        hurtResistantTime = ReflectionHelper.findField(Entity.class, (String)"hurtResistantTime", (String)"field_70172_ad");
                    }
                    hurtResistantTime.setInt(r.field_72308_g, 0);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                r.field_72308_g.func_70097_a(ModDamageSource.causeTauDamage(player, null), damage);
                break;
            }
            Vec3d normal = new Vec3d((double)r.field_178784_b.func_82601_c(), (double)r.field_178784_b.func_96559_d(), (double)r.field_178784_b.func_82599_e());
            if (Math.acos(normal.func_72430_b(direction.func_186678_a(-1.0))) > Math.toRadians(20.0)) {
                switch (r.field_178784_b.func_176740_k()) {
                    case X: {
                        direction = new Vec3d(-direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
                        break;
                    }
                    case Y: {
                        direction = new Vec3d(direction.field_72450_a, -direction.field_72448_b, direction.field_72449_c);
                        break;
                    }
                    case Z: {
                        direction = new Vec3d(direction.field_72450_a, direction.field_72448_b, -direction.field_72449_c);
                    }
                }
                prevPos = r.field_72307_f.func_178787_e(direction.func_186678_a(0.01));
                continue;
            }
            for (int j = 0; j < 3 + world.field_73012_v.nextInt(5); ++j) {
                Vec3 up = Vec3.createVectorHelper(0.0, 1.0, 0.0);
                up.rotateAroundX((float)Math.toRadians(world.field_73012_v.nextFloat() * 75.0f));
                up.rotateAroundY((float)Math.toRadians(world.field_73012_v.nextFloat() * 360.0f));
                Vec3 direction2 = new Vec3(direction);
                Vec3 angles = BobMathUtil.getEulerAngles(direction2);
                Vec3 newDirection = Vec3.createVectorHelper(up.xCoord, up.yCoord, up.zCoord);
                newDirection.rotateAroundX((float)Math.toRadians(angles.yCoord - 90.0));
                newDirection.rotateAroundY((float)Math.toRadians(angles.xCoord));
                newDirection = newDirection.mult(3.0f);
                RayTraceResult r2 = Library.rayTraceIncludeEntities(world, r.field_72307_f.func_72441_c(newDirection.xCoord * 0.01, newDirection.yCoord * 0.01, newDirection.zCoord * 0.01), r.field_72307_f.func_72441_c(newDirection.xCoord, newDirection.yCoord, newDirection.zCoord), player);
                if (r2 != null && r2.field_72313_a == RayTraceResult.Type.BLOCK) {
                    Vec3d vec1 = r2.field_72307_f.func_178787_e(new Vec3d(newDirection.xCoord * 0.01, newDirection.yCoord * 0.01, newDirection.zCoord * 0.01));
                    Vec3d vec2 = r.field_72307_f.func_178787_e(new Vec3d(newDirection.xCoord, newDirection.yCoord, newDirection.zCoord));
                    r2 = Library.rayTraceIncludeEntities(world, vec1, vec2, player);
                }
                if (r2 == null || r2.field_72313_a != RayTraceResult.Type.ENTITY || !CompatibilityConfig.isWarDim(world)) continue;
                try {
                    if (hurtResistantTime == null) {
                        hurtResistantTime = ReflectionHelper.findField(Entity.class, (String)"hurtResistantTime", (String)"field_70172_ad");
                    }
                    hurtResistantTime.setInt(r2.field_72308_g, 0);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                r2.field_72308_g.func_70097_a(ModDamageSource.causeTauDamage(player, null), damage * 0.5f);
            }
            break;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void endActionClient(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
        if (this.chargeLoop != null) {
            this.chargeLoop.stopSound();
            this.chargeLoop = null;
        }
        if (firstPersonFireCounter > 10) {
            for (int i = 0; i < 50; ++i) {
                double randX = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
                double randY = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
                double randZ = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
                ParticleTauParticleFirstPerson t = new ParticleTauParticleFirstPerson(player.field_70170_p, -1.25 - (double)(player.field_70170_p.field_73012_v.nextFloat() * 0.28f) + randX, 0.25 + randY, 0.2 + randZ, 1.8f);
                t.color(1.0f, 0.7f, 0.1f, 0.05f);
                t.lifetime(40);
                t.fadeIn(false);
                ModEventHandlerClient.firstPersonAuxParticles.add(t);
            }
            ItemGunGauss.doTauBeamFX(player, 1.0f, 0.9f, 0.6f, 1.0f, 12, (Entity)player);
            Vec3d motion = player.func_70040_Z().func_186678_a((double)(-((float)firstPersonFireCounter / 300.0f)));
            player.field_70159_w += motion.field_72450_a;
            player.field_70181_x += motion.field_72448_b;
            player.field_70179_y += motion.field_72449_c;
        }
        firstPersonFireCounter = -1;
    }

    @Override
    protected void altFire(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        ItemGunGauss.setCharge(stack, 1);
    }

    @Override
    public void startAction(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
        super.startAction(stack, world, player, main2, hand);
        if (!main2 && ItemGunGauss.getItemWear(stack) < this.mainConfig.durability && Library.hasInventoryItem(player.field_71071_by, ModItems.gun_xvl1456_ammo)) {
            PacketDispatcher.sendTo(new GunAnimationPacket(HbmAnimations.AnimType.SPINUP.ordinal(), hand), (EntityPlayerMP)player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onFireClient(ItemStack stack, EntityPlayer player, boolean shouldDoThirdPerson) {
        for (int i = 0; i < 50; ++i) {
            double randX = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
            double randY = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
            double randZ = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
            ParticleTauParticleFirstPerson t = new ParticleTauParticleFirstPerson(player.field_70170_p, -1.25 - (double)(player.field_70170_p.field_73012_v.nextFloat() * 0.28f) + randX, 0.25 + randY, 0.2 + randZ, 1.8f);
            t.color(1.0f, 0.7f, 0.1f, 0.05f);
            t.lifetime(40);
            t.fadeIn(false);
            ModEventHandlerClient.firstPersonAuxParticles.add(t);
        }
        ItemGunGauss.doTauBeamFX(player, 1.0f, 0.7f, 0.1f, 1.0f, 4, (Entity)player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void doTauBeamFX(EntityPlayer player, float r, float g, float b, float a, int life, @Nullable Entity shooter) {
        ArrayList<Vec3d> hitPoints = new ArrayList<Vec3d>(3);
        ItemGunGauss.doTauBeamHits(player.field_70170_p, player.func_174824_e(MainRegistry.proxy.partialTicks()), player.func_70676_i(MainRegistry.proxy.partialTicks()), hitPoints, shooter);
        Vec3d[] hps = hitPoints.toArray(new Vec3d[hitPoints.size()]);
        hps[0] = new Vec3d(-0.38, -0.22, 0.3).func_178789_a(-((float)Math.toRadians(player.field_70125_A))).func_178785_b(-((float)Math.toRadians(player.field_70759_as))).func_178787_e(player.func_174824_e(MainRegistry.proxy.partialTicks()));
        ParticleTauBeam beam = new ParticleTauBeam(player.field_70170_p, hps, 0.2f);
        beam.color(r, g, b, a);
        beam.lifetime(life);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)beam);
    }

    @SideOnly(value=Side.CLIENT)
    public static void doTauBeamHits(World world, Vec3d prevPos, Vec3d direction, List<Vec3d> hitPoints, @Nullable Entity shooter) {
        int MAX_BOUNCES = 4;
        hitPoints.add(prevPos);
        for (int i = 0; i < 4; ++i) {
            Vec3d normal;
            RayTraceResult r = Library.rayTraceIncludeEntities(world, prevPos, direction.func_186678_a(40.0).func_178787_e(prevPos), shooter);
            if (r == null || r.field_72313_a == RayTraceResult.Type.MISS) {
                hitPoints.add(direction.func_186678_a(40.0).func_178787_e(prevPos));
                break;
            }
            if (r.field_72313_a == RayTraceResult.Type.ENTITY) {
                normal = new Vec3d((double)r.field_178784_b.func_82601_c(), (double)r.field_178784_b.func_96559_d(), (double)r.field_178784_b.func_82599_e());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleTauHit(world, r.field_72307_f.field_72450_a, r.field_72307_f.field_72448_b, r.field_72307_f.field_72449_c, 0.5f, normal));
                hitPoints.add(r.field_72307_f);
                switch (r.field_178784_b.func_176740_k()) {
                    case X: {
                        direction = new Vec3d(-direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
                        break;
                    }
                    case Y: {
                        direction = new Vec3d(direction.field_72450_a, -direction.field_72448_b, direction.field_72449_c);
                        break;
                    }
                    case Z: {
                        direction = new Vec3d(direction.field_72450_a, direction.field_72448_b, -direction.field_72449_c);
                    }
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("type", "spark");
                tag.func_74778_a("mode", "coneBurst");
                tag.func_74780_a("posX", r.field_72307_f.field_72450_a);
                tag.func_74780_a("posY", r.field_72307_f.field_72448_b);
                tag.func_74780_a("posZ", r.field_72307_f.field_72449_c);
                tag.func_74780_a("dirX", direction.field_72450_a * 0.5);
                tag.func_74780_a("dirY", direction.field_72448_b * 0.5);
                tag.func_74780_a("dirZ", direction.field_72449_c * 0.5);
                tag.func_74776_a("r", 1.0f);
                tag.func_74776_a("g", 0.9f);
                tag.func_74776_a("b", 0.9f);
                tag.func_74776_a("a", 1.0f);
                tag.func_74768_a("lifetime", 5);
                tag.func_74768_a("randLifetime", 8);
                tag.func_74776_a("width", 0.01f);
                tag.func_74776_a("length", 0.5f);
                tag.func_74776_a("gravity", 0.1f);
                tag.func_74776_a("angle", 70.0f);
                tag.func_74768_a("count", 5 + world.field_73012_v.nextInt(3));
                tag.func_74776_a("randomVelocity", 0.1f);
                MainRegistry.proxy.effectNT(tag);
                break;
            }
            hitPoints.add(r.field_72307_f);
            normal = new Vec3d((double)r.field_178784_b.func_82601_c(), (double)r.field_178784_b.func_96559_d(), (double)r.field_178784_b.func_82599_e());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleTauHit(world, r.field_72307_f.field_72450_a, r.field_72307_f.field_72448_b, r.field_72307_f.field_72449_c, 0.75f, normal));
            if (Math.acos(normal.func_72430_b(direction.func_186678_a(-1.0))) > Math.toRadians(20.0)) {
                switch (r.field_178784_b.func_176740_k()) {
                    case X: {
                        direction = new Vec3d(-direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
                        break;
                    }
                    case Y: {
                        direction = new Vec3d(direction.field_72450_a, -direction.field_72448_b, direction.field_72449_c);
                        break;
                    }
                    case Z: {
                        direction = new Vec3d(direction.field_72450_a, direction.field_72448_b, -direction.field_72449_c);
                    }
                }
                prevPos = r.field_72307_f.func_178787_e(direction.func_186678_a(0.01));
                continue;
            }
            for (int j = 0; j < 3 + world.field_73012_v.nextInt(5); ++j) {
                ParticleTauRay ray;
                Vec3 up = Vec3.createVectorHelper(0.0, 1.0, 0.0);
                up.rotateAroundX((float)Math.toRadians(world.field_73012_v.nextFloat() * 45.0f));
                up.rotateAroundY((float)Math.toRadians(world.field_73012_v.nextFloat() * 360.0f));
                Vec3 direction2 = new Vec3(direction);
                Vec3 angles = BobMathUtil.getEulerAngles(direction2);
                Vec3 newDirection = Vec3.createVectorHelper(up.xCoord, up.yCoord, up.zCoord);
                newDirection.rotateAroundX((float)Math.toRadians(angles.yCoord - 90.0));
                newDirection.rotateAroundY((float)Math.toRadians(angles.xCoord));
                newDirection = newDirection.mult(3.0f);
                RayTraceResult r2 = Library.rayTraceIncludeEntities(world, r.field_72307_f.func_72441_c(newDirection.xCoord * 0.01, newDirection.yCoord * 0.01, newDirection.zCoord * 0.01), r.field_72307_f.func_72441_c(newDirection.xCoord, newDirection.yCoord, newDirection.zCoord), shooter);
                if (r2 != null && r2.field_72313_a == RayTraceResult.Type.BLOCK) {
                    Vec3d vec1 = r2.field_72307_f.func_178787_e(new Vec3d(newDirection.xCoord * 0.01, newDirection.yCoord * 0.01, newDirection.zCoord * 0.01));
                    Vec3d vec2 = r.field_72307_f.func_178787_e(new Vec3d(newDirection.xCoord, newDirection.yCoord, newDirection.zCoord));
                    r2 = Library.rayTraceIncludeEntities(world, vec1, vec2, shooter);
                }
                if (r2 == null || r2.field_72313_a == RayTraceResult.Type.MISS) {
                    ray = new ParticleTauRay(world, new Vec3d[]{r.field_72307_f, new Vec3d(newDirection.xCoord, newDirection.yCoord, newDirection.zCoord).func_178787_e(r.field_72307_f)}, 0.25f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)ray);
                    continue;
                }
                if (r2.field_72313_a == RayTraceResult.Type.ENTITY) {
                    normal = new Vec3d((double)r2.field_178784_b.func_82601_c(), (double)r2.field_178784_b.func_96559_d(), (double)r2.field_178784_b.func_82599_e());
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleTauHit(world, r2.field_72307_f.field_72450_a, r2.field_72307_f.field_72448_b, r2.field_72307_f.field_72449_c, 0.5f, normal));
                    ray = new ParticleTauRay(world, new Vec3d[]{r.field_72307_f, r2.field_72307_f}, 0.25f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)ray);
                    switch (r2.field_178784_b.func_176740_k()) {
                        case X: {
                            direction = new Vec3d(-direction.field_72450_a, direction.field_72448_b, direction.field_72449_c);
                            break;
                        }
                        case Y: {
                            direction = new Vec3d(direction.field_72450_a, -direction.field_72448_b, direction.field_72449_c);
                            break;
                        }
                        case Z: {
                            direction = new Vec3d(direction.field_72450_a, direction.field_72448_b, -direction.field_72449_c);
                        }
                    }
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("type", "spark");
                    tag.func_74778_a("mode", "coneBurst");
                    tag.func_74780_a("posX", r2.field_72307_f.field_72450_a);
                    tag.func_74780_a("posY", r2.field_72307_f.field_72448_b);
                    tag.func_74780_a("posZ", r2.field_72307_f.field_72449_c);
                    tag.func_74780_a("dirX", direction.field_72450_a * 0.5);
                    tag.func_74780_a("dirY", direction.field_72448_b * 0.5);
                    tag.func_74780_a("dirZ", direction.field_72449_c * 0.5);
                    tag.func_74776_a("r", 1.0f);
                    tag.func_74776_a("g", 0.9f);
                    tag.func_74776_a("b", 0.9f);
                    tag.func_74776_a("a", 1.0f);
                    tag.func_74768_a("lifetime", 5);
                    tag.func_74768_a("randLifetime", 8);
                    tag.func_74776_a("width", 0.01f);
                    tag.func_74776_a("length", 0.5f);
                    tag.func_74776_a("gravity", 0.1f);
                    tag.func_74776_a("angle", 70.0f);
                    tag.func_74768_a("count", 5 + world.field_73012_v.nextInt(3));
                    tag.func_74776_a("randomVelocity", 0.1f);
                    MainRegistry.proxy.effectNT(tag);
                    continue;
                }
                ray = new ParticleTauRay(world, new Vec3d[]{r.field_72307_f, r2.field_72307_f}, 0.25f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)ray);
                normal = new Vec3d((double)r2.field_178784_b.func_82601_c(), (double)r2.field_178784_b.func_96559_d(), (double)r2.field_178784_b.func_82599_e());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleTauHit(world, r2.field_72307_f.field_72450_a, r2.field_72307_f.field_72448_b, r2.field_72307_f.field_72449_c, 0.75f, normal));
            }
            break;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void startActionClient(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
        if (!main2 && ItemGunGauss.getItemWear(stack) < this.mainConfig.durability && Library.hasInventoryItem(player.field_71071_by, ModItems.gun_xvl1456_ammo)) {
            this.chargeLoop = MainRegistry.proxy.getLoopedSound(HBMSoundHandler.tauChargeLoop2, SoundCategory.PLAYERS, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 1.0f, 0.75f);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.tauChargeLoop2, SoundCategory.PLAYERS, 1.0f, 0.75f);
            firstPersonFireCounter = 0;
            if (this.chargeLoop != null) {
                this.chargeLoop.startSound();
            }
            ModEventHandlerClient.firstPersonAuxParticles.clear();
        }
    }

    @Override
    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, EnumHand isCurrentItem) {
        super.updateServer(stack, world, player, slot, isCurrentItem);
        if (ItemGunGauss.getIsAltDown(stack) && ItemGunGauss.getItemWear(stack) < this.mainConfig.durability) {
            int c = ItemGunGauss.getCharge(stack);
            if (c > 200) {
                ItemGunGauss.setCharge(stack, 0);
                ItemGunGauss.setItemWear(stack, this.mainConfig.durability);
                if (CompatibilityConfig.isWarDim(world)) {
                    player.func_70097_a(ModDamageSource.tauBlast, 1000.0f);
                    world.func_72885_a((Entity)player, player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v, 5.0f, true, true);
                }
                return;
            }
            if (c > 0) {
                ItemGunGauss.setCharge(stack, c + 1);
                if (c % 10 == 1 && c < 140 && c > 2) {
                    if (Library.hasInventoryItem(player.field_71071_by, ModItems.gun_xvl1456_ammo)) {
                        Library.consumeInventoryItem(player.field_71071_by, ModItems.gun_xvl1456_ammo);
                        ItemGunGauss.setStored(stack, ItemGunGauss.getStored(stack) + 1);
                    } else {
                        ItemGunGauss.setCharge(stack, 0);
                        ItemGunGauss.setStored(stack, 0);
                    }
                }
            } else {
                ItemGunGauss.setStored(stack, 0);
            }
        } else {
            ItemGunGauss.setCharge(stack, 0);
            ItemGunGauss.setStored(stack, 0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomHudElement() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHud(ScaledResolution res, GuiIngame gui, ItemStack stack, float partialTicks) {
        float x = res.func_78326_a() / 2;
        float y = res.func_78328_b() / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.gluontau_hud);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.drawGuiRect(x - 2.0f, y - 2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 1.0f, 1.0f);
        RenderHelper.resetColor();
        GlStateManager.func_179084_k();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateClient(ItemStack stack, World world, EntityPlayer player, int slot, EnumHand isCurrentItem) {
        super.updateClient(stack, world, player, slot, isCurrentItem);
        if (ItemGunGauss.getItemWear(stack) >= this.mainConfig.durability && firstPersonFireCounter >= 0) {
            this.endActionClient(stack, world, player, false, isCurrentItem);
        }
        if (firstPersonFireCounter >= 0) {
            ParticleTauLightning lightning = new ParticleTauLightning(world, 0.0, 0.25, 0.2, 5.0f + Math.min((float)firstPersonFireCounter / 25.0f, 2.0f), 8.0f + world.field_73012_v.nextFloat() * 15.0f);
            lightning.lifetime(4);
            lightning.color(1.0f, 0.5f, 0.1f, 0.1f + (float)Math.min((double)((float)firstPersonFireCounter / 400.0f), 0.1));
            ModEventHandlerClient.firstPersonAuxParticles.add(lightning);
            if (firstPersonFireCounter % 3 == 0) {
                ParticleTauParticleFirstPerson t = new ParticleTauParticleFirstPerson(world, -1.25, 0.25, 0.2, 1.0f + Math.min((float)firstPersonFireCounter / 10.0f, 10.0f));
                ParticleTauParticleFirstPerson t2 = new ParticleTauParticleFirstPerson(world, 0.0, 0.25, 0.2, 10.0f + Math.min((float)firstPersonFireCounter / 10.0f, 10.0f));
                t.color(1.0f, 0.35f, 0.1f, 1.5f);
                t.lifetime(5);
                t2.color(1.0f, 0.35f, 0.1f, 0.8f + Math.min((float)firstPersonFireCounter / 800.0f, 1.0f));
                t2.lifetime(5);
                ModEventHandlerClient.firstPersonAuxParticles.add(t);
                ModEventHandlerClient.firstPersonAuxParticles.add(t2);
            }
            if (firstPersonFireCounter > 20) {
                for (int i = 0; i < 3; ++i) {
                    double randX = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
                    double randY = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
                    double randZ = player.field_70170_p.field_73012_v.nextGaussian() * 0.01;
                    ParticleTauParticleFirstPerson t = new ParticleTauParticleFirstPerson(world, -1.25 - (double)(world.field_73012_v.nextFloat() * 0.28f) + randX, 0.25 + randY, 0.2 + randZ, 0.4f + Math.min((float)firstPersonFireCounter / 10.0f, 1.5f));
                    t.color(1.0f, 0.7f, 0.1f, 0.05f);
                    t.lifetime(40);
                    ModEventHandlerClient.firstPersonAuxParticles.add(t);
                }
            }
            if (firstPersonFireCounter == 100) {
                ParticleTauMuzzleLightning ml = new ParticleTauMuzzleLightning(world, -1.5, 0.25, 0.2, 0.1f);
                ModEventHandlerClient.firstPersonAuxParticles.add(ml);
            }
            if (firstPersonFireCounter > 40 && (firstPersonFireCounter % 10 == 0 || firstPersonFireCounter % 7 == 0) || firstPersonFireCounter > 120 && (firstPersonFireCounter % 8 == 0 || firstPersonFireCounter % 5 == 0)) {
                float offset = (1.0f - (float)firstPersonFireCounter / 200.0f) * 0.05f;
                Vec3d pos = new Vec3d(-0.48, -0.15 - (double)offset, 1.3).func_178789_a(-((float)Math.toRadians(player.field_70125_A))).func_178785_b(-((float)Math.toRadians(player.field_70759_as))).func_178787_e(player.func_174824_e(MainRegistry.proxy.partialTicks()));
                Vec3d pos2 = new Vec3d(-0.47, -0.15 - (double)offset, 1.3).func_178789_a(-((float)Math.toRadians(player.field_70125_A))).func_178785_b(-((float)Math.toRadians(player.field_70759_as))).func_178787_e(player.func_174824_e(MainRegistry.proxy.partialTicks()));
                Vec3d direction = pos2.func_178788_d(pos).func_72432_b();
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("type", "spark");
                tag.func_74778_a("mode", "coneBurst");
                tag.func_74780_a("posX", pos.field_72450_a);
                tag.func_74780_a("posY", pos.field_72448_b);
                tag.func_74780_a("posZ", pos.field_72449_c);
                tag.func_74780_a("dirX", direction.field_72450_a * 0.1);
                tag.func_74780_a("dirY", direction.field_72448_b * 0.1 - 0.05);
                tag.func_74780_a("dirZ", direction.field_72449_c * 0.1);
                tag.func_74776_a("r", 1.0f);
                tag.func_74776_a("g", 0.7f);
                tag.func_74776_a("b", 0.1f);
                tag.func_74776_a("a", 1.0f);
                tag.func_74768_a("lifetime", 5);
                tag.func_74768_a("randLifetime", 8);
                tag.func_74776_a("width", 0.0075f);
                tag.func_74776_a("length", 0.3f);
                tag.func_74776_a("gravity", 0.04f);
                tag.func_74776_a("angle", 30.0f);
                tag.func_74768_a("count", 3 + player.field_70170_p.field_73012_v.nextInt(3));
                tag.func_74776_a("randomVelocity", 0.1f);
                MainRegistry.proxy.effectNT(tag);
            }
            ++firstPersonFireCounter;
        }
        if (this.chargeLoop != null) {
            this.chargeLoop.updatePosition((float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
            this.chargeLoop.updatePitch(this.chargeLoop.getPitch() + 0.01f);
        }
    }

    @Override
    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config, EnumHand hand) {
        if (this.mainConfig.animations.containsKey((Object)HbmAnimations.AnimType.CYCLE) && player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal(), hand), (EntityPlayerMP)player);
        }
        PacketDispatcher.wrapper.sendToAllTracking((IMessage)new GunFXPacket(player, hand, GunFXPacket.FXType.FIRE), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0));
        this.doTauShot(player.field_70170_p, (Entity)player, player.func_174824_e(MainRegistry.proxy.partialTicks()), player.func_70676_i(MainRegistry.proxy.partialTicks()), 8.0f);
        ItemGunGauss.setHasShot(stack, true);
    }

    public static void setHasShot(ItemStack stack, boolean b) {
        ItemGunGauss.writeNBT(stack, "hasShot", b ? 1 : 0);
    }

    public static boolean getHasShot(ItemStack stack) {
        return ItemGunGauss.readNBT(stack, "hasShot") == 1;
    }

    public static void setCharge(ItemStack stack, int i) {
        ItemGunGauss.writeNBT(stack, "gauss_charge", i);
    }

    public static int getCharge(ItemStack stack) {
        return ItemGunGauss.readNBT(stack, "gauss_charge");
    }

    public static void setStored(ItemStack stack, int i) {
        ItemGunGauss.writeNBT(stack, "gauss_stored", i);
    }

    public static int getStored(ItemStack stack) {
        return ItemGunGauss.readNBT(stack, "gauss_stored");
    }
}

