/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.entity.particle.EntitySSmokeFX;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.interfaces.IHoldableWeapon;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.render.misc.RenderScreenOverlay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class GunFolly
extends Item
implements IHoldableWeapon {
    @Override
    public RenderScreenOverlay.Crosshair getCrosshair() {
        return RenderScreenOverlay.Crosshair.L_SPLIT;
    }

    public GunFolly(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.field_77777_bU = 1;
        ModItems.ALL_ITEMS.add(this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int state = GunFolly.getState(stack);
        if (state == 0) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.follyOpen, SoundCategory.PLAYERS, 1.0f, 1.0f);
            GunFolly.setState(stack, 1);
        } else if (state == 1) {
            if (Library.hasInventoryItem(player.field_71071_by, ModItems.ammo_folly)) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.follyReload, SoundCategory.PLAYERS, 1.0f, 1.0f);
                Library.consumeInventoryItem(player.field_71071_by, ModItems.ammo_folly);
                GunFolly.setState(stack, 2);
            } else {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.follyClose, SoundCategory.PLAYERS, 1.0f, 1.0f);
                GunFolly.setState(stack, 0);
            }
        } else if (state == 2) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.follyClose, SoundCategory.PLAYERS, 1.0f, 1.0f);
            GunFolly.setState(stack, 3);
            GunFolly.setTimer(stack, 100);
        } else if (state == 3 && GunFolly.getTimer(stack) == 0) {
            GunFolly.setState(stack, 0);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HBMSoundHandler.follyFire, SoundCategory.PLAYERS, 1.0f, 1.0f);
            double mult = 1.75;
            player.field_70159_w -= player.func_70040_Z().field_72450_a * mult;
            player.field_70181_x -= player.func_70040_Z().field_72448_b * mult;
            player.field_70179_y -= player.func_70040_Z().field_72449_c * mult;
            if (!world.field_72995_K) {
                EntityBulletBase bullet = new EntityBulletBase(world, BulletConfigSyncingUtil.TEST_CONFIG, (EntityLivingBase)player, player.func_184614_ca() == stack ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
                world.func_72838_d((Entity)bullet);
                for (int i = 0; i < 25; ++i) {
                    EntitySSmokeFX flame = new EntitySSmokeFX(world);
                    flame.field_70159_w = player.func_70040_Z().field_72450_a;
                    flame.field_70181_x = player.func_70040_Z().field_72448_b;
                    flame.field_70179_y = player.func_70040_Z().field_72449_c;
                    flame.field_70165_t = player.field_70165_t + flame.field_70159_w + world.field_73012_v.nextGaussian() * 0.35;
                    flame.field_70163_u = player.field_70163_u + flame.field_70181_x + world.field_73012_v.nextGaussian() * 0.35 + (double)player.eyeHeight;
                    flame.field_70161_v = player.field_70161_v + flame.field_70179_y + world.field_73012_v.nextGaussian() * 0.35;
                    world.func_72838_d((Entity)flame);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (GunFolly.getState(stack) == 3) {
            if (isSelected) {
                int timer = GunFolly.getTimer(stack);
                if (timer > 0) {
                    if (--timer % 20 == 0 && timer != 0) {
                        world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.follyBuzzer, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    if (timer == 0) {
                        world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HBMSoundHandler.follyAquired, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    GunFolly.setTimer(stack, timer);
                }
            } else {
                GunFolly.setTimer(stack, 100);
            }
        }
    }

    public static void setState(ItemStack stack, int i) {
        GunFolly.writeNBT(stack, "state", i);
    }

    public static int getState(ItemStack stack) {
        return GunFolly.readNBT(stack, "state");
    }

    public static void setTimer(ItemStack stack, int i) {
        GunFolly.writeNBT(stack, "timer", i);
    }

    public static int getTimer(ItemStack stack) {
        return GunFolly.readNBT(stack, "timer");
    }

    private static void writeNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(key, value);
    }

    private static int readNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(key);
    }
}

