/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.item.IDepthRockTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBedrockOre;
import com.hbm.blocks.generic.BlockBedrockOreTE;
import com.hbm.handler.ToolAbility;
import com.hbm.handler.WeaponAbility;
import com.hbm.items.ModItems;
import com.hbm.items.tool.IItemAbility;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolAbility
extends ItemTool
implements IItemAbility,
IDepthRockTool {
    private EnumToolType toolType;
    private EnumRarity rarity = EnumRarity.COMMON;
    protected float damage;
    protected double movement;
    private List<ToolAbility> breakAbility = new ArrayList<ToolAbility>(){
        private static final long serialVersionUID = 153867601249309418L;
        {
            this.add(null);
        }
    };
    private List<WeaponAbility> hitAbility = new ArrayList<WeaponAbility>();
    private boolean rockBreaker = false;

    public ItemToolAbility(float damage, float attackSpeedIn, double movement, Item.ToolMaterial material, EnumToolType type, String s) {
        super(0.0f, attackSpeedIn, material, type.blocks);
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.damage = damage;
        this.movement = movement;
        this.toolType = type;
        if (type == EnumToolType.MINER) {
            this.setHarvestLevel("shovel", material.func_77996_d());
            this.setHarvestLevel("pickaxe", material.func_77996_d());
            this.setHarvestLevel("axe", material.func_77996_d());
        } else {
            this.setHarvestLevel(type.toString().toLowerCase(), material.func_77996_d());
        }
        ModItems.ALL_ITEMS.add((Item)this);
    }

    public ItemToolAbility addBreakAbility(ToolAbility breakAbility) {
        this.breakAbility.add(breakAbility);
        return this;
    }

    public ItemToolAbility addHitAbility(WeaponAbility weaponAbility) {
        this.hitAbility.add(weaponAbility);
        return this;
    }

    public ItemToolAbility setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity != EnumRarity.COMMON ? this.rarity : super.func_77613_e(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K && !this.hitAbility.isEmpty() && attacker instanceof EntityPlayer && this.canOperate(stack)) {
            for (WeaponAbility ability : this.hitAbility) {
                ability.onHit(attacker.field_70170_p, (EntityPlayer)attacker, (Entity)target, this);
            }
        }
        stack.func_77972_a(2, attacker);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState block = world.func_180495_p(pos);
        if (!world.field_72995_K && this.canHarvestBlock(block, stack) && this.getCurrentAbility(stack) != null && this.canOperate(stack)) {
            this.getCurrentAbility(stack).onDig(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player, block, this, player.func_184614_ca() == stack ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (!this.canOperate(stack)) {
            return 1.0f;
        }
        if (this.toolType == null) {
            return super.func_150893_a(stack, state);
        }
        if (this.toolType.blocks.contains(state.func_177230_c()) || this.toolType.materials.contains(state.func_185904_a())) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        if (!this.canOperate(stack)) {
            return false;
        }
        if (ItemToolAbility.isForbiddenBlock(state.func_177230_c())) {
            return false;
        }
        if (this.getCurrentAbility(stack) instanceof ToolAbility.SilkAbility) {
            return true;
        }
        return this.func_150893_a(stack, state) > 1.0f;
    }

    public static boolean isForbiddenBlock(Block b) {
        return b == Blocks.field_180401_cv || b == Blocks.field_150357_h || b == Blocks.field_150483_bI || b == Blocks.field_185777_dd || b == Blocks.field_185776_dc || b == ModBlocks.ore_bedrock_oil || b instanceof BlockBedrockOre || b instanceof BlockBedrockOreTE;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        HashMultimap map = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("91AEAA56-376B-4498-935B-2F7F68070635"), "Tool modifier", this.movement, 1));
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.damage, 0));
        }
        return map;
    }

    @Override
    public void breakExtraBlock(World world, int x, int y, int z, EntityPlayer playerEntity, int refX, int refY, int refZ, EnumHand hand) {
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175623_d(pos)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        ItemStack stack = player.func_184586_b(hand);
        IBlockState block = world.func_180495_p(pos);
        if (!this.canHarvestBlock(block, stack)) {
            return;
        }
        IBlockState refBlock = world.func_180495_p(new BlockPos(refX, refY, refZ));
        float refStrength = ForgeHooks.blockStrength((IBlockState)refBlock, (EntityPlayer)player, (World)world, (BlockPos)new BlockPos(refX, refY, refZ));
        float strength = ForgeHooks.blockStrength((IBlockState)block, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block.func_177230_c(), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return;
        }
        int event = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos);
        if (event < 0) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_177230_c().func_176208_a(world, pos, block, (EntityPlayer)player);
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, false)) {
                block.func_177230_c().func_176206_d(world, pos, block);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return;
        }
        player.func_184586_b(hand).func_179548_a(world, block, pos, (EntityPlayer)player);
        if (!world.field_72995_K) {
            block.func_177230_c().func_176208_a(world, pos, block, (EntityPlayer)player);
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, true)) {
                block.func_177230_c().func_176206_d(world, pos, block);
                block.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, block, world.func_175625_s(pos), stack);
                block.func_177230_c().func_180637_b(world, pos, event);
            }
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            ItemStack itemstack;
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)block));
            if (block.func_177230_c().removedByPlayer(block, world, pos, (EntityPlayer)player, true)) {
                block.func_177230_c().func_176206_d(world, pos, block);
            }
            if ((itemstack = player.func_184586_b(hand)) != null) {
                itemstack.func_179548_a(world, block, new BlockPos(x, y, z), (EntityPlayer)player);
                if (itemstack.func_190926_b()) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, new BlockPos(x, y, z), Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.getCurrentAbility(stack) != null ? true : super.func_77636_d(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (this.breakAbility.size() > 1) {
            list.add(I18nUtil.resolveKey("tool.ability.list", new Object[0]));
            for (ToolAbility toolAbility : this.breakAbility) {
                if (toolAbility == null) continue;
                if (this.getCurrentAbility(stack) == toolAbility) {
                    list.add(" \u00a7e\u00a7l>" + toolAbility.getFullName());
                    continue;
                }
                list.add("  \u00a76" + toolAbility.getFullName());
            }
            list.add(I18nUtil.resolveKey("tool.ability.rightclick", new Object[0]));
            list.add(I18nUtil.resolveKey("tool.ability.shiftclick", new Object[0]));
        }
        if (!this.hitAbility.isEmpty()) {
            list.add(I18nUtil.resolveKey("tool.ability.weaponlist", new Object[0]));
            for (WeaponAbility weaponAbility : this.hitAbility) {
                list.add("  " + TextFormatting.RED + weaponAbility.getFullName());
            }
        }
        if (this.rockBreaker) {
            list.add("\u00a75[" + I18nUtil.resolveKey("trait.unmineable", new Object[0]) + "]\u00a7d " + I18nUtil.resolveKey("tool.ability.canmine", new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.breakAbility.size() < 2 || !this.canOperate(stack)) {
            return EnumActionResult.PASS;
        }
        if (!worldIn.field_72995_K) {
            this.switchMode(player, stack);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K || this.breakAbility.size() < 2 || !this.canOperate(stack)) {
            return super.func_77659_a(world, player, hand);
        }
        this.switchMode(player, stack);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private void switchMode(EntityPlayer player, ItemStack stack) {
        int i = this.getAbility(stack);
        ++i;
        if (player.func_70093_af()) {
            i = 0;
        }
        this.setAbility(stack, i % this.breakAbility.size());
        while (this.getCurrentAbility(stack) != null && !this.getCurrentAbility(stack).isAllowed()) {
            player.func_145747_a(new TextComponentString("[").func_150257_a((ITextComponent)new TextComponentTranslation("chat.ability", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)new TextComponentTranslation(this.getCurrentAbility(stack).getName(), new Object[0])).func_150257_a(new TextComponentString(this.getCurrentAbility(stack).getExtension() + " ").func_150257_a((ITextComponent)new TextComponentTranslation("chat.blacklist", new Object[0])).func_150257_a((ITextComponent)new TextComponentString("]"))).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            this.setAbility(stack, ++i % this.breakAbility.size());
        }
        if (this.getCurrentAbility(stack) != null) {
            player.func_145747_a(new TextComponentString("[").func_150257_a((ITextComponent)new TextComponentTranslation("chat.abilenabled", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)new TextComponentTranslation(this.getCurrentAbility(stack).getName(), new Object[0])).func_150257_a((ITextComponent)new TextComponentString(this.getCurrentAbility(stack).getExtension() + "]")).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        } else {
            player.func_145747_a(new TextComponentString("[").func_150257_a((ITextComponent)new TextComponentTranslation("chat.abildisabled", new Object[0])).func_150257_a((ITextComponent)new TextComponentString("]")).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        }
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.25f, this.getCurrentAbility(stack) == null ? 0.75f : 1.25f);
    }

    private ToolAbility getCurrentAbility(ItemStack stack) {
        int ability = this.getAbility(stack) % this.breakAbility.size();
        return this.breakAbility.get(ability);
    }

    private int getAbility(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("ability");
        }
        return 0;
    }

    private void setAbility(ItemStack stack, int ability) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("ability", ability);
    }

    protected boolean canOperate(ItemStack stack) {
        return true;
    }

    public ItemToolAbility setDepthRockBreaker() {
        this.rockBreaker = true;
        return this;
    }

    @Override
    public boolean canBreakRock(World world, EntityPlayer player, ItemStack tool, IBlockState block, BlockPos pos) {
        return this.canOperate(tool) && this.rockBreaker;
    }

    public static enum EnumToolType {
        PICKAXE(Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au})),
        AXE(Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151585_k, Material.field_151582_l}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw})),
        SHOVEL(Sets.newHashSet((Object[])new Material[]{Material.field_151571_B, Material.field_151595_p, Material.field_151578_c, Material.field_151597_y, Material.field_151596_z}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_192444_dS})),
        MINER(Sets.newHashSet((Object[])new Material[]{Material.field_151577_b, Material.field_151573_f, Material.field_151574_g, Material.field_151576_e, Material.field_151571_B, Material.field_151595_p, Material.field_151578_c, Material.field_151597_y, Material.field_151596_z}));

        public Set<Material> materials = new HashSet<Material>();
        public Set<Block> blocks = new HashSet<Block>();

        private EnumToolType(Set<Material> materials) {
            this.materials = materials;
        }

        private EnumToolType(Set<Material> materials, Set<Block> blocks) {
            this.materials = materials;
            this.blocks = blocks;
        }
    }
}

