/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.items.armor.ArmorFSBPowered;
import com.hbm.lib.Library;
import com.hbm.render.model.ModelArmorHEV;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ArmorHEV
extends ArmorFSBPowered {
    @SideOnly(value=Side.CLIENT)
    ModelArmorHEV[] models;
    private static long lastSurvey;
    private static float prevResult;
    private static float lastResult;

    public ArmorHEV(ItemArmor.ArmorMaterial material, int layer, EntityEquipmentSlot slot, String texture, long maxPower, long chargeRate, long consumption, long drain, String s) {
        super(material, layer, slot, texture, maxPower, chargeRate, consumption, drain, s);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.models == null) {
            this.models = new ModelArmorHEV[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorHEV(i);
            }
        }
        return this.models[3 - armorSlot.func_188454_b()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleOverlay(RenderGameOverlayEvent.Pre event, EntityPlayer player) {
        if (ArmorHEV.hasFSBArmorIgnoreCharge((EntityLivingBase)player)) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
                event.setCanceled(true);
                return;
            }
            if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
                event.setCanceled(true);
                this.renderOverlay(event, player);
                return;
            }
        }
    }

    private void renderOverlay(RenderGameOverlayEvent.Pre event, EntityPlayer player) {
        float in = 0.0f;
        in = Library.getEntRadCap((Entity)player).getRads();
        float radiation = 0.0f;
        radiation = lastResult - prevResult;
        if (System.currentTimeMillis() >= lastSurvey + 1000L) {
            lastSurvey = System.currentTimeMillis();
            prevResult = lastResult;
            lastResult = in;
        }
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        ScaledResolution res = event.getResolution();
        double scale = 2.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        int hX = (int)(8.0 / scale);
        int hY = (int)((double)(res.func_78328_b() - 18 - 2) / scale);
        int healthColor = player.func_110143_aJ() * 5.0f > 15.0f ? 0xFF8000 : 0xFF0000;
        Minecraft.func_71410_x().field_71466_p.func_78276_b("+" + (int)(player.func_110143_aJ() * 5.0f), hX, hY, healthColor);
        double c = 0.0;
        for (int i = 0; i < 4; ++i) {
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            ArmorFSBPowered item = (ArmorFSBPowered)((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b();
            c += (double)item.getCharge(armor) / (double)item.getMaxCharge();
        }
        int aX = (int)(70.0 / scale);
        int aY = (int)((double)(res.func_78328_b() - 18 - 2) / scale);
        int armorColor = c * 25.0 > 15.0 ? 0xFF8000 : 0xFF0000;
        Minecraft.func_71410_x().field_71466_p.func_78276_b("||" + (int)(c * 25.0), aX, aY, armorColor);
        String rad = "\u2622 [";
        for (int i = 0; i < 10; ++i) {
            if (in / 100.0f > (float)i) {
                int mid = (int)(in - (float)(i * 100));
                if (mid < 33) {
                    rad = rad + "..";
                    continue;
                }
                if (mid < 67) {
                    rad = rad + "|.";
                    continue;
                }
                rad = rad + "||";
                continue;
            }
            rad = rad + " ";
        }
        rad = rad + "]";
        int rX = (int)(8.0 / scale);
        int rY = (int)((double)(res.func_78328_b() - 40) / scale);
        int radColor = in < 800.0f ? 0xFF8000 : 0xFF0000;
        Minecraft.func_71410_x().field_71466_p.func_78276_b(rad, rX, rY, radColor);
        GL11.glScaled((double)(1.0 / scale), (double)(1.0 / scale), (double)(1.0 / scale));
        scale = 1.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        if (radiation > 0.0f) {
            int dX = (int)(32.0 / scale);
            int dY = (int)((double)(res.func_78328_b() - 55) / scale);
            String delta = "" + Math.round(radiation);
            if (radiation > 1000.0f) {
                delta = ">1000";
            } else if (radiation < 1.0f) {
                delta = "<1";
            }
            Minecraft.func_71410_x().field_71466_p.func_78276_b(delta + " RAD/s", dX, dY, 0xFF0000);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }
}

