/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.energy.IBatteryItem;
import com.hbm.blocks.machine.ItemSelfcharger;
import com.hbm.items.gear.ArmorFSB;
import com.hbm.lib.Library;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorFSBPowered
extends ArmorFSB
implements IBatteryItem {
    public long maxPower = 1L;
    public long chargeRate;
    public long consumption;
    public long drain;

    public ArmorFSBPowered(ItemArmor.ArmorMaterial material, int layer, EntityEquipmentSlot slot, String texture, long maxPower, long chargeRate, long consumption, long drain, String s) {
        super(material, layer, slot, texture, s);
        this.maxPower = maxPower;
        this.chargeRate = chargeRate;
        this.consumption = consumption;
        this.drain = drain;
        this.func_77656_e(1);
    }

    public static String getColor(long a, long b) {
        float fraction = 100.0f * (float)a / (float)b;
        if (fraction > 75.0f) {
            return "\u00a7a";
        }
        if (fraction > 25.0f) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        long power = this.getCharge(stack);
        list.add("Charge: " + ArmorFSBPowered.getColor(power, this.maxPower) + Library.getShortNumber(power) + " \u00a72/ " + Library.getShortNumber(this.maxPower));
        super.func_77624_a(stack, worldIn, list, flagIn);
    }

    @Override
    public boolean isArmorEnabled(ItemStack stack) {
        return this.getCharge(stack) > 0L;
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", Math.min(this.maxPower, Math.max(0L, stack.func_77978_p().func_74763_f("charge") + i)));
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", Math.min(this.maxPower, Math.max(0L, i)));
            }
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", i);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", Math.min(this.maxPower, Math.max(0L, stack.func_77978_p().func_74763_f("charge") - i)));
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", Math.min(this.maxPower, Math.max(0L, this.maxPower - i)));
            }
        }
    }

    private ItemSelfcharger getHeldSCBattery(EntityLivingBase entity) {
        if (entity.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemSelfcharger) {
            return (ItemSelfcharger)entity.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
        }
        if (entity.func_184582_a(EntityEquipmentSlot.OFFHAND).func_77973_b() instanceof ItemSelfcharger) {
            return (ItemSelfcharger)entity.func_184582_a(EntityEquipmentSlot.OFFHAND).func_77973_b();
        }
        return null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (this.drain > 0L && ArmorFSB.hasFSBArmor((EntityLivingBase)player)) {
            long netto_drain = this.drain;
            ItemSelfcharger sc_battery = this.getHeldSCBattery((EntityLivingBase)player);
            if (sc_battery != null) {
                netto_drain -= sc_battery.getDischargeRate() / 4L;
            }
            this.dischargeBattery(stack, netto_drain);
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof ArmorFSBPowered) {
            if (stack.func_77942_o()) {
                return stack.func_77978_p().func_74763_f("charge");
            }
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74772_a("charge", ((ArmorFSBPowered)stack.func_77973_b()).maxPower);
            return stack.func_77978_p().func_74763_f("charge");
        }
        return 0L;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCharge(stack) < this.maxPower;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.maxPower;
    }

    @Override
    public long getMaxCharge() {
        return this.maxPower;
    }

    @Override
    public long getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public long getDischargeRate() {
        return 0L;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.dischargeBattery(stack, (long)damage * this.consumption);
    }
}

