/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel.nodes;

import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlEventSystem;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.inventory.control_panel.NodeConnection;
import com.hbm.inventory.control_panel.NodeDropdown;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.NodeType;
import com.hbm.inventory.control_panel.nodes.NodeOutput;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NodeEventBroadcast
extends NodeOutput {
    public String eventName;

    public NodeEventBroadcast(float x, float y, List<ControlEvent> ableToBroadcast) {
        super(x, y);
        NodeDropdown opSelector = new NodeDropdown(this, this.otherElements.size(), s -> {
            this.setEvent((String)s);
            return null;
        }, () -> this.eventName);
        for (ControlEvent c : ableToBroadcast) {
            opSelector.list.addItems(c.name);
        }
        this.otherElements.add(opSelector);
        this.setEvent(ableToBroadcast.get((int)0).name);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        tag.func_74778_a("nodeType", "eventBroadcast");
        tag.func_74778_a("eventName", this.eventName);
        NBTTagCompound list = new NBTTagCompound();
        int i = 0;
        for (String s : ((NodeDropdown)this.otherElements.get((int)0)).list.itemNames) {
            list.func_74778_a("item" + i, s);
            ++i;
        }
        tag.func_74782_a("itemList", (NBTBase)list);
        return super.writeToNBT(tag, sys);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        this.eventName = tag.func_74779_i("eventName");
        super.readFromNBT(tag, sys);
    }

    @Override
    public boolean doOutput(IControllable from, Map<String, NodeSystem> sendNodeMap, List<BlockPos> positions) {
        World world = from.getControlWorld();
        ControlEvent e = ControlEvent.newEvent(this.eventName);
        for (NodeConnection c : this.inputs) {
            if (c.name.startsWith("Cancel")) {
                if (!c.evaluate().getBoolean()) continue;
                return true;
            }
            e.vars.put(c.name, c.evaluate());
        }
        if (sendNodeMap != null) {
            if (sendNodeMap.containsKey(e.name)) {
                NodeSystem sys = sendNodeMap.get(e.name);
                block1: for (int i = 0; i < positions.size(); ++i) {
                    sys.resetCachedValues();
                    sys.setVar("receiver_id", new DataValueFloat(i));
                    for (NodeOutput o : sys.outputNodes) {
                        if (o.doOutput(from, sendNodeMap, positions)) continue;
                        continue block1;
                    }
                    ControlEventSystem.get(world).broadcastEvent(from.getControlPos(), e, positions.get(i));
                }
            } else {
                ControlEventSystem.get(world).broadcastEvent(from.getControlPos(), e, positions);
            }
        } else {
            ControlEventSystem.get(world).broadcastEvent(from.getControlPos(), e, positions);
        }
        return true;
    }

    public void setEvent(String name) {
        this.eventName = name;
        for (NodeConnection c : this.inputs) {
            c.removeConnection();
        }
        this.inputs.clear();
        ControlEvent evt = ControlEvent.getRegisteredEvent(name);
        for (Map.Entry<String, DataValue> e : evt.vars.entrySet()) {
            this.inputs.add(new NodeConnection(e.getKey(), this, this.inputs.size(), true, e.getValue().getType(), e.getValue()));
        }
        this.inputs.add(new NodeConnection("Cancel", this, this.inputs.size(), true, DataValue.DataType.GENERIC, new DataValueFloat(0.0f)));
        this.recalcSize();
    }

    @Override
    public NodeType getType() {
        return NodeType.OUTPUT;
    }

    @Override
    public String getDisplayName() {
        return "Broadcast";
    }
}

