/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.ControlRegistry;
import com.hbm.inventory.control_panel.GuiControlEdit;
import com.hbm.inventory.control_panel.SubElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;

public class SubElementItemChoice
extends SubElement {
    public static ResourceLocation bg_tex = new ResourceLocation("hbm:textures/gui/control_panel/gui_base.png");
    public GuiButton pageLeft;
    public GuiButton pageRight;
    public int currentPage = 1;
    public int numPages = 1;
    public List<GuiButton> buttons = new ArrayList<GuiButton>();

    public SubElementItemChoice(GuiControlEdit gui) {
        super(gui);
    }

    @Override
    protected void initGui() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        this.pageLeft = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX - 80, cY + 92, 15, 20, "<"));
        this.pageRight = this.gui.func_189646_b(new GuiButton(this.gui.currentButtonId(), cX + 65, cY + 92, 15, 20, ">"));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1000, cX - 80, cY - 90 + 0, 160, 20, "Button")));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1001, cX - 80, cY - 90 + 25, 160, 20, "Switch")));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1002, cX - 80, cY - 90 + 50, 160, 20, "Display")));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1003, cX - 80, cY - 90 + 75, 160, 20, "Indicator")));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1004, cX - 80, cY - 90 + 100, 160, 20, "Knob")));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1005, cX - 80, cY - 90 + 125, 160, 20, "Dial")));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1006, cX - 80, cY - 90 + 150, 160, 20, "Label")));
        this.buttons.add(this.gui.func_189646_b(new GuiButton(1007, cX - 80, cY - 90 + 0, 160, 20, "Slider")));
        this.numPages = (this.buttons.size() + 6) / 7;
        super.initGui();
    }

    @Override
    protected void drawScreen() {
        int cX = this.gui.field_146294_l / 2;
        int cY = this.gui.field_146295_m / 2;
        String text = this.currentPage + "/" + this.numPages;
        this.gui.getFontRenderer().func_175065_a(text, (float)cX - (float)this.gui.getFontRenderer().func_78256_a(text) / 2.0f, (float)(cY + 98), -8947849, false);
        text = "Select Control Type";
        this.gui.getFontRenderer().func_175065_a(text, (float)cX - (float)this.gui.getFontRenderer().func_78256_a(text) / 2.0f, (float)(cY - 110), -8947849, false);
    }

    @Override
    protected void renderBackground() {
        this.gui.field_146297_k.func_110434_K().func_110577_a(bg_tex);
        this.gui.func_73729_b(this.gui.getGuiLeft(), this.gui.getGuiTop(), 0, 0, this.gui.getXSize(), this.gui.getYSize());
    }

    private void recalculateVisibleButtons() {
        int idx;
        for (GuiButton b : this.buttons) {
            b.field_146125_m = false;
            b.field_146124_l = false;
        }
        for (int i = idx = (this.currentPage - 1) * 7; i < idx + 7 && i < this.buttons.size(); ++i) {
            this.buttons.get((int)i).field_146125_m = true;
            this.buttons.get((int)i).field_146124_l = true;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.pageLeft) {
            this.currentPage = Math.max(1, this.currentPage - 1);
            this.recalculateVisibleButtons();
        } else if (button == this.pageRight) {
            this.currentPage = Math.min(this.numPages, this.currentPage + 1);
            this.recalculateVisibleButtons();
        } else {
            switch (button.field_146127_k) {
                case 1000: {
                    this.gui.currentEditControl = ControlRegistry.getNew("button_push", this.gui.control.panel);
                    this.gui.itemConfig.variants = ControlRegistry.getAllControlsOfType(this.gui.currentEditControl.getControlType());
                    this.gui.pushElement(this.gui.itemConfig);
                    break;
                }
                case 1001: {
                    this.gui.currentEditControl = ControlRegistry.getNew("switch_toggle", this.gui.control.panel);
                    this.gui.itemConfig.variants = ControlRegistry.getAllControlsOfType(this.gui.currentEditControl.getControlType());
                    this.gui.pushElement(this.gui.itemConfig);
                    break;
                }
                case 1002: {
                    this.gui.currentEditControl = ControlRegistry.getNew("display_7seg", this.gui.control.panel);
                    this.gui.itemConfig.variants = ControlRegistry.getAllControlsOfType(this.gui.currentEditControl.getControlType());
                    this.gui.pushElement(this.gui.itemConfig);
                    break;
                }
                case 1003: {
                    this.gui.currentEditControl = ControlRegistry.getNew("indicator_lamp", this.gui.control.panel);
                    this.gui.pushElement(this.gui.linker);
                    break;
                }
                case 1004: {
                    this.gui.currentEditControl = ControlRegistry.getNew("knob_control", this.gui.control.panel);
                    this.gui.itemConfig.variants = ControlRegistry.getAllControlsOfType(this.gui.currentEditControl.getControlType());
                    this.gui.pushElement(this.gui.itemConfig);
                    break;
                }
                case 1005: {
                    this.gui.currentEditControl = ControlRegistry.getNew("dial_square", this.gui.control.panel);
                    this.gui.itemConfig.variants = ControlRegistry.getAllControlsOfType(this.gui.currentEditControl.getControlType());
                    this.gui.pushElement(this.gui.itemConfig);
                    break;
                }
                case 1006: {
                    this.gui.currentEditControl = ControlRegistry.getNew("label", this.gui.control.panel);
                    this.gui.itemConfig.variants = ControlRegistry.getAllControlsOfType(this.gui.currentEditControl.getControlType());
                    this.gui.pushElement(this.gui.itemConfig);
                    break;
                }
                case 1007: {
                    this.gui.currentEditControl = ControlRegistry.getNew("slider_vertical", this.gui.control.panel);
                    this.gui.pushElement(this.gui.linker);
                }
            }
        }
    }

    @Override
    protected void enableButtons(boolean enable) {
        if (enable) {
            this.recalculateVisibleButtons();
        } else {
            for (GuiButton b : this.buttons) {
                b.field_146125_m = false;
                b.field_146124_l = false;
            }
        }
        this.pageLeft.field_146125_m = enable;
        this.pageLeft.field_146124_l = enable;
        this.pageRight.field_146125_m = enable;
        this.pageRight.field_146124_l = enable;
    }
}

