/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueEnum;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.inventory.control_panel.NodeDropdown;
import com.hbm.inventory.control_panel.NodeElement;
import com.hbm.inventory.control_panel.NodeSystem;
import com.hbm.inventory.control_panel.nodes.Node;
import com.hbm.render.RenderHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class NodeConnection
extends NodeElement {
    public String name;
    public Node connection;
    public int connectionIndex;
    public DataValue defaultValue;
    public boolean drawsLine = false;
    public boolean isInput;
    public DataValue.DataType type;
    public StringBuilder builder;
    public boolean isTyping;
    public NodeDropdown enumSelector = null;

    public NodeConnection(String name, Node p, int idx, boolean isInput, DataValue.DataType type, @Nonnull DataValue defaultVal) {
        super(p, idx);
        this.name = name;
        this.connection = null;
        this.setDefault(defaultVal);
        this.connectionIndex = -1;
        this.isInput = isInput;
        this.type = type;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag, NodeSystem sys) {
        super.writeToNBT(tag, sys);
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("Ci", this.connectionIndex);
        tag.func_74768_a("Ni", sys.nodes.indexOf(this.connection));
        tag.func_74757_a("in", this.isInput);
        tag.func_74768_a("T", this.type.ordinal());
        tag.func_74782_a("D", this.defaultValue.writeToNBT());
        tag.func_74757_a("DL", this.drawsLine);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, NodeSystem sys) {
        super.readFromNBT(tag, sys);
        this.name = tag.func_74779_i("name");
        this.connectionIndex = tag.func_74762_e("Ci");
        int nodeIdx = tag.func_74762_e("Ni");
        this.connection = nodeIdx == -1 ? null : sys.nodes.get(nodeIdx);
        this.isInput = tag.func_74767_n("in");
        this.type = DataValue.DataType.values()[tag.func_74762_e("T") % DataValue.DataType.values().length];
        this.defaultValue = DataValue.newFromNBT(tag.func_74781_a("D"));
        if (this.defaultValue == null) {
            this.type = DataValue.DataType.NUMBER;
            this.defaultValue = new DataValueFloat(0.0f);
        }
        this.drawsLine = tag.func_74767_n("DL");
        this.builder = null;
        this.isTyping = false;
    }

    public void setDefault(@Nonnull DataValue defaultVal) {
        this.defaultValue = defaultVal;
        this.type = defaultVal.getType();
        if (this.type == DataValue.DataType.ENUM) {
            Enum[] vals;
            this.enumSelector = new NodeDropdown(this.parent, this.index, s -> {
                Enum[] vals;
                for (Enum e : vals = ((DataValueEnum)defaultVal).getPossibleValues()) {
                    if (!e.name().equals(s)) continue;
                    this.defaultValue = new DataValueEnum(e);
                    return null;
                }
                return null;
            }, () -> this.defaultValue.toString());
            for (Enum e : vals = ((DataValueEnum)defaultVal).getPossibleValues()) {
                this.enumSelector.list.addItems(e.name());
            }
            this.enumSelector.setOffset(this.offsetX, this.offsetY);
        } else {
            this.enumSelector = null;
        }
    }

    public NodeConnection removeConnection() {
        if (this.connection != null) {
            NodeConnection n = this.connection.outputs.get(this.connectionIndex);
            this.drawsLine = false;
            this.connection = null;
            this.connectionIndex = -1;
            return n;
        }
        return null;
    }

    public NodeConnection setData(Node connection, int connectionIndex, boolean drawsLine) {
        this.connection = connection;
        this.connectionIndex = connectionIndex;
        this.drawsLine = drawsLine;
        return this;
    }

    @Override
    public void resetOffset() {
        super.resetOffset();
        this.offsetY += (float)(this.parent.otherElements.size() * 8);
        if (this.isInput) {
            this.offsetY += (float)(this.parent.outputs.size() * 8);
        }
        if (this.enumSelector != null) {
            this.enumSelector.setOffset(this.offsetX, this.offsetY);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(float mX, float mY) {
        float[] fArray;
        float[] color = this.type.getColor();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(NodeSystem.node_tex);
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float x = this.offsetX + 38.0f + (float)(this.isInput ? -40 : 0);
        float y = this.offsetY + 8.0f;
        RenderHelper.drawGuiRectBatchedColor(x, y, 0.625f, 0.0f, 4.0f, 4.0f, 0.6875f, 0.0625f, color[0], color[1], color[2], 1.0f);
        if (RenderHelper.intersects2DBox(mX, mY, this.getValueBox()) && !this.isTyping) {
            float[] fArray2 = new float[3];
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray = fArray2;
            fArray2[2] = 1.0f;
        } else {
            float[] fArray3 = new float[3];
            fArray3[0] = 0.6f;
            fArray3[1] = 0.6f;
            fArray = fArray3;
            fArray3[2] = 0.6f;
        }
        color = fArray;
        if (this.isInput) {
            if (this.enumSelector != null) {
                Tessellator.func_178181_a().func_78381_a();
                this.enumSelector.render(mX, mY);
                return;
            }
            if (this.connection == null) {
                RenderHelper.drawGuiRectBatchedColor(x, y - 1.0f, 0.0f, 0.203125f, 40.0f, 6.0f, 0.625f, 0.296875f, color[0], color[1], color[2], 1.0f);
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)0.4, (double)0.4, (double)0.4);
        GL11.glTranslated((double)(-x), (double)(-y), (double)0.0);
        if (this.isTyping) {
            String s = this.builder.toString();
            font.func_175065_a(s + (Minecraft.func_71410_x().field_71441_e.func_82737_E() % 20L > 10L ? "_" : ""), x + (float)(this.isInput ? 16 : -font.func_78256_a(this.name) - 1), y + 1.0f, -5263441, false);
        } else {
            int hex = this.isInput ? -5263441 : -13684945;
            font.func_175065_a(this.name, x + (float)(this.isInput ? 16 : -font.func_78256_a(this.name) - 1), y + 1.0f, hex, false);
            if (this.isInput && this.connection == null) {
                String s = this.defaultValue.toString();
                if (s.length() > 5) {
                    s = s.substring(0, 5);
                }
                font.func_175065_a(s, x + 94.0f - (float)font.func_78256_a(s), y + 1.0f, -5263441, false);
            }
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawLine(float mouseX, float mouseY) {
        if (this.drawsLine) {
            BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
            buf.func_181662_b((double)(this.offsetX + (float)(this.isInput ? 0 : 40)), (double)(this.offsetY + 10.0f), 0.0).func_181675_d();
            if (this.connectionIndex == -1 || !this.isInput) {
                buf.func_181662_b((double)mouseX, (double)mouseY, 0.0).func_181675_d();
            } else {
                NodeConnection pair = (this.isInput ? this.connection.outputs : this.connection.inputs).get(this.connectionIndex);
                buf.func_181662_b((double)(pair.offsetX + (float)(pair.isInput ? 0 : 40)), (double)(pair.offsetY + 10.0f), 0.0).func_181675_d();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getPortBox() {
        float oX = this.offsetX;
        if (!this.isInput) {
            oX += 40.0f;
        }
        return new float[]{-2.0f + oX, -2.0f + this.offsetY + 10.0f, 2.0f + oX, 2.0f + this.offsetY + 10.0f};
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getValueBox() {
        if (this.enumSelector != null) {
            return this.enumSelector.getBox();
        }
        return new float[]{3.0f + this.offsetX, -3.0f + this.offsetY + 10.0f, 37.0f + this.offsetX, 3.0f + this.offsetY + 10.0f};
    }

    public DataValue evaluate() {
        if (this.connection != null && this.connectionIndex != -1) {
            return this.connection.evaluate(this.connectionIndex);
        }
        return this.defaultValue;
    }

    @SideOnly(value=Side.CLIENT)
    public void startTyping() {
        this.isTyping = true;
        this.builder = new StringBuilder();
        this.builder.append(this.defaultValue.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public void stopTyping() {
        DataValueString val = new DataValueString(this.builder.toString());
        this.builder = null;
        this.isTyping = false;
        switch (this.type) {
            case GENERIC: 
            case STRING: {
                this.defaultValue = val;
                break;
            }
            case ENUM: {
                Enum[] possibleVals;
                DataValueEnum def = (DataValueEnum)this.defaultValue;
                for (Enum e : possibleVals = def.getPossibleValues()) {
                    if (!e.name().equalsIgnoreCase(((DataValue)val).toString())) continue;
                    this.defaultValue = new DataValueEnum(e);
                    break;
                }
                int idx = Math.abs((int)((DataValue)val).getNumber()) % possibleVals.length;
                this.defaultValue = new DataValueEnum(possibleVals[idx]);
                break;
            }
            case NUMBER: {
                this.defaultValue = new DataValueFloat(((DataValue)val).getNumber());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void keyTyped(char c, int key) {
        if (key == 14) {
            if (this.builder.length() > 0) {
                this.builder.deleteCharAt(this.builder.length() - 1);
            }
        } else if (key == 28) {
            this.stopTyping();
        } else {
            this.builder.append(c);
        }
    }
}

