/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.DataValueEnum;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagString;

public abstract class DataValue {
    public abstract float getNumber();

    public abstract boolean getBoolean();

    public abstract String toString();

    public abstract DataType getType();

    public abstract <E extends Enum<E>> E getEnum(Class<E> var1);

    public abstract NBTBase writeToNBT();

    public abstract void readFromNBT(NBTBase var1);

    public static DataValue newFromNBT(NBTBase base) {
        DataValue val = null;
        try {
            if (base instanceof NBTTagCompound) {
                val = new DataValueEnum(null);
                val.readFromNBT(base);
            } else if (base instanceof NBTTagFloat) {
                val = new DataValueFloat(0.0f);
                val.readFromNBT(base);
            } else if (base instanceof NBTTagString) {
                val = new DataValueString("");
                val.readFromNBT(base);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
        return val;
    }

    public static enum DataType {
        GENERIC(new float[]{0.5f, 0.5f, 0.5f}),
        NUMBER(new float[]{0.4f, 0.6f, 0.0f}),
        STRING(new float[]{0.0f, 1.0f, 1.0f}),
        ENUM(new float[]{0.29f, 0.0f, 0.5f});

        private float[] color;

        private DataType(float[] color) {
            this.color = color;
        }

        public float[] getColor() {
            return this.color;
        }
    }
}

