/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlEvent;
import com.hbm.inventory.control_panel.ControlRegistry;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.IControllable;
import com.hbm.packet.ControlPanelUpdatePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class ControlPanel {
    public IControllable parent;
    public List<Control> controls = new ArrayList<Control>();
    public List<ControlPanelUpdatePacket.VarUpdate> changedVars = new ArrayList<ControlPanelUpdatePacket.VarUpdate>();
    public Map<String, DataValue> globalVars = new LinkedHashMap<String, DataValue>();
    public Map<String, DataValue> globalVarsPrev = new LinkedHashMap<String, DataValue>();
    @SideOnly(value=Side.CLIENT)
    public Matrix4f transform;
    @SideOnly(value=Side.CLIENT)
    public Matrix4f inv_transform;
    public float height;
    public float angle;
    public float a_off;
    public float b_off;
    public float c_off;
    public float d_off;

    public ControlPanel(IControllable parent, float height, float angle, float a_off, float b_off, float c_off, float d_off) {
        this.parent = parent;
        this.height = height;
        this.angle = angle;
        this.a_off = a_off;
        this.b_off = b_off;
        this.c_off = c_off;
        this.d_off = d_off;
    }

    @SideOnly(value=Side.CLIENT)
    public ControlPanel setTransform(Matrix4f transform) {
        this.transform = transform;
        this.inv_transform = new Matrix4f();
        Matrix4f.invert((Matrix4f)transform, (Matrix4f)this.inv_transform);
        return this;
    }

    public void render() {
        for (Control c : this.controls) {
            float width = c.getSize()[0];
            float length = c.getSize()[1];
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(width > 1.0f ? Math.abs(1.0f - width) / 2.0f : (width - 1.0f) / 2.0f), (float)0.0f, (float)(length > 1.0f ? Math.abs(1.0f - length) / 2.0f : (length - 1.0f) / 2.0f));
            c.render();
            GlStateManager.func_179121_F();
        }
    }

    public void update() {
        if (!this.parent.getControlWorld().field_72995_K) {
            this.changedVars.clear();
            this.crossCheckVars(-1, this.globalVars, this.globalVarsPrev);
            for (int i = 0; i < this.controls.size(); ++i) {
                Control c = this.controls.get(i);
                this.crossCheckVars(i, c.vars, c.varsPrev);
            }
        }
    }

    public void crossCheckVars(int idx, Map<String, DataValue> vars, Map<String, DataValue> varsPrev) {
        for (String s : vars.keySet()) {
            if (varsPrev.containsKey(s)) continue;
            this.changedVars.add(new ControlPanelUpdatePacket.VarUpdate(idx, s, vars.get(s)));
        }
        for (String s : varsPrev.keySet()) {
            if (!vars.containsKey(s)) {
                this.changedVars.add(new ControlPanelUpdatePacket.VarUpdate(idx, s, null));
                continue;
            }
            if (varsPrev.get(s).equals(vars.get(s))) continue;
            this.changedVars.add(new ControlPanelUpdatePacket.VarUpdate(idx, s, vars.get(s)));
        }
        varsPrev.clear();
        varsPrev.putAll(vars);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound globalVars = new NBTTagCompound();
        for (Map.Entry<String, DataValue> e : this.globalVars.entrySet()) {
            globalVars.func_74782_a(e.getKey(), e.getValue().writeToNBT());
        }
        NBTTagCompound controls = new NBTTagCompound();
        for (int i = 0; i < this.controls.size(); ++i) {
            controls.func_74782_a("control" + i, (NBTBase)this.controls.get(i).writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("globalvars", (NBTBase)globalVars);
        nbt.func_74782_a("controls", (NBTBase)controls);
        nbt.func_74776_a("height", this.height);
        nbt.func_74776_a("angle", this.angle);
        nbt.func_74776_a("a_offset", this.a_off);
        nbt.func_74776_a("b_offset", this.b_off);
        nbt.func_74776_a("c_offset", this.c_off);
        nbt.func_74776_a("d_offset", this.d_off);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.globalVars.clear();
        this.controls.clear();
        NBTTagCompound globalVars = tag.func_74775_l("globalvars");
        for (String k : globalVars.func_150296_c()) {
            NBTBase base = globalVars.func_74781_a(k);
            DataValue val = DataValue.newFromNBT(base);
            if (val == null) continue;
            this.globalVars.put(k, val);
        }
        NBTTagCompound controls = tag.func_74775_l("controls");
        for (int i = 0; i < controls.func_150296_c().size(); ++i) {
            NBTTagCompound ct = controls.func_74775_l("control" + i);
            Control c = ControlRegistry.getNew(ct.func_74779_i("name"), this);
            HashMap<String, DataValue> configs = new HashMap<String, DataValue>();
            NBTTagCompound config_tag = ct.func_74775_l("configs");
            for (String s : config_tag.func_150296_c()) {
                configs.put(s, DataValue.newFromNBT(config_tag.func_74781_a(s)));
            }
            c.applyConfigs(configs);
            this.controls.add(c);
            c.readFromNBT(ct);
        }
        this.height = tag.func_74760_g("height");
        this.angle = tag.func_74760_g("angle");
        this.a_off = tag.func_74760_g("a_offset");
        this.b_off = tag.func_74760_g("b_offset");
        this.c_off = tag.func_74760_g("c_offset");
        this.d_off = tag.func_74760_g("d_offset");
    }

    public void receiveEvent(BlockPos from, ControlEvent evt) {
        for (Control c : this.controls) {
            int idx = c.connectedSet.indexOf(from);
            if (idx == -1 && !this.parent.getControlPos().equals((Object)from)) continue;
            evt.setVar("from index", idx);
            c.receiveEvent(evt);
        }
    }

    public DataValue getVar(String name) {
        return this.globalVars.getOrDefault(name, new DataValueFloat(0.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public Control getSelectedControl(Vec3d pos, Vec3d direction) {
        BlockPos blockPos = this.parent.getControlPos();
        Vector4f localPos = new Vector4f((float)pos.field_72450_a - (float)blockPos.func_177958_n(), (float)pos.field_72448_b - (float)blockPos.func_177956_o(), (float)pos.field_72449_c - (float)blockPos.func_177952_p(), 1.0f);
        Vector4f localDir = new Vector4f((float)direction.field_72450_a, (float)direction.field_72448_b, (float)direction.field_72449_c, 0.0f);
        Matrix4f.transform((Matrix4f)this.inv_transform, (Vector4f)localPos, (Vector4f)localPos);
        Matrix4f.transform((Matrix4f)this.inv_transform, (Vector4f)localDir, (Vector4f)localDir);
        Vec3d start = new Vec3d((double)localPos.x, (double)localPos.y, (double)localPos.z);
        localDir.scale(3.0f);
        Vec3d end = new Vec3d((double)(localPos.x + localDir.x), (double)(localPos.y + localDir.y), (double)(localPos.z + localDir.z));
        double dist = Double.MAX_VALUE;
        Control ctrl = null;
        for (Control c : this.controls) {
            double newDist;
            RayTraceResult r;
            if (c.getBoundingBox() == null || (r = c.getBoundingBox().func_72327_a(start, end)) == null || r.field_72313_a == RayTraceResult.Type.MISS || !((newDist = r.field_72307_f.func_72436_e(start)) < dist)) continue;
            dist = newDist;
            ctrl = c;
        }
        return ctrl;
    }

    public static float getSlopeHeightFromZ(float z, float height, float angle) {
        double halfH = 0.5 * Math.tan(angle);
        return (float)((double)height - halfH + Math.tan(angle) * (double)z);
    }
}

