/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesCommon {
    public static ItemStack[] copyStackArray(ItemStack[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            clone[i] = array[i].func_77946_l();
        }
        return clone;
    }

    public static ItemStack[] objectToStackArray(Object[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof ItemStack)) continue;
            clone[i] = (ItemStack)array[i];
        }
        return clone;
    }

    public static class OreDictStack
    extends AStack {
        public String name;

        public OreDictStack(String name) {
            this.name = name;
            this.stacksize = 1;
        }

        public OreDictStack(String name, int stacksize) {
            this(name);
            this.stacksize = stacksize;
        }

        public List<ItemStack> toStacks() {
            return OreDictionary.getOres((String)this.name);
        }

        @Override
        public ItemStack getStack() {
            ItemStack stack = this.toStacks().get(0);
            return new ItemStack(stack.func_77973_b(), this.stacksize, stack.func_77960_j());
        }

        @Override
        public List<ItemStack> getStackList() {
            List<ItemStack> list = Library.copyItemStackList(this.toStacks());
            for (ItemStack stack : list) {
                stack.func_190920_e(this.stacksize);
            }
            return list;
        }

        public int hashCode() {
            return ("" + this.name + this.stacksize).hashCode();
        }

        @Override
        public AStack singulize() {
            this.stacksize = 1;
            return this;
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof OreDictStack) {
                OreDictStack comp = (OreDictStack)stack;
                return this.name.compareTo(comp.name);
            }
            if (stack instanceof ComparableStack) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack == null || stack.func_190926_b()) {
                return false;
            }
            if (!ignoreSize && stack.func_190916_E() < this.stacksize) {
                return false;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            if (ids == null || ids.length == 0) {
                return false;
            }
            for (int i = 0; i < ids.length; ++i) {
                if (!this.name.equals(OreDictionary.getOreName((int)ids[i]))) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OreDictStack)) {
                return false;
            }
            OreDictStack other = (OreDictStack)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.stacksize == other.stacksize;
        }

        @Override
        public AStack copy() {
            return new OreDictStack(this.name, this.stacksize);
        }

        @Override
        public String toString() {
            return "OreDictStack: name, " + this.name + ", stacksize, " + this.stacksize;
        }
    }

    public static class NbtComparableStack
    extends ComparableStack {
        ItemStack stack;

        public NbtComparableStack(ItemStack stack) {
            super(stack);
            this.stack = stack.func_77946_l();
        }

        @Override
        public ComparableStack makeSingular() {
            ItemStack st = this.stack.func_77946_l();
            st.func_190920_e(1);
            return new NbtComparableStack(st);
        }

        @Override
        public AStack singulize() {
            this.stack.func_190920_e(1);
            this.stacksize = 1;
            return this;
        }

        @Override
        public ItemStack toStack() {
            return this.stack.func_77946_l();
        }

        @Override
        public ItemStack getStack() {
            return this.toStack();
        }

        @Override
        public int hashCode() {
            if (!this.stack.func_77942_o()) {
                return super.hashCode();
            }
            return super.hashCode() * 31 + this.stack.func_77978_p().hashCode();
        }

        @Override
        public AStack copy() {
            return new NbtComparableStack(this.stack);
        }

        @Override
        public boolean equals(Object obj) {
            if (!this.stack.func_77942_o() || !(obj instanceof NbtComparableStack)) {
                return super.equals(obj);
            }
            return super.equals(obj) && Library.tagContainsOther(this.stack.func_77978_p(), ((NbtComparableStack)obj).stack.func_77978_p());
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            return super.matchesRecipe(stack, ignoreSize) && Library.tagContainsOther(this.stack.func_77978_p(), stack.func_77978_p());
        }

        @Override
        public String toString() {
            return "NbtComparableStack: " + this.stack.toString();
        }
    }

    public static class ComparableStack
    extends AStack {
        public Item item;
        public int meta;

        public ComparableStack(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.stacksize = stack.func_190916_E();
            this.meta = stack.func_77952_i();
        }

        public ComparableStack makeSingular() {
            this.stacksize = 1;
            return this;
        }

        @Override
        public AStack singulize() {
            this.stacksize = 1;
            return this;
        }

        public ComparableStack(Item item) {
            this.item = item;
            this.stacksize = 1;
            this.meta = 0;
        }

        public ComparableStack(Block item) {
            this.item = Item.func_150898_a((Block)item);
            this.stacksize = 1;
            this.meta = 0;
        }

        public ComparableStack(Item item, int stacksize) {
            this(item);
            this.stacksize = stacksize;
        }

        public ComparableStack(Item item, int stacksize, int meta) {
            this(item, stacksize);
            this.meta = meta;
        }

        public ComparableStack(Block item, int stacksize) {
            this.item = Item.func_150898_a((Block)item);
            this.stacksize = stacksize;
            this.meta = 0;
        }

        public ComparableStack(Block item, int stacksize, int meta) {
            this.item = Item.func_150898_a((Block)item);
            this.stacksize = stacksize;
            this.meta = meta;
        }

        public ItemStack toStack() {
            return new ItemStack(this.item, this.stacksize, this.meta);
        }

        @Override
        public ItemStack getStack() {
            return this.toStack();
        }

        @Override
        public List<ItemStack> getStackList() {
            return Arrays.asList(this.getStack());
        }

        public String[] getDictKeys() {
            int[] ids = OreDictionary.getOreIDs((ItemStack)this.toStack());
            if (ids == null || ids.length == 0) {
                return new String[0];
            }
            String[] entries = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                entries[i] = OreDictionary.getOreName((int)ids[i]);
            }
            return entries;
        }

        public int hashCode() {
            ResourceLocation name;
            int prime = 31;
            int result = 1;
            if (this.item == null) {
                MainRegistry.logger.error("ComparableStack has a null item! This is a serious issue!");
                Thread.dumpStack();
                this.item = Items.field_151055_y;
            }
            if ((name = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item)) == null) {
                MainRegistry.logger.error("ComparableStack holds an item that does not seem to be registered. How does that even happen?");
                Thread.dumpStack();
                this.item = Items.field_151055_y;
            }
            if (name != null) {
                result = 31 * result + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.item)).hashCode();
            }
            result = 31 * result + this.meta;
            result = 31 * result + this.stacksize;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ComparableStack)) {
                return false;
            }
            ComparableStack other = (ComparableStack)obj;
            if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
                return false;
            }
            if (this.meta != Short.MAX_VALUE && other.meta != Short.MAX_VALUE && this.meta != other.meta) {
                return false;
            }
            return this.stacksize == other.stacksize;
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof ComparableStack) {
                int thatID;
                ComparableStack comp = (ComparableStack)stack;
                int thisID = Item.func_150891_b((Item)this.item);
                if (thisID > (thatID = Item.func_150891_b((Item)comp.item))) {
                    return 1;
                }
                if (thatID > thisID) {
                    return -1;
                }
                if (this.meta > comp.meta) {
                    return 1;
                }
                if (comp.meta > this.meta) {
                    return -1;
                }
                return 0;
            }
            if (stack instanceof OreDictStack) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack == null) {
                return false;
            }
            if (stack.func_77973_b() != this.item) {
                return false;
            }
            if (this.meta != Short.MAX_VALUE && stack.func_77952_i() != this.meta) {
                return false;
            }
            return ignoreSize || stack.func_190916_E() >= this.stacksize;
        }

        @Override
        public AStack copy() {
            return new ComparableStack(this.item, this.stacksize, this.meta);
        }

        @Override
        public String toString() {
            return "ComparableStack: { " + this.stacksize + " x " + this.item.getRegistryName() + "@" + this.meta + " }";
        }
    }

    public static abstract class AStack
    implements Comparable<AStack> {
        protected int stacksize;

        public boolean isApplicable(ItemStack stack) {
            return this.isApplicable(new NbtComparableStack(stack));
        }

        public AStack singulize() {
            this.stacksize = 1;
            return this;
        }

        public int count() {
            return this.stacksize;
        }

        public void setCount(int c) {
            this.stacksize = c;
        }

        public boolean isApplicable(ComparableStack comp) {
            if (this instanceof ComparableStack) {
                return ((ComparableStack)this).equals(comp);
            }
            if (this instanceof OreDictStack) {
                NonNullList ores = OreDictionary.getOres((String)((OreDictStack)this).name);
                for (ItemStack stack : ores) {
                    if (stack.func_77973_b() != comp.item || stack.func_77952_i() != comp.meta) continue;
                    return true;
                }
            }
            return false;
        }

        public abstract boolean matchesRecipe(ItemStack var1, boolean var2);

        public abstract AStack copy();

        public abstract ItemStack getStack();

        public abstract List<ItemStack> getStackList();

        public String toString() {
            return "AStack: size, " + this.stacksize;
        }
    }
}

