/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.AnvilSmithingCyanideRecipe;
import com.hbm.inventory.AnvilSmithingHotRecipe;
import com.hbm.inventory.AnvilSmithingRecipe;
import com.hbm.inventory.AnvilSmithingRenameRecipe;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import crafttweaker.CraftTweakerAPI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AnvilRecipes {
    private static List<AnvilSmithingRecipe> smithingRecipes = new ArrayList<AnvilSmithingRecipe>();
    private static List<AnvilConstructionRecipe> constructionRecipes = new ArrayList<AnvilConstructionRecipe>();

    public static void register() {
        AnvilRecipes.registerSmithing();
        AnvilRecipes.registerConstruction();
    }

    public static void registerSmithing() {
        Block[] anvils;
        for (Block anvil : anvils = new Block[]{ModBlocks.anvil_iron, ModBlocks.anvil_lead}) {
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_bismuth, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_bismuth, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_dnt, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_osmiridium, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.OSMIRIDIUM.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_ferrouranium, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.FERRO.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_meteorite, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_schrabidate, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.SBD.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_starmetal, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_steel, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 10)));
        }
        for (int i = 0; i < 9; ++i) {
            smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.ingot_steel_dusted, 1, i + 1), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, i), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, i)));
        }
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.ingot_chainsteel, 1), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, 9), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, 9)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.ingot_meteorite_forged, 1), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.blade_meteorite, 1), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.meteorite_sword_reforged, 1), new RecipesCommon.ComparableStack(ModItems.meteorite_sword_seared), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged)));
        smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModItems.gun_ar15, 1), new RecipesCommon.ComparableStack(ModItems.gun_thompson), new RecipesCommon.ComparableStack(ModItems.pipe_lead)));
        smithingRecipes.add(new AnvilSmithingRecipe(1916169, new ItemStack(ModItems.wings_murk, 1), new RecipesCommon.ComparableStack(ModItems.wings_limp), new RecipesCommon.ComparableStack(ModItems.particle_tachyon)));
        smithingRecipes.add(new AnvilSmithingCyanideRecipe());
        smithingRecipes.add(new AnvilSmithingRenameRecipe());
    }

    public static void registerConstruction() {
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_iron))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_gold))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.TI.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_titanium))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_aluminium))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_steel))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.PB.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_lead))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_copper))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_advanced_alloy))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_schrabidium))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_combine_steel))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_saturnite))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_aluminium, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_copper, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.W.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_tungsten, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_red_copper, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_advanced_alloy, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_gold, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_schrabidium, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.ingot()), new AnvilOutput(new ItemStack(ModItems.wire_magnetized_tungsten, 8))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.COAL.dust()), new AnvilOutput(new ItemStack(Items.field_151044_h))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.NETHERQUARTZ.dust()), new AnvilOutput(new ItemStack(Items.field_151128_bU))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.LAPIS.dust()), new AnvilOutput(new ItemStack(Items.field_151100_aR, 1, 4))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust()), new AnvilOutput(new ItemStack(Items.field_151045_i))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.EMERALD.dust()), new AnvilOutput(new ItemStack(Items.field_151166_bC))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.RAREEARTH.gem()), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.fragment_boron)), new AnvilOutput(new ItemStack(ModItems.fragment_boron), 0.5f), new AnvilOutput(new ItemStack(ModItems.fragment_cobalt)), new AnvilOutput(new ItemStack(ModItems.fragment_cobalt), 0.5f), new AnvilOutput(new ItemStack(ModItems.fragment_neodymium), 0.5f), new AnvilOutput(new ItemStack(ModItems.fragment_niobium), 0.5f), new AnvilOutput(new ItemStack(ModItems.fragment_cerium), 0.4f), new AnvilOutput(new ItemStack(ModItems.fragment_lanthanium), 0.3f), new AnvilOutput(new ItemStack(ModItems.fragment_actinium), 0.3f)}).setTier(2));
        AnvilRecipes.registerConstructionRecipes();
        AnvilRecipes.registerConstructionAmmo();
        AnvilRecipes.registerConstructionUpgrades();
        AnvilRecipes.registerConstructionRecycling();
    }

    public static void registerConstructionRecipes() {
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_aluminium))).setTier(3).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.BE.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_beryllium))).setTier(3).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.PB.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_lead))).setTier(3).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_red_copper))).setTier(3).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_steel))).setTier(3).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_titanium))).setTier(3).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_tungsten))).setTier(3).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_aluminium, 1), new AnvilOutput(new ItemStack(ModItems.ingot_aluminium))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_beryllium, 1), new AnvilOutput(new ItemStack(ModItems.ingot_beryllium))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_lead, 1), new AnvilOutput(new ItemStack(ModItems.ingot_lead))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_red_copper, 1), new AnvilOutput(new ItemStack(ModItems.ingot_red_copper))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_steel, 1), new AnvilOutput(new ItemStack(ModItems.ingot_steel))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_titanium, 1), new AnvilOutput(new ItemStack(ModItems.ingot_titanium))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_tungsten, 1), new AnvilOutput(new ItemStack(ModItems.ingot_tungsten))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 4), new RecipesCommon.ComparableStack(ModBlocks.depth_brick)}, new AnvilOutput(new ItemStack(ModBlocks.depth_dnt))).setTier(1916169));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 4), new AnvilOutput(new ItemStack(ModItems.board_copper))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.coil_copper, 2), new AnvilOutput(new ItemStack(ModItems.coil_copper_torus))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 2), new AnvilOutput(new ItemStack(ModItems.coil_advanced_torus))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.coil_gold, 2), new AnvilOutput(new ItemStack(ModItems.coil_gold_torus))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 2), new RecipesCommon.ComparableStack(ModItems.coil_copper), new RecipesCommon.ComparableStack(ModItems.coil_copper_torus)}, new AnvilOutput(new ItemStack(ModItems.motor, 2))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.motor), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.coil_gold_torus)}, new AnvilOutput(new ItemStack(ModItems.motor_desh, 1))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 4), new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 4), new RecipesCommon.ComparableStack(ModItems.board_copper, 2)}, new AnvilOutput(new ItemStack(ModBlocks.machine_difurnace_off))).setTier(1));
        int ukModifier = 1;
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("blockGlassColorless", 4 * ukModifier), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8 * ukModifier), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8 * ukModifier), new RecipesCommon.ComparableStack(ModItems.motor, 2 * ukModifier), new RecipesCommon.ComparableStack(ModItems.circuit_aluminium, 1 * ukModifier)}, new AnvilOutput(new ItemStack(ModBlocks.machine_assembler))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150460_al), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.heater_firebox))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.heater_oven))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.tank_steel, 4), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.heater_oilburner))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 8), new RecipesCommon.ComparableStack(ModItems.circuit_copper, 1)}, new AnvilOutput(new ItemStack(ModBlocks.heater_electric))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 1)}, new AnvilOutput(new ItemStack(ModBlocks.heater_heatex))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.rtg_unit, 5), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.TCALLOY.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.heater_rt))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 16), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.ComparableStack(ModBlocks.steel_grate, 16)}, new AnvilOutput(new ItemStack(ModBlocks.furnace_steel))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 16), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8)}, new AnvilOutput(new ItemStack(ModBlocks.heat_boiler))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.brick_concrete, 64), new RecipesCommon.ComparableStack(Blocks.field_150411_aY, 128), new RecipesCommon.ComparableStack(ModBlocks.machine_condenser, 5)}, new AnvilOutput(new ItemStack(ModBlocks.machine_tower_small))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.concrete_smooth, 128), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 32), new RecipesCommon.ComparableStack(ModBlocks.machine_condenser, 25), new RecipesCommon.ComparableStack(ModItems.pipes_steel, 2)}, new AnvilOutput(new ItemStack(ModBlocks.machine_tower_large))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 8), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4)}, new AnvilOutput(new ItemStack(ModBlocks.red_pylon_large))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 6), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 2), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModItems.coil_copper, 2), new RecipesCommon.ComparableStack(ModItems.coil_copper_torus, 2)}, new AnvilOutput(new ItemStack(ModBlocks.substation))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.steel_wall, 2), new RecipesCommon.OreDictStack(OreDictManager.REDSTONE.dust(), 4), new RecipesCommon.ComparableStack(Blocks.field_150442_at, 2), new RecipesCommon.ComparableStack(ModItems.wire_advanced_alloy, 3)}, new AnvilOutput(new ItemStack(ModBlocks.bm_power_box))).setTier(5));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Items.field_151103_aS, 16), new RecipesCommon.ComparableStack(Items.field_151116_aA, 4), new RecipesCommon.ComparableStack(Items.field_151008_G, 24)}, new AnvilOutput(new ItemStack(ModItems.wings_limp))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 2), new RecipesCommon.ComparableStack(ModItems.hull_small_steel, 4), new RecipesCommon.ComparableStack(ModItems.board_copper, 1), new RecipesCommon.ComparableStack(ModItems.turbine_titanium, 1), new RecipesCommon.ComparableStack(ModItems.circuit_aluminium, 1)}, new AnvilOutput(new ItemStack(ModBlocks.machine_deuterium_extractor))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.deuterium_filter, 2), new RecipesCommon.ComparableStack(ModItems.hull_big_steel, 5), new RecipesCommon.ComparableStack(ModBlocks.concrete_smooth, 8), new RecipesCommon.ComparableStack(ModBlocks.concrete_asbestos, 4), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 16), new RecipesCommon.ComparableStack(ModBlocks.deco_pipe_quad, 12), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 32)}, new AnvilOutput(new ItemStack(ModBlocks.machine_deuterium_tower))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 1)}, new AnvilOutput(new ItemStack(ModItems.plate_desh, 4))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.EUPH.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.AT.ingot(), 3), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOID.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.VOLCANIC.gem(), 1), new RecipesCommon.ComparableStack(ModItems.ingot_osmiridium)}, new AnvilOutput(new ItemStack(ModItems.plate_euphemium, 4))).setTier(6));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.powder_spark_mix, 2), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 1)}, new AnvilOutput(new ItemStack(ModItems.plate_dineutronium, 4))).setTier(7));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("plateTitanium", 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.bolt_tungsten, 2)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_titanium))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 2), new RecipesCommon.ComparableStack(ModItems.plate_armor_titanium, 1)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_ajr))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_paa, 2), new RecipesCommon.ComparableStack(ModItems.plate_armor_ajr, 1), new RecipesCommon.ComparableStack(ModItems.wire_tungsten, 4)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_hev))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 2), new RecipesCommon.ComparableStack(ModItems.plate_armor_hev, 1), new RecipesCommon.ComparableStack(ModItems.wire_magnetized_tungsten, 4)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_lunar))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged, 4), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.billet_yharonite, 1)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_fau))).setTier(6));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_dineutronium, 4), new RecipesCommon.ComparableStack(ModItems.particle_sparkticle, 1), new RecipesCommon.ComparableStack(ModItems.plate_armor_fau, 6)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_dnt))).setTier(7));
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.plate_mixed, 4), 3);
    }

    public static void registerConstructionAmmo() {
        Object[][] recs;
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.plate()), new AnvilOutput(new ItemStack(ModItems.casing_357))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.plate()), new AnvilOutput(new ItemStack(ModItems.casing_44))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.plate()), new AnvilOutput(new ItemStack(ModItems.casing_9))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.plate()), new AnvilOutput(new ItemStack(ModItems.casing_50))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.plate()), new AnvilOutput(new ItemStack(ModItems.casing_buckshot))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate()), new RecipesCommon.ComparableStack(Items.field_151137_ax)}, new AnvilOutput(new ItemStack(ModItems.primer_357))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate()), new RecipesCommon.ComparableStack(Items.field_151137_ax)}, new AnvilOutput(new ItemStack(ModItems.primer_44))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate()), new RecipesCommon.ComparableStack(Items.field_151137_ax)}, new AnvilOutput(new ItemStack(ModItems.primer_9))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate()), new RecipesCommon.ComparableStack(Items.field_151137_ax)}, new AnvilOutput(new ItemStack(ModItems.primer_50))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate()), new RecipesCommon.ComparableStack(Items.field_151137_ax)}, new AnvilOutput(new ItemStack(ModItems.primer_buckshot))).setTier(1));
        for (Object[] objs : recs = new Object[][]{{ModItems.ammo_12gauge, ModItems.powder_fire, ModItems.ammo_12gauge_incendiary, 20, 2}, {ModItems.ammo_12gauge, Item.func_150898_a((Block)ModBlocks.gravel_obsidian), ModItems.ammo_12gauge_shrapnel, 20, 2}, {ModItems.ammo_12gauge, ModItems.ingot_u238, ModItems.ammo_12gauge_du, 20, 3}, {ModItems.ammo_12gauge, ModItems.coin_maskman, ModItems.ammo_12gauge_sleek, 100, 4}, {ModItems.ammo_20gauge, ModItems.powder_fire, ModItems.ammo_20gauge_incendiary, 20, 2}, {ModItems.ammo_20gauge, Item.func_150898_a((Block)ModBlocks.gravel_obsidian), ModItems.ammo_20gauge_shrapnel, 20, 2}, {ModItems.ammo_20gauge, ModItems.powder_poison, ModItems.ammo_20gauge_caustic, 20, 2}, {ModItems.ammo_20gauge, OreDictManager.DIAMOND.dust(), ModItems.ammo_20gauge_shock, 20, 2}, {ModItems.ammo_20gauge, Item.func_150898_a((Block)Blocks.field_150425_aM), ModItems.ammo_20gauge_wither, 10, 3}, {ModItems.ammo_20gauge, ModItems.coin_maskman, ModItems.ammo_20gauge_sleek, 100, 4}, {ModItems.ammo_4gauge_flechette, ModItems.ingot_phosphorus, ModItems.ammo_4gauge_flechette_phosphorus, 20, 2}, {ModItems.ammo_4gauge_explosive, ModItems.egg_balefire_shard, ModItems.ammo_4gauge_balefire, 10, 4}, {ModItems.ammo_4gauge_explosive, ModItems.ammo_rocket, ModItems.ammo_4gauge_kampf, 4, 2}, {ModItems.ammo_4gauge_kampf, ModItems.pellet_canister, ModItems.ammo_4gauge_canister, 10, 3}, {ModItems.ammo_4gauge, ModItems.pellet_claws, ModItems.ammo_4gauge_claw, 4, 5}, {ModItems.ammo_4gauge, ModItems.toothpicks, ModItems.ammo_4gauge_vampire, 4, 5}, {ModItems.ammo_4gauge, ModItems.pellet_charged, ModItems.ammo_4gauge_void, 1, 5}, {ModItems.ammo_4gauge, ModItems.coin_maskman, ModItems.ammo_4gauge_sleek, 100, 4}, {ModItems.ammo_44, ModItems.ingot_dura_steel, ModItems.ammo_44_ap, 20, 2}, {ModItems.ammo_44, ModItems.ingot_u238, ModItems.ammo_44_du, 20, 2}, {ModItems.ammo_44, ModItems.ingot_phosphorus, ModItems.ammo_44_phosphorus, 20, 2}, {ModItems.ammo_44_du, ModItems.ingot_starmetal, ModItems.ammo_44_star, 10, 3}, {ModItems.ammo_44, ModItems.pellet_chlorophyte, ModItems.ammo_44_chlorophyte, 10, 3}, {ModItems.ammo_5mm, ModItems.ingot_semtex, ModItems.ammo_5mm_explosive, 20, 2}, {ModItems.ammo_5mm, ModItems.ingot_u238, ModItems.ammo_5mm_du, 20, 2}, {ModItems.ammo_5mm, ModItems.ingot_starmetal, ModItems.ammo_5mm_star, 10, 3}, {ModItems.ammo_5mm, ModItems.pellet_chlorophyte, ModItems.ammo_5mm_chlorophyte, 10, 3}, {ModItems.ammo_9mm, ModItems.ingot_dura_steel, ModItems.ammo_9mm_ap, 20, 2}, {ModItems.ammo_9mm, ModItems.ingot_u238, ModItems.ammo_9mm_du, 20, 2}, {ModItems.ammo_9mm, ModItems.pellet_chlorophyte, ModItems.ammo_9mm_chlorophyte, 10, 3}, {ModItems.ammo_22lr, ModItems.ingot_dura_steel, ModItems.ammo_22lr_ap, 20, 2}, {ModItems.ammo_22lr, ModItems.pellet_chlorophyte, ModItems.ammo_22lr_chlorophyte, 10, 3}, {ModItems.ammo_50bmg, ModItems.powder_fire, ModItems.ammo_50bmg_incendiary, 20, 2}, {ModItems.ammo_50bmg, ModItems.ingot_phosphorus, ModItems.ammo_50bmg_phosphorus, 20, 2}, {ModItems.ammo_50bmg, ModItems.ingot_semtex, ModItems.ammo_50bmg_explosive, 20, 2}, {ModItems.ammo_50bmg, ModItems.ingot_dura_steel, ModItems.ammo_50bmg_ap, 20, 2}, {ModItems.ammo_50bmg, ModItems.ingot_u238, ModItems.ammo_50bmg_du, 20, 2}, {ModItems.ammo_50bmg_du, ModItems.ingot_starmetal, ModItems.ammo_50bmg_star, 10, 3}, {ModItems.ammo_50bmg, ModItems.pellet_chlorophyte, ModItems.ammo_50bmg_chlorophyte, 10, 3}, {ModItems.ammo_50bmg, ModItems.coin_maskman, ModItems.ammo_50bmg_sleek, 100, 4}, {ModItems.ammo_50bmg, ModItems.pellet_flechette, ModItems.ammo_50bmg_flechette, 20, 2}, {ModItems.ammo_50bmg_flechette, ModItems.nugget_am_mix, ModItems.ammo_50bmg_flechette_am, 10, 3}, {ModItems.ammo_50bmg_flechette, ModItems.powder_polonium, ModItems.ammo_50bmg_flechette_po, 20, 3}, {ModItems.ammo_50ae, ModItems.ingot_dura_steel, ModItems.ammo_50ae_ap, 20, 2}, {ModItems.ammo_50ae, ModItems.ingot_u238, ModItems.ammo_50ae_du, 20, 2}, {ModItems.ammo_50ae_du, ModItems.ingot_starmetal, ModItems.ammo_50ae_star, 10, 3}, {ModItems.ammo_50ae, ModItems.pellet_chlorophyte, ModItems.ammo_50ae_chlorophyte, 10, 3}, {ModItems.ammo_556, ModItems.ingot_phosphorus, ModItems.ammo_556_phosphorus, 20, 2}, {ModItems.ammo_556, ModItems.ingot_dura_steel, ModItems.ammo_556_ap, 20, 2}, {ModItems.ammo_556, ModItems.ingot_u238, ModItems.ammo_556_du, 20, 2}, {ModItems.ammo_556_du, ModItems.ingot_starmetal, ModItems.ammo_556_star, 10, 3}, {ModItems.ammo_556, ModItems.pellet_chlorophyte, ModItems.ammo_556_chlorophyte, 10, 3}, {ModItems.ammo_556, ModItems.coin_maskman, ModItems.ammo_556_sleek, 100, 4}, {ModItems.ammo_556, Items.field_151137_ax, ModItems.ammo_556_tracer, 20, 2}, {ModItems.ammo_556, ModItems.pellet_flechette, ModItems.ammo_556_flechette, 20, 2}, {ModItems.ammo_556_flechette, ModItems.powder_fire, ModItems.ammo_556_flechette_incendiary, 20, 2}, {ModItems.ammo_556_flechette, ModItems.ingot_phosphorus, ModItems.ammo_556_flechette_phosphorus, 20, 2}, {ModItems.ammo_556_flechette, ModItems.ingot_u238, ModItems.ammo_556_flechette_du, 20, 2}, {ModItems.ammo_556_flechette, ModItems.coin_maskman, ModItems.ammo_556_flechette_sleek, 100, 4}, {ModItems.ammo_556_flechette, ModItems.pellet_chlorophyte, ModItems.ammo_556_flechette_chlorophyte, 10, 3}}) {
            if (objs[1] instanceof Item) {
                constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack((Item)objs[0], (int)((Integer)objs[3])), new RecipesCommon.ComparableStack((Item)objs[1], 1)}, new AnvilOutput(new ItemStack((Item)objs[2], ((Integer)objs[3]).intValue()))).setTier((Integer)objs[4]));
                continue;
            }
            if (!(objs[1] instanceof String)) continue;
            constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack((Item)objs[0], (int)((Integer)objs[3])), new RecipesCommon.OreDictStack((String)objs[1], 1)}, new AnvilOutput(new ItemStack((Item)objs[2], ((Integer)objs[3]).intValue()))).setTier((Integer)objs[4]));
        }
    }

    public static void registerConstructionUpgrades() {
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_template), 2);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_speed_1), 2);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_speed_2), 3);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_power_1), 2);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_power_2), 3);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_power_3), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_effect_1), 2);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_effect_2), 3);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_effect_3), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_fortune_1), 2);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_fortune_2), 3);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_fortune_3), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_afterburn_1), 2);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_afterburn_2), 3);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_afterburn_3), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_radius), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_health), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_smelter), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_shredder), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_centrifuge), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_crystallizer), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_nullifier), 4);
        AnvilRecipes.pullFromAssembler(new RecipesCommon.ComparableStack(ModItems.upgrade_screm), 4);
    }

    public static void registerConstructionRecycling() {
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.solar_mirror), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_steel, 1)), new AnvilOutput(new ItemStack(ModItems.plate_aluminium, 1))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.barrel_tcalloy), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_titanium, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 4)), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 1), 0.25f)}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_raw), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 1)), new AnvilOutput(new ItemStack(ModItems.wire_aluminium, 1)), new AnvilOutput(new ItemStack(Items.field_151137_ax, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_aluminium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 1)), new AnvilOutput(new ItemStack(ModItems.wire_aluminium, 1), 0.5f), new AnvilOutput(new ItemStack(Items.field_151137_ax, 1), 0.25f)}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_copper), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.circuit_aluminium, 1)), new AnvilOutput(new ItemStack(ModItems.wire_copper, 2)), new AnvilOutput(new ItemStack(ModItems.wire_copper, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.wire_copper, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.powder_quartz, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.plate_copper, 1), 0.5f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_red_copper), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.circuit_copper, 1)), new AnvilOutput(new ItemStack(ModItems.wire_red_copper, 2)), new AnvilOutput(new ItemStack(ModItems.wire_red_copper, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.wire_red_copper, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.powder_gold, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.plate_polymer, 1), 0.5f)}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_gold), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.circuit_red_copper, 1)), new AnvilOutput(new ItemStack(ModItems.wire_gold, 2)), new AnvilOutput(new ItemStack(ModItems.wire_gold, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.wire_gold, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.powder_lapis, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.ingot_polymer, 1), 0.5f)}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_schrabidium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.circuit_gold, 1)), new AnvilOutput(new ItemStack(ModItems.wire_schrabidium, 2)), new AnvilOutput(new ItemStack(ModItems.wire_schrabidium, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.wire_schrabidium, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.powder_diamond, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.ingot_desh, 1), 0.5f)}).setTier(6));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_tantalium_raw), new AnvilOutput[]{new AnvilOutput(new ItemStack(Items.field_151137_ax, 4)), new AnvilOutput(new ItemStack(ModItems.wire_gold, 2)), new AnvilOutput(new ItemStack(ModItems.plate_copper, 2)), new AnvilOutput(new ItemStack(ModItems.nugget_tantalium, 1))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_tantalium), new AnvilOutput[]{new AnvilOutput(new ItemStack(Items.field_151137_ax, 2)), new AnvilOutput(new ItemStack(ModItems.wire_gold, 1)), new AnvilOutput(new ItemStack(ModItems.wire_gold, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.plate_copper, 1)), new AnvilOutput(new ItemStack(ModItems.nugget_tantalium, 1), 0.75f)}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_bismuth_raw), new AnvilOutput[]{new AnvilOutput(new ItemStack(Items.field_151137_ax, 4)), new AnvilOutput(new ItemStack(ModItems.ingot_polymer, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_asbestos, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_bismuth, 1))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.circuit_bismuth), new AnvilOutput[]{new AnvilOutput(new ItemStack(Items.field_151137_ax, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_polymer, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_polymer, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.ingot_asbestos, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_bismuth, 1), 0.75f)}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_uranium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_uranium, 3)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_plutonium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_plutonium, 3)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_source), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_ra226be, 3)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_boron), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_boron, 2)), new AnvilOutput(new ItemStack(Items.field_151055_y, 2))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_moderator), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_absorber), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_boron, 8))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_reflector), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.neutron_reflector, 8))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_control), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_absorber, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_graphite, 2)), new AnvilOutput(new ItemStack(ModItems.motor, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_control_mod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_control, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4)), new AnvilOutput(new ItemStack(ModItems.nugget_bismuth, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_control_auto), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_control, 1)), new AnvilOutput(new ItemStack(ModItems.circuit_targeting_tier1, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod_reasim), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_zirconium, 4)), new AnvilOutput(new ItemStack(ModItems.hull_small_steel, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod_reasim_mod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_rod_reasim, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4)), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_outgasser), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.steel_grate, 6)), new AnvilOutput(new ItemStack(ModItems.tank_steel, 1)), new AnvilOutput(new ItemStack((Block)Blocks.field_150438_bZ, 1))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_storage), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.crate_steel, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.hull_small_steel, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod_mod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_rod, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4)), new AnvilOutput(new ItemStack(ModItems.nugget_bismuth, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_boiler), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.board_copper, 6)), new AnvilOutput(new ItemStack(ModItems.pipes_steel, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_cooler), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.steel_grate, 4)), new AnvilOutput(new ItemStack(ModItems.plate_polymer, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_heater), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.pipes_steel, 2)), new AnvilOutput(new ItemStack(ModItems.plate_polymer, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.machine_turbine), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.turbine_titanium, 1)), new AnvilOutput(new ItemStack(ModItems.coil_copper, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_steel, 4))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.yellow_barrel), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.tank_steel, 1)), new AnvilOutput(new ItemStack(ModItems.plate_lead, 2)), new AnvilOutput(new ItemStack(ModItems.nuclear_waste, 9))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.vitrified_barrel), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.tank_steel, 1)), new AnvilOutput(new ItemStack(ModItems.plate_lead, 2)), new AnvilOutput(new ItemStack(ModItems.nuclear_waste_vitrified, 9))}).setTier(3));
    }

    public static void pullFromAssembler(RecipesCommon.ComparableStack result, int tier) {
        RecipesCommon.AStack[] ingredients = AssemblerRecipes.recipes.get(result);
        if (ingredients != null) {
            constructionRecipes.add(new AnvilConstructionRecipe(ingredients, new AnvilOutput(result.toStack())).setTier(tier));
        }
    }

    public static List<AnvilSmithingRecipe> getSmithing() {
        return smithingRecipes;
    }

    public static List<AnvilConstructionRecipe> getConstruction() {
        return constructionRecipes;
    }

    public static boolean removeConstructionRecipe(ItemStack[] outputs) {
        block0: for (AnvilConstructionRecipe constructionRecipe : constructionRecipes) {
            if (constructionRecipe.output.size() != outputs.length) continue;
            for (int i = 0; i < outputs.length; ++i) {
                if (!ItemStack.func_77989_b((ItemStack)constructionRecipe.output.get((int)i).stack, (ItemStack)outputs[i])) continue block0;
            }
            CraftTweakerAPI.logInfo((String)("remove anvil recipe" + constructionRecipe));
            constructionRecipes.remove(constructionRecipe);
            return true;
        }
        return false;
    }

    public static boolean removeConstructionRecipeByInput(RecipesCommon.AStack[] inputs) {
        block0: for (AnvilConstructionRecipe constructionRecipe : constructionRecipes) {
            if (constructionRecipe.input.size() != inputs.length) continue;
            for (int i = 0; i < inputs.length; ++i) {
                if (!inputs[i].equals(constructionRecipe.input.get(i))) continue block0;
            }
            CraftTweakerAPI.logInfo((String)("remove anvil recipe" + constructionRecipe));
            constructionRecipes.remove(constructionRecipe);
            return true;
        }
        return false;
    }

    public static void addConstructionRecipe(RecipesCommon.AStack[] inputs, ItemStack[] output, int tier) {
        AnvilOutput[] anvilOutputs = new AnvilOutput[output.length];
        for (int i = 0; i < output.length; ++i) {
            anvilOutputs[i] = new AnvilOutput(output[i]);
        }
        constructionRecipes.add(new AnvilConstructionRecipe(inputs, anvilOutputs).setTier(tier));
    }

    public static enum OverlayType {
        NONE,
        CONSTRUCTION,
        RECYCLING,
        SMITHING;

    }

    public static class AnvilOutput {
        public ItemStack stack;
        public float chance;

        public AnvilOutput(ItemStack stack) {
            this(stack, 1.0f);
        }

        public AnvilOutput(ItemStack stack, float chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }

    public static class AnvilConstructionRecipe {
        public List<RecipesCommon.AStack> input = new ArrayList<RecipesCommon.AStack>();
        public List<AnvilOutput> output = new ArrayList<AnvilOutput>();
        public int tierLower = 0;
        public int tierUpper = -1;
        OverlayType overlay = OverlayType.NONE;

        public AnvilConstructionRecipe(RecipesCommon.AStack input, AnvilOutput output) {
            this.input.add(input);
            this.output.add(output);
            this.setOverlay(OverlayType.SMITHING);
        }

        public AnvilConstructionRecipe(RecipesCommon.AStack[] input, AnvilOutput output) {
            for (RecipesCommon.AStack stack : input) {
                this.input.add(stack);
            }
            this.output.add(output);
            this.setOverlay(OverlayType.CONSTRUCTION);
        }

        public AnvilConstructionRecipe(RecipesCommon.AStack input, AnvilOutput[] output) {
            this.input.add(input);
            for (AnvilOutput out : output) {
                this.output.add(out);
            }
            this.setOverlay(OverlayType.RECYCLING);
        }

        public AnvilConstructionRecipe(RecipesCommon.AStack[] input, AnvilOutput[] output) {
            for (RecipesCommon.AStack stack : input) {
                this.input.add(stack);
            }
            for (AnvilOutput out : output) {
                this.output.add(out);
            }
            this.setOverlay(OverlayType.NONE);
        }

        public AnvilConstructionRecipe setTier(int tier) {
            this.tierLower = tier;
            if (GeneralConfig.enableBabyMode) {
                this.tierLower = 1;
            }
            return this;
        }

        public AnvilConstructionRecipe setTierRange(int lower, int upper) {
            this.tierLower = lower;
            this.tierUpper = upper;
            if (GeneralConfig.enableBabyMode) {
                this.tierUpper = 1;
                this.tierLower = 1;
            }
            return this;
        }

        public boolean isTierValid(int tier) {
            if (this.tierUpper == -1) {
                return tier >= this.tierLower;
            }
            return tier >= this.tierLower && tier <= this.tierUpper;
        }

        public AnvilConstructionRecipe setOverlay(OverlayType overlay) {
            this.overlay = overlay;
            return this;
        }

        public OverlayType getOverlay() {
            return this.overlay;
        }

        public ItemStack getDisplay() {
            switch (this.overlay) {
                case NONE: {
                    return this.output.get((int)0).stack.func_77946_l();
                }
                case CONSTRUCTION: {
                    return this.output.get((int)0).stack.func_77946_l();
                }
                case SMITHING: {
                    return this.output.get((int)0).stack.func_77946_l();
                }
                case RECYCLING: {
                    for (RecipesCommon.AStack stack : this.input) {
                        if (!(stack instanceof RecipesCommon.ComparableStack)) continue;
                        return ((RecipesCommon.ComparableStack)stack).toStack();
                    }
                    return this.output.get((int)0).stack.func_77946_l();
                }
            }
            return new ItemStack(Items.field_151035_b);
        }
    }
}

