/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.jei;

import com.hbm.handler.jei.JeiRecipes;
import com.hbm.util.I18nUtil;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class ReactorRecipeHandler
implements IRecipeCategory<JeiRecipes.ReactorRecipe> {
    public static final ResourceLocation gui_rl = new ResourceLocation("hbm", "textures/gui/processing/gui_breeder.png");
    protected final IDrawable background;
    protected final IDrawableStatic progressStatic;
    protected final IDrawableAnimated progressAnimated;
    protected final IDrawableStatic fuelStatic;
    protected final IDrawableAnimated fuelAnimated;
    public final IDrawableStatic heat;
    protected JeiRecipes.ReactorRecipe currentRecipe;

    public ReactorRecipeHandler(IGuiHelper help) {
        this.background = help.createDrawable(gui_rl, 47, 15, 90, 55);
        this.progressStatic = help.createDrawable(gui_rl, 176, 16, 24, 17);
        this.progressAnimated = help.createAnimatedDrawable(this.progressStatic, 48, IDrawableAnimated.StartDirection.LEFT, false);
        this.fuelStatic = help.createDrawable(gui_rl, 176, 0, 18, 16);
        this.fuelAnimated = help.createAnimatedDrawable(this.fuelStatic, 144, IDrawableAnimated.StartDirection.TOP, true);
        JeiRecipes.ReactorRecipe.heatTex = this.heat = help.createDrawable(gui_rl, 194, 0, 4, 16);
    }

    public String getUid() {
        return "hbm.reactor";
    }

    public String getTitle() {
        return I18nUtil.resolveKey("tile.machine_reactor.name", new Object[0]);
    }

    public String getModName() {
        return "hbm";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.progressAnimated.draw(minecraft, 33, 19);
        this.fuelAnimated.draw(minecraft, 8, 20);
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiRecipes.ReactorRecipe recipeWrapper, IIngredients ingredients) {
        this.currentRecipe = recipeWrapper;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 8, 1);
        guiItemStacks.init(1, false, 68, 19);
        guiItemStacks.init(2, true, 8, 37);
        guiItemStacks.set(ingredients);
        guiItemStacks.set(2, JeiRecipes.getReactorFuels(recipeWrapper.heat));
    }
}

