/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHurtBehavior;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemGunDart;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.render.misc.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;

public class GunDartFactory {
    public static GunConfiguration getDarterConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.hasSights = false;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 1;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CROSS;
        config.durability = 1000;
        config.reloadSound = GunConfiguration.RSOUND_GRENADE;
        config.firingSound = HBMSoundHandler.dartShoot;
        config.reloadSoundEnd = false;
        config.showAmmo = true;
        config.name = "Needle Gun";
        config.manufacturer = "-";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.NEEDLE_GPS);
        return config;
    }

    public static BulletConfiguration getGPSConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_dart;
        bullet.velocity = 5.0f;
        bullet.spread = 0.0f;
        bullet.dmgMin = 1.0f;
        bullet.dmgMax = 2.0f;
        bullet.doesRicochet = true;
        bullet.doesPenetrate = false;
        bullet.style = 1;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(MobEffects.field_82731_v, 1200, 2));
        bullet.bHurt = new IBulletHurtBehavior(){

            @Override
            public void behaveEntityHurt(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (hit instanceof EntityPlayer) {
                    if (Library.hasInventoryItem(((EntityPlayer)hit).field_71071_by, ModItems.ingot_meteorite_forged)) {
                        return;
                    }
                    if (bullet.shooter instanceof EntityPlayer) {
                        EntityPlayer shooter = (EntityPlayer)bullet.shooter;
                        for (EnumHand hand : EnumHand.values()) {
                            if (shooter.func_184586_b(hand) == null || shooter.func_184586_b(hand).func_77973_b() != ModItems.gun_darter) continue;
                            ItemGunDart.writePlayer(shooter.func_184586_b(hand), (EntityPlayer)hit);
                            shooter.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
                        }
                    }
                }
            }
        };
        return bullet;
    }
}

