/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.HeatRecipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.FluidHeating")
public class FluidHeating {
    @ZenMethod
    public static void addBoilRecipe(String inputFluid, int inputAmount, String outputFluid, int outputAmount, int heatCapacity) {
        NTMCraftTweaker.postInitActions.add(new ActionAddBoilRecipe(inputFluid, inputAmount, outputFluid, outputAmount, heatCapacity));
    }

    @ZenMethod
    public static void addCoolRecipe(String inputFluid, int inputAmount, String outputFluid, int outputAmount, int heatCapacity) {
        NTMCraftTweaker.postInitActions.add(new ActionAddCoolRecipe(inputFluid, inputAmount, outputFluid, outputAmount, heatCapacity));
    }

    @ZenMethod
    public static void addBoilAndCoolRecipe(String inputFluid, int inputAmount, String outputFluid, int outputAmount, int heatCapacity) {
        NTMCraftTweaker.postInitActions.add(new ActionAddBoilAndCoolRecipe(inputFluid, inputAmount, outputFluid, outputAmount, heatCapacity));
    }

    @ZenMethod
    public static void removeBoilRecipe(String inputFluid) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveBoilRecipe(inputFluid));
    }

    @ZenMethod
    public static void removeCoolRecipe(String inputFluid) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveCoolRecipe(inputFluid));
    }

    private static class ActionRemoveCoolRecipe
    implements IAction {
        private String inputFluid;

        public ActionRemoveCoolRecipe(String inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            if (this.inputFluid == null || this.inputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.inputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Input Fluid (" + this.inputFluid + ") does not exist!"));
                return;
            }
            HeatRecipes.removeCoolRecipe(this.inputFluid);
        }

        public String describe() {
            return "Removing NTM fluid cooling recipe for (" + this.inputFluid + ")";
        }
    }

    private static class ActionRemoveBoilRecipe
    implements IAction {
        private String inputFluid;

        public ActionRemoveBoilRecipe(String inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            if (this.inputFluid == null || this.inputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.inputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Input Fluid (" + this.inputFluid + ") does not exist!"));
                return;
            }
            HeatRecipes.removeBoilRecipe(this.inputFluid);
        }

        public String describe() {
            return "Removing NTM fluid heating recipe for (" + this.inputFluid + ")";
        }
    }

    private static class ActionAddBoilAndCoolRecipe
    implements IAction {
        private String inputFluid;
        private int inputAmount;
        private String outputFluid;
        private int outputAmount;
        private int heatCapacity;

        public ActionAddBoilAndCoolRecipe(String inputFluid, int inputAmount, String outputFluid, int outputAmount, int heatCapacity) {
            this.inputFluid = inputFluid;
            this.inputAmount = inputAmount;
            this.outputFluid = outputFluid;
            this.outputAmount = outputAmount;
            this.heatCapacity = heatCapacity;
        }

        public void apply() {
            if (this.inputFluid == null || this.inputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.inputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Input Fluid (" + this.inputFluid + ") does not exist!"));
                return;
            }
            if (this.inputAmount < 1) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid Amount can not be < 1!");
                return;
            }
            if (this.outputFluid == null || this.outputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Output Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.outputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Output Fluid (" + this.outputFluid + ") does not exist!"));
                return;
            }
            if (this.outputAmount < 1) {
                CraftTweakerAPI.logError((String)"ERROR Output Fluid Amount can not be < 1!");
                return;
            }
            if (this.heatCapacity < 1) {
                CraftTweakerAPI.logError((String)"ERROR Heat Capactiy can not be < 1!");
                return;
            }
            HeatRecipes.addBoilAndCoolRecipe(this.inputFluid, this.inputAmount, this.outputFluid, this.outputAmount, this.heatCapacity);
        }

        public String describe() {
            return "Adding NTM fluid heating recipe pair (" + this.inputAmount + "mb " + this.inputFluid + " + " + this.heatCapacity + "TU -> " + this.outputAmount + "mb " + this.outputFluid + ")";
        }
    }

    private static class ActionAddCoolRecipe
    implements IAction {
        private String inputFluid;
        private int inputAmount;
        private String outputFluid;
        private int outputAmount;
        private int heatCapacity;

        public ActionAddCoolRecipe(String inputFluid, int inputAmount, String outputFluid, int outputAmount, int heatCapacity) {
            this.inputFluid = inputFluid;
            this.inputAmount = inputAmount;
            this.outputFluid = outputFluid;
            this.outputAmount = outputAmount;
            this.heatCapacity = heatCapacity;
        }

        public void apply() {
            if (this.inputFluid == null || this.inputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.inputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Input Fluid (" + this.inputFluid + ") does not exist!"));
                return;
            }
            if (this.inputAmount < 1) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid Amount can not be < 1!");
                return;
            }
            if (this.outputFluid == null || this.outputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Output Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.outputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Output Fluid (" + this.outputFluid + ") does not exist!"));
                return;
            }
            if (this.outputAmount < 1) {
                CraftTweakerAPI.logError((String)"ERROR Output Fluid Amount can not be < 1!");
                return;
            }
            if (this.heatCapacity < 1) {
                CraftTweakerAPI.logError((String)"ERROR Heat Capactiy can not be < 1!");
                return;
            }
            HeatRecipes.addCoolRecipe(this.inputFluid, this.inputAmount, this.outputFluid, this.outputAmount, this.heatCapacity);
        }

        public String describe() {
            return "Adding NTM fluid cooling recipe (" + this.inputAmount + "mb " + this.inputFluid + " -> " + this.outputAmount + "mb " + this.outputFluid + " + " + this.heatCapacity + "TU)";
        }
    }

    private static class ActionAddBoilRecipe
    implements IAction {
        private String inputFluid;
        private int inputAmount;
        private String outputFluid;
        private int outputAmount;
        private int heatCapacity;

        public ActionAddBoilRecipe(String inputFluid, int inputAmount, String outputFluid, int outputAmount, int heatCapacity) {
            this.inputFluid = inputFluid;
            this.inputAmount = inputAmount;
            this.outputFluid = outputFluid;
            this.outputAmount = outputAmount;
            this.heatCapacity = heatCapacity;
        }

        public void apply() {
            if (this.inputFluid == null || this.inputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.inputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Input Fluid (" + this.inputFluid + ") does not exist!"));
                return;
            }
            if (this.inputAmount < 1) {
                CraftTweakerAPI.logError((String)"ERROR Input Fluid Amount can not be < 1!");
                return;
            }
            if (this.outputFluid == null || this.outputFluid.trim().isEmpty()) {
                CraftTweakerAPI.logError((String)"ERROR Output Fluid can not be null/empty!");
                return;
            }
            if (!FluidRegistry.isFluidRegistered((String)this.outputFluid)) {
                CraftTweakerAPI.logError((String)("ERROR Output Fluid (" + this.outputFluid + ") does not exist!"));
                return;
            }
            if (this.outputAmount < 1) {
                CraftTweakerAPI.logError((String)"ERROR Output Fluid Amount can not be < 1!");
                return;
            }
            if (this.heatCapacity < 1) {
                CraftTweakerAPI.logError((String)"ERROR Heat Capactiy can not be < 1!");
                return;
            }
            HeatRecipes.addBoilRecipe(this.inputFluid, this.inputAmount, this.outputFluid, this.outputAmount, this.heatCapacity);
        }

        public String describe() {
            return "Adding NTM fluid heating recipe (" + this.inputAmount + "mb " + this.inputFluid + " + " + this.heatCapacity + "TU -> " + this.outputAmount + "mb " + this.outputFluid + ")";
        }
    }
}

