/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.blocks.generic.BlockStorageCrate;
import com.hbm.blocks.machine.MachineBattery;
import com.hbm.blocks.machine.MachineFENSU;
import com.hbm.config.ToolConfig;
import com.hbm.explosion.ExplosionNT;
import com.hbm.inventory.CentrifugeRecipes;
import com.hbm.inventory.CrystallizerRecipes;
import com.hbm.inventory.ShredderRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.tool.IItemAbility;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.EnchantmentUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ToolAbility {
    public abstract void onDig(World var1, int var2, int var3, int var4, EntityPlayer var5, IBlockState var6, IItemAbility var7, EnumHand var8);

    public abstract String getName();

    @SideOnly(value=Side.CLIENT)
    public abstract String getFullName();

    public abstract String getExtension();

    public abstract boolean isAllowed();

    public boolean isNBTThing(Block b) {
        return b instanceof BlockStorageCrate || b instanceof MachineBattery || b instanceof MachineFENSU;
    }

    public static class ExplosionAbility
    extends ToolAbility {
        float strength;

        public ExplosionAbility(float strength) {
            this.strength = strength;
        }

        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            ExplosionNT ex = new ExplosionNT(player.field_70170_p, (Entity)player, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, this.strength);
            ex.addAttrib(ExplosionNT.ExAttrib.ALLDROP);
            ex.addAttrib(ExplosionNT.ExAttrib.NOHURT);
            ex.addAttrib(ExplosionNT.ExAttrib.NOPARTICLE);
            ex.explode();
            player.field_70170_p.func_72876_a((Entity)player, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.1f, false);
        }

        @Override
        public String getExtension() {
            return " (" + this.strength + ")";
        }

        @Override
        public String getName() {
            return "tool.ability.explosion";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityExplosion;
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }
    }

    public static class MercuryAbility
    extends ToolAbility {
        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            if (block.func_177230_c() == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax.func_176223_P();
            }
            int mercury = 0;
            if (block.func_177230_c() == Blocks.field_150450_ax) {
                mercury = player.func_70681_au().nextInt(5) + 4;
            }
            if (block.func_177230_c() == Blocks.field_150451_bX) {
                mercury = player.func_70681_au().nextInt(7) + 8;
            }
            if (mercury > 0) {
                world.func_175698_g(new BlockPos(x, y, z));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.nugget_mercury, mercury)));
            }
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public String getName() {
            return "tool.ability.mercury";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityMercury;
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }
    }

    public static class CrystallizerAbility
    extends ToolAbility {
        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            ItemStack stack;
            ItemStack result;
            if (block.func_177230_c() == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax.func_176223_P();
            }
            if ((result = CrystallizerRecipes.getOutputItem(stack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block)))) != null) {
                world.func_175698_g(new BlockPos(x, y, z));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, result.func_77946_l()));
            }
        }

        @Override
        public String getExtension() {
            return "";
        }

        @Override
        public String getName() {
            return "tool.ability.crystallizer";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityCrystallizer;
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }
    }

    public static class LuckAbility
    extends ToolAbility {
        int luck;

        public LuckAbility(int luck) {
            this.luck = luck;
        }

        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184586_b(hand)) > 0 || player.func_184586_b(hand) == null) {
                return;
            }
            if (this.isNBTThing(block.func_177230_c())) {
                return;
            }
            ItemStack stack = player.func_184586_b(hand);
            EnchantmentUtil.addEnchantment(stack, Enchantments.field_185308_t, this.luck);
            BlockPos pos = new BlockPos(x, y, z);
            block.func_177230_c().func_180657_a(world, player, pos, block, world.func_175625_s(pos), stack);
            EnchantmentUtil.removeEnchantment(stack, Enchantments.field_185308_t);
            world.func_175698_g(pos);
        }

        @Override
        public String getName() {
            return "tool.ability.luck";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityLuck;
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }

        @Override
        public String getExtension() {
            return " (" + this.luck + ")";
        }
    }

    public static class SilkAbility
    extends ToolAbility {
        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184586_b(hand)) > 0 || player.func_184586_b(hand).func_190926_b()) {
                return;
            }
            if (this.isNBTThing(block.func_177230_c())) {
                return;
            }
            ItemStack stack = player.func_184586_b(hand);
            EnchantmentUtil.addEnchantment(stack, Enchantments.field_185306_r, 1);
            BlockPos pos = new BlockPos(x, y, z);
            block.func_177230_c().func_180657_a(world, player, pos, block, world.func_175625_s(pos), stack);
            EnchantmentUtil.removeEnchantment(stack, Enchantments.field_185306_r);
            world.func_175698_g(pos);
        }

        @Override
        public String getName() {
            return "tool.ability.silktouch";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilitySilk;
        }

        @Override
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public String getExtension() {
            return "";
        }
    }

    public static class CentrifugeAbility
    extends ToolAbility {
        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            ItemStack stack;
            ItemStack[] result;
            if (block.func_177230_c() == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax.func_176223_P();
            }
            if ((result = CentrifugeRecipes.getOutput(stack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block)))) != null) {
                world.func_175698_g(new BlockPos(x, y, z));
                for (ItemStack st : result) {
                    if (st == null) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, st.func_77946_l()));
                }
            }
        }

        @Override
        public String getName() {
            return "tool.ability.centrifuge";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityCentrifuge;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public String getExtension() {
            return "";
        }
    }

    public static class ShredderAbility
    extends ToolAbility {
        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            ItemStack stack;
            ItemStack result;
            if (block.func_177230_c() == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax.func_176223_P();
            }
            if ((result = ShredderRecipes.getShredderResult(stack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block)))) != null && result.func_77973_b() != ModItems.scrap) {
                world.func_175698_g(new BlockPos(x, y, z));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, result.func_77946_l()));
            }
        }

        @Override
        public String getName() {
            return "tool.ability.shredder";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityShredder;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public String getExtension() {
            return "";
        }
    }

    public static class SmelterAbility
    extends ToolAbility {
        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            if (this.isNBTThing(block.func_177230_c())) {
                return;
            }
            if (block.func_177230_c() == Blocks.field_150439_ay) {
                block = Blocks.field_150450_ax.func_176223_P();
            }
            ItemStack stack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block));
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
            if (result != null && !result.func_190926_b()) {
                world.func_175698_g(new BlockPos(x, y, z));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, result.func_77946_l()));
            }
        }

        @Override
        public String getName() {
            return "tool.ability.smelter";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityFurnace;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]);
        }

        @Override
        public String getExtension() {
            return "";
        }
    }

    public static class HammerAbility
    extends ToolAbility {
        int range;

        public HammerAbility(int range) {
            this.range = range;
        }

        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            for (int a = x - this.range; a <= x + this.range; ++a) {
                for (int b = y - this.range; b <= y + this.range; ++b) {
                    for (int c = z - this.range; c <= z + this.range; ++c) {
                        if (a == x && b == y && c == z) continue;
                        tool.breakExtraBlock(world, a, b, c, player, x, y, z, hand);
                    }
                }
            }
        }

        @Override
        public String getName() {
            return "tool.ability.hammer";
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityHammer;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }

        @Override
        public String getExtension() {
            return " (" + this.range + ")";
        }
    }

    public static class RecursionAbility
    extends ToolAbility {
        int radius;
        private Set<BlockPos> pos = new HashSet<BlockPos>();

        public RecursionAbility(int radius) {
            this.radius = radius;
        }

        @Override
        public void onDig(World world, int x, int y, int z, EntityPlayer player, IBlockState block, IItemAbility tool, EnumHand hand) {
            Block b = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            if (b == Blocks.field_150348_b && !ToolConfig.recursiveStone) {
                return;
            }
            if (b == Blocks.field_150424_aL && !ToolConfig.recursiveNetherrack) {
                return;
            }
            List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4, 5);
            Collections.shuffle(indices);
            this.pos.clear();
            for (Integer i : indices) {
                switch (i) {
                    case 0: {
                        this.breakExtra(world, x + 1, y, z, x, y, z, player, tool, hand, 0);
                        break;
                    }
                    case 1: {
                        this.breakExtra(world, x - 1, y, z, x, y, z, player, tool, hand, 0);
                        break;
                    }
                    case 2: {
                        this.breakExtra(world, x, y + 1, z, x, y, z, player, tool, hand, 0);
                        break;
                    }
                    case 3: {
                        this.breakExtra(world, x, y - 1, z, x, y, z, player, tool, hand, 0);
                        break;
                    }
                    case 4: {
                        this.breakExtra(world, x, y, z + 1, x, y, z, player, tool, hand, 0);
                        break;
                    }
                    case 5: {
                        this.breakExtra(world, x, y, z - 1, x, y, z, player, tool, hand, 0);
                    }
                }
            }
        }

        @Override
        public boolean isAllowed() {
            return ToolConfig.abilityVein;
        }

        private boolean areRedstone(IBlockState ref, IBlockState b) {
            return ref.func_177230_c() instanceof BlockRedstoneOre && b.func_177230_c() instanceof BlockRedstoneOre;
        }

        private void breakExtra(World world, int x, int y, int z, int refX, int refY, int refZ, EntityPlayer player, IItemAbility tool, EnumHand hand, int depth) {
            IBlockState ref;
            if (this.pos.contains(new BlockPos(x, y, z))) {
                return;
            }
            if (++depth > ToolConfig.recursionDepth) {
                return;
            }
            this.pos.add(new BlockPos(x, y, z));
            if (x == refX && y == refY && z == refZ) {
                return;
            }
            if (Vec3.createVectorHelper(x - refX, y - refY, z - refZ).lengthVector() > (double)this.radius) {
                return;
            }
            IBlockState b = world.func_180495_p(new BlockPos(x, y, z));
            if (b != (ref = world.func_180495_p(new BlockPos(refX, refY, refZ))) && !this.areRedstone(ref, b)) {
                return;
            }
            if (player.func_184586_b(hand).func_190926_b()) {
                return;
            }
            tool.breakExtraBlock(world, x, y, z, player, refX, refY, refZ, hand);
            List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4, 5);
            Collections.shuffle(indices);
            for (Integer i : indices) {
                switch (i) {
                    case 0: {
                        this.breakExtra(world, x + 1, y, z, refX, refY, refZ, player, tool, hand, depth);
                        break;
                    }
                    case 1: {
                        this.breakExtra(world, x - 1, y, z, refX, refY, refZ, player, tool, hand, depth);
                        break;
                    }
                    case 2: {
                        this.breakExtra(world, x, y + 1, z, refX, refY, refZ, player, tool, hand, depth);
                        break;
                    }
                    case 3: {
                        this.breakExtra(world, x, y - 1, z, refX, refY, refZ, player, tool, hand, depth);
                        break;
                    }
                    case 4: {
                        this.breakExtra(world, x, y, z + 1, refX, refY, refZ, player, tool, hand, depth);
                        break;
                    }
                    case 5: {
                        this.breakExtra(world, x, y, z - 1, refX, refY, refZ, player, tool, hand, depth);
                    }
                }
            }
        }

        @Override
        public String getName() {
            return "tool.ability.recursion";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public String getFullName() {
            return I18n.func_135052_a((String)this.getName(), (Object[])new Object[0]) + this.getExtension();
        }

        @Override
        public String getExtension() {
            return " (" + this.radius + ")";
        }
    }
}

