/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.config.CompatibilityConfig;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ExplosionNukeRayBatched {
    public HashMap<ChunkPos, HashSet<IntTriplet>> perChunk = new HashMap();
    public List<ChunkPos> orderedChunks = new ArrayList<ChunkPos>();
    private CoordComparator comparator = new CoordComparator();
    public boolean isContained = true;
    int posX;
    int posY;
    int posZ;
    World world;
    int strength;
    int radius;
    int gspNumMax;
    int gspNum;
    double gspX;
    double gspY;
    private static final int maxY = 255;
    private static final int minY = 0;
    public boolean isAusf3Complete = false;
    HashSet<IntTriplet> positions = new HashSet();
    ChunkPos chunk;

    public ExplosionNukeRayBatched(World world, int x, int y, int z, int strength, int radius) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.radius = radius;
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.gspNum = 1;
        this.gspX = Math.PI;
        this.gspY = 0.0;
    }

    private void generateGspUp() {
        if (this.gspNum < this.gspNumMax) {
            int k = this.gspNum + 1;
            double hk = -1.0 + 2.0 * ((double)k - 1.0) / ((double)this.gspNumMax - 1.0);
            this.gspX = Math.acos(hk);
            double prev_lon = this.gspY;
            double lon = prev_lon + 3.6 / Math.sqrt(this.gspNumMax) / Math.sqrt(1.0 - hk * hk);
            this.gspY = lon % (Math.PI * 2);
        } else {
            this.gspX = 0.0;
            this.gspY = 0.0;
        }
        ++this.gspNum;
    }

    private Vec3 getSpherical2cartesian() {
        double dx = Math.sin(this.gspX) * Math.cos(this.gspY);
        double dz = Math.sin(this.gspX) * Math.sin(this.gspY);
        double dy = Math.cos(this.gspX);
        return Vec3.createVectorHelper(dx, dy, dz);
    }

    public void addPos(int x, int y, int z) {
        HashSet<IntTriplet> triplets = this.perChunk.get(new ChunkPos(x >> 4, z >> 4));
        if (triplets == null) {
            triplets = new HashSet();
            this.perChunk.put(new ChunkPos(x >> 4, z >> 4), triplets);
        }
        triplets.add(new IntTriplet(x, y, z));
    }

    public void collectTip(int time) {
        if (!CompatibilityConfig.isWarDim(this.world)) {
            this.isAusf3Complete = true;
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        long raysProcessed = 0L;
        long start = System.currentTimeMillis();
        while (this.gspNumMax >= this.gspNum) {
            Vec3 vec = this.getSpherical2cartesian();
            int radius = (int)Math.ceil(this.radius);
            float rayStrength = (float)this.strength * 0.3f;
            for (int r = 0; r < radius + 1; ++r) {
                int iY = (int)Math.floor((double)this.posY + vec.yCoord * (double)r);
                if (iY < 0 || iY > 255) {
                    this.isContained = false;
                    break;
                }
                int iX = (int)Math.floor((double)this.posX + vec.xCoord * (double)r);
                int iZ = (int)Math.floor((double)this.posZ + vec.zCoord * (double)r);
                pos.func_181079_c(iX, iY, iZ);
                IBlockState blockState = this.world.func_180495_p((BlockPos)pos);
                Block b = blockState.func_177230_c();
                if (b.func_149638_a(null) >= 2000000.0f || !((rayStrength = (float)((double)rayStrength - (Math.pow(ExplosionNukeRayBatched.getNukeResistance(blockState, b) + 1.0f, 3.0 * (double)r / (double)radius) - 1.0))) > 0.0f)) break;
                if (b != Blocks.field_150350_a) {
                    this.addPos(iX, iY, iZ);
                }
                if (r < radius) continue;
                this.isContained = false;
            }
            this.generateGspUp();
            if (++raysProcessed % 50L != 0L || System.currentTimeMillis() + 1L <= start + (long)time) continue;
            return;
        }
        this.orderedChunks.addAll(this.perChunk.keySet());
        this.orderedChunks.sort(this.comparator);
        this.isAusf3Complete = true;
    }

    public static float getNukeResistance(IBlockState blockState, Block b) {
        if (blockState.func_185904_a().func_76224_d()) {
            return 0.1f;
        }
        if (b == Blocks.field_150322_A) {
            return 4.0f;
        }
        if (b == Blocks.field_150343_Z) {
            return 18.0f;
        }
        return b.func_149638_a(null);
    }

    public void processChunk(int time) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + (long)time) {
            this.processChunkBlocks(start, time);
        }
    }

    public void processChunkBlocks(long start, int time) {
        if (!CompatibilityConfig.isWarDim(this.world)) {
            this.perChunk.clear();
        }
        if (this.perChunk.isEmpty()) {
            return;
        }
        int i = 0;
        if (this.positions.size() == 0) {
            this.chunk = this.orderedChunks.get(0);
        }
        this.positions = this.perChunk.get(this.chunk);
        ArrayList<IntTriplet> done = new ArrayList<IntTriplet>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (IntTriplet coord : this.positions) {
            pos.func_181079_c(coord.xCoord, coord.yCoord, coord.zCoord);
            this.world.func_175698_g((BlockPos)pos);
            done.add(coord);
            if (++i % 256 != 0 || System.currentTimeMillis() + 1L <= start + (long)time) continue;
            break;
        }
        this.positions.removeAll(done);
        if (this.positions.size() == 0) {
            this.perChunk.remove(this.chunk);
            this.orderedChunks.remove(0);
        }
    }

    public class IntTriplet {
        public final int xCoord;
        public final int yCoord;
        public final int zCoord;
        private final int hashCode;

        public IntTriplet(int x, int y, int z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.hashCode = Objects.hash(x, y, z);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IntTriplet)) {
                return false;
            }
            IntTriplet other = (IntTriplet)obj;
            if (this.xCoord != other.xCoord) {
                return false;
            }
            if (this.yCoord != other.yCoord) {
                return false;
            }
            return this.zCoord == other.zCoord;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public class CoordComparator
    implements Comparator<ChunkPos> {
        @Override
        public int compare(ChunkPos o1, ChunkPos o2) {
            int diff2;
            int chunkX = ExplosionNukeRayBatched.this.posX >> 4;
            int chunkZ = ExplosionNukeRayBatched.this.posZ >> 4;
            int diff1 = Math.abs(chunkX - (o1.func_180334_c() >> 4)) + Math.abs(chunkZ - (o1.func_180333_d() >> 4));
            return diff1 > (diff2 = Math.abs(chunkX - (o2.func_180334_c() >> 4)) + Math.abs(chunkZ - (o2.func_180333_d() >> 4))) ? 1 : (diff1 < diff2 ? -1 : 0);
        }
    }
}

