/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.RedBarrel;
import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.entity.effect.EntityCloudFleijaRainbow;
import com.hbm.entity.effect.EntityEMPBlast;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.entity.particle.EntityTSmokeFX;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.handler.ArmorUtil;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.bullet_hit.EntityHitDataHandler;
import com.hbm.potion.HbmPotion;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.BobMathUtil;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBulletBase
extends Entity
implements IProjectile {
    public static final DataParameter<Integer> STYLE = EntityDataManager.func_187226_a(EntityBulletBase.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> TRAIL = EntityDataManager.func_187226_a(EntityBulletBase.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> BULLETCONFIG = EntityDataManager.func_187226_a(EntityBulletBase.class, (DataSerializer)DataSerializers.field_187192_b);
    public static Field lastDamage = null;
    private BulletConfiguration config;
    public EntityLivingBase shooter;
    public float overrideDamage;
    public int overrideMaxAge = -1;

    public BulletConfiguration getConfig() {
        return this.config;
    }

    public EntityBulletBase(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBulletBase(World world, int config) {
        super(world);
        this.config = BulletConfigSyncingUtil.pullConfig(config);
        this.func_184212_Q().func_187227_b(BULLETCONFIG, (Object)config);
        if (this.config == null) {
            this.func_70106_y();
            return;
        }
        this.func_184212_Q().func_187227_b(STYLE, (Object)this.config.style);
        this.func_184212_Q().func_187227_b(TRAIL, (Object)this.config.trail);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBulletBase(World world, int config, EntityLivingBase entity, EntityLivingBase target, float motion, float deviation) {
        super(world);
        this.config = BulletConfigSyncingUtil.pullConfig(config);
        this.func_184212_Q().func_187227_b(BULLETCONFIG, (Object)config);
        this.shooter = entity;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70163_u = entity.field_70163_u + (double)entity.func_70047_e() - (double)0.1f;
        double d0 = target.field_70165_t - entity.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = target.field_70161_v - entity.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(entity.field_70165_t + d4, this.field_70163_u, entity.field_70161_v + d5, f2, f3);
            this.func_70186_c(d0, d1, d2, motion, deviation);
        }
        this.func_184212_Q().func_187227_b(STYLE, (Object)this.config.style);
        this.func_184212_Q().func_187227_b(TRAIL, (Object)this.config.trail);
    }

    public EntityBulletBase(World world, int config, EntityLivingBase entity, EnumHand hand) {
        super(world);
        this.config = BulletConfigSyncingUtil.pullConfig(config);
        this.func_184212_Q().func_187227_b(BULLETCONFIG, (Object)config);
        this.shooter = entity;
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        if (hand == EnumHand.MAIN_HAND) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        } else {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70105_a(0.5f, 0.5f);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 2.0f, this.config.spread);
        this.func_184212_Q().func_187227_b(STYLE, (Object)this.config.style);
        this.func_184212_Q().func_187227_b(TRAIL, (Object)this.config.trail);
    }

    public EntityBulletBase(World world, int config, EntityLivingBase entity) {
        super(world);
        this.config = BulletConfigSyncingUtil.pullConfig(config);
        this.func_184212_Q().func_187227_b(BULLETCONFIG, (Object)config);
        this.shooter = entity;
        this.func_70012_b(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70105_a(0.5f, 0.5f);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, this.config.spread);
        this.func_184212_Q().func_187227_b(STYLE, (Object)this.config.style);
        this.func_184212_Q().func_187227_b(TRAIL, (Object)this.config.trail);
    }

    public void overrideStyle(int style) {
        this.func_184212_Q().func_187227_b(STYLE, (Object)style);
    }

    public void func_70186_c(double moX, double moY, double moZ, float mult1, float mult2) {
        float f2 = MathHelper.func_76133_a((double)(moX * moX + moY * moY + moZ * moZ));
        moX /= (double)f2;
        moY /= (double)f2;
        moZ /= (double)f2;
        moX += this.field_70146_Z.nextGaussian() * (double)mult2;
        moY += this.field_70146_Z.nextGaussian() * (double)mult2;
        moZ += this.field_70146_Z.nextGaussian() * (double)mult2;
        this.field_70159_w = moX *= (double)mult1;
        this.field_70181_x = moY *= (double)mult1;
        this.field_70179_y = moZ *= (double)mult1;
        float f3 = MathHelper.func_76133_a((double)(moX * moX + moZ * moZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(moX, moZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(moY, f3) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float r0, float r1, int i, boolean b) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(r0, r1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(STYLE, (Object)0);
        this.func_184212_Q().func_187214_a(TRAIL, (Object)0);
        this.func_184212_Q().func_187214_a(BULLETCONFIG, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.config == null) {
            this.config = BulletConfigSyncingUtil.pullConfig((Integer)this.func_184212_Q().func_187225_a(BULLETCONFIG));
        }
        if (this.config == null) {
            this.func_70106_y();
            return;
        }
        if (this.config.maxAge == 0) {
            this.func_70106_y();
            return;
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        Vec3d vecOrigin = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vecDestination = new Vec3d(this.field_70165_t + this.field_70159_w * (double)this.config.velocity, this.field_70163_u + this.field_70181_x * (double)this.config.velocity, this.field_70161_v + this.field_70179_y * (double)this.config.velocity);
        RayTraceResult movement = this.field_70170_p.func_147447_a(vecOrigin, vecDestination, false, true, false);
        vecOrigin = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vecDestination = new Vec3d(this.field_70165_t + this.field_70159_w * (double)this.config.velocity, this.field_70163_u + this.field_70181_x * (double)this.config.velocity, this.field_70161_v + this.field_70179_y * (double)this.config.velocity);
        Entity victim = null;
        RayTraceResult victimResult = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(Math.abs(this.field_70159_w * (double)this.config.velocity), Math.abs(this.field_70181_x * (double)this.config.velocity), Math.abs(this.field_70179_y * (double)this.config.velocity)).func_186662_g(1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == this.shooter) continue;
            float f1 = 0.3f;
            AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_186662_g((double)f1);
            RayTraceResult movingobjectposition1 = axisalignedbb1.func_72327_a(vecOrigin, vecDestination);
            if (movingobjectposition1 == null || movingobjectposition1.field_72313_a == RayTraceResult.Type.MISS || !((d1 = vecOrigin.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
            victim = entity1;
            victimResult = movingobjectposition1;
            d0 = d1;
        }
        if (victim != null) {
            movement = victimResult;
            movement.field_72313_a = RayTraceResult.Type.ENTITY;
            movement.field_72308_g = victim;
        }
        boolean didBounce = false;
        if (movement != null) {
            if (movement.field_72308_g != null && CompatibilityConfig.isWarDim(this.field_70170_p)) {
                DamageSource damagesource = null;
                damagesource = this.shooter == null ? ModDamageSource.causeBulletDamage(this, (Entity)this) : ModDamageSource.causeBulletDamage(this, (Entity)this.shooter);
                if (!this.field_70170_p.field_72995_K) {
                    if (!this.config.doesPenetrate) {
                        this.onEntityImpact(victim, movement);
                    } else {
                        this.onEntityHurt(victim, movement, true);
                    }
                }
                float damage = this.field_70146_Z.nextFloat() * (this.config.dmgMax - this.config.dmgMin) + this.config.dmgMin;
                if (this.overrideDamage != 0.0f) {
                    damage = this.overrideDamage;
                }
                if (!victim.func_70097_a(damagesource, damage)) {
                    try {
                        if (lastDamage == null) {
                            lastDamage = ReflectionHelper.findField(EntityLivingBase.class, (String)"lastDamage", (String)"field_110153_bc");
                        }
                        float dmg = damage + lastDamage.getFloat(victim);
                        victim.func_70097_a(damagesource, dmg);
                    }
                    catch (Exception dmg) {}
                }
            } else if (this.field_70170_p.func_180495_p(movement.func_178782_a()).func_185904_a() != Material.field_151579_a) {
                boolean doesRic;
                boolean hRic = this.field_70146_Z.nextInt(100) < this.config.HBRC;
                boolean bl = doesRic = this.config.doesRicochet || hRic;
                if (!this.config.isSpectral && !doesRic) {
                    this.onBlockImpact(movement.func_178782_a(), movement);
                }
                if (doesRic) {
                    Vec3d face = null;
                    switch (movement.field_178784_b) {
                        case DOWN: {
                            face = new Vec3d(0.0, -1.0, 0.0);
                            break;
                        }
                        case UP: {
                            face = new Vec3d(0.0, 1.0, 0.0);
                            break;
                        }
                        case SOUTH: {
                            face = new Vec3d(0.0, 0.0, 1.0);
                            break;
                        }
                        case NORTH: {
                            face = new Vec3d(0.0, 0.0, -1.0);
                            break;
                        }
                        case WEST: {
                            face = new Vec3d(-1.0, 0.0, 0.0);
                            break;
                        }
                        case EAST: {
                            face = new Vec3d(1.0, 0.0, 0.0);
                        }
                    }
                    if (face != null) {
                        Vec3d vel = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        vel.func_72432_b();
                        boolean lRic = this.field_70146_Z.nextInt(100) < this.config.LBRC;
                        double angle = Math.abs(BobMathUtil.getCrossAngle(vel, face) - 90.0);
                        if (hRic || angle <= this.config.ricochetAngle && lRic) {
                            switch (movement.field_178784_b.func_176740_k()) {
                                case Y: {
                                    this.field_70181_x *= -1.0;
                                    break;
                                }
                                case Z: {
                                    this.field_70179_y *= -1.0;
                                    break;
                                }
                                case X: {
                                    this.field_70159_w *= -1.0;
                                }
                            }
                            if (this.config.plink == 1) {
                                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.ricochet, SoundCategory.HOSTILE, 0.25f, 1.0f, true);
                            }
                            if (this.config.plink == 2) {
                                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.grenadeBounce, SoundCategory.HOSTILE, 1.0f, 1.0f, true);
                            }
                            this.onRicochet(movement.func_178782_a());
                        } else if (!this.field_70170_p.field_72995_K) {
                            this.onBlockImpact(movement.func_178782_a(), movement);
                        }
                        this.field_70165_t += (movement.field_72307_f.field_72450_a - this.field_70165_t) * 0.6;
                        this.field_70163_u += (movement.field_72307_f.field_72448_b - this.field_70163_u) * 0.6;
                        this.field_70161_v += (movement.field_72307_f.field_72449_c - this.field_70161_v) * 0.6;
                        this.field_70159_w *= this.config.bounceMod;
                        this.field_70181_x *= this.config.bounceMod;
                        this.field_70179_y *= this.config.bounceMod;
                        didBounce = true;
                    }
                }
            }
        }
        if (!didBounce) {
            this.field_70181_x -= this.config.gravity;
            this.field_70165_t += this.field_70159_w * (double)this.config.velocity;
            this.field_70163_u += this.field_70181_x * (double)this.config.velocity;
            this.field_70161_v += this.field_70179_y * (double)this.config.velocity;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.config.bUpdate != null) {
            this.config.bUpdate.behaveUpdate(this);
        }
        if (this.config.style == 5 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)new EntityTSmokeFX(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0));
        }
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        if (this.field_70173_aa > this.config.maxAge || this.overrideMaxAge != -1 && this.field_70173_aa > this.overrideMaxAge) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && !this.config.vPFX.isEmpty()) {
            double motion = Math.min(Vec3.createVectorHelper(this.field_70159_w, this.field_70181_x, this.field_70179_y).lengthVector(), 0.1);
            for (double d = 0.0; d < 1.0; d += 1.0 / motion) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vanillaExt");
                nbt.func_74778_a("mode", this.config.vPFX);
                nbt.func_74780_a("posX", (this.field_70142_S - this.field_70165_t) * d + this.field_70165_t);
                nbt.func_74780_a("posY", (this.field_70137_T - this.field_70163_u) * d + this.field_70163_u);
                nbt.func_74780_a("posZ", (this.field_70136_U - this.field_70161_v) * d + this.field_70161_v);
                MainRegistry.proxy.effectNT(nbt);
            }
        }
    }

    private void doHitVFX(@Nullable BlockPos pos, RayTraceResult hit) {
        if ((Integer)this.func_184212_Q().func_187225_a(STYLE) == 13) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("type", "bimpact");
            tag.func_74774_a("hitType", (byte)hit.field_72313_a.ordinal());
            Vec3d norm = Library.normalFromRayTrace(hit);
            tag.func_74776_a("nX", (float)norm.field_72450_a);
            tag.func_74776_a("nY", (float)norm.field_72448_b);
            tag.func_74776_a("nZ", (float)norm.field_72449_c);
            tag.func_74776_a("dirX", (float)this.field_70159_w);
            tag.func_74776_a("dirY", (float)this.field_70181_x);
            tag.func_74776_a("dirZ", (float)this.field_70179_y);
            if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
                Block block = blockstate.func_177230_c();
                tag.func_74768_a("block", Block.func_149682_b((Block)block));
                tag.func_74774_a("meta", (byte)block.func_176201_c(blockstate));
            }
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new AuxParticlePacketNT(tag, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c), (Entity)this);
            if (hit.field_72313_a == RayTraceResult.Type.ENTITY && hit.field_72308_g instanceof EntityLivingBase) {
                EntityHitDataHandler.addHit((EntityLivingBase)hit.field_72308_g, this, hit.field_72307_f, new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b());
            }
        }
    }

    private void onBlockImpact(BlockPos pos, RayTraceResult hit) {
        if (this.config.bImpact != null) {
            this.config.bImpact.behaveBlockHit(this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        this.doHitVFX(pos, hit);
        if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
            return;
        }
        if (this.config.incendiary > 0 && !this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0 && this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), Blocks.field_150480_ab.func_176223_P());
            }
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0 && this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t + 1, (int)this.field_70163_u, (int)this.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t + 1, (int)this.field_70163_u, (int)this.field_70161_v), Blocks.field_150480_ab.func_176223_P());
            }
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0 && this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t - 1, (int)this.field_70163_u, (int)this.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t - 1, (int)this.field_70163_u, (int)this.field_70161_v), Blocks.field_150480_ab.func_176223_P());
            }
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0 && this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u + 1, (int)this.field_70161_v), Blocks.field_150480_ab.func_176223_P());
            }
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0 && this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u - 1, (int)this.field_70161_v)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u - 1, (int)this.field_70161_v), Blocks.field_150480_ab.func_176223_P());
            }
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0 && this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v + 1)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v + 1), Blocks.field_150480_ab.func_176223_P());
            }
            if (this.field_70170_p.field_73012_v.nextInt(3) == 0 && this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v - 1)).func_177230_c() == Blocks.field_150350_a) {
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v - 1), Blocks.field_150480_ab.func_176223_P());
            }
        }
        if (this.config.emp > 0) {
            ExplosionNukeGeneric.empBlast(this.field_70170_p, (int)(this.field_70165_t + 0.5), (int)(this.field_70163_u + 0.5), (int)(this.field_70161_v + 0.5), this.config.emp);
        }
        if (this.config.emp > 3 && !this.field_70170_p.field_72995_K) {
            EntityEMPBlast cloud = new EntityEMPBlast(this.field_70170_p, this.config.emp);
            cloud.field_70165_t = this.field_70165_t;
            cloud.field_70163_u = this.field_70163_u + 0.5;
            cloud.field_70161_v = this.field_70161_v;
            this.field_70170_p.func_72838_d((Entity)cloud);
        }
        if (this.config.jolt > 0.0 && !this.field_70170_p.field_72995_K) {
            ExplosionLarge.jolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.config.jolt, 150, 0.25);
        }
        if (this.config.explosive > 0.0f && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.config.explosive, this.config.incendiary > 0, this.config.blockDamage);
        }
        if (this.config.shrapnel > 0 && !this.field_70170_p.field_72995_K) {
            ExplosionLarge.spawnShrapnels(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.config.shrapnel);
        }
        if (this.config.chlorine > 0 && !this.field_70170_p.field_72995_K) {
            ExplosionChaos.spawnChlorine(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.config.chlorine, 1.5, 0);
            this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, SoundEvents.field_187646_bt, SoundCategory.HOSTILE, 5.0f, 2.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.8f, true);
        }
        if (this.config.rainbow > 0 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 100.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, true);
            EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(this.field_70170_p);
            entity.field_70165_t = this.field_70165_t;
            entity.field_70163_u = this.field_70163_u;
            entity.field_70161_v = this.field_70161_v;
            entity.destructionRange = this.config.rainbow;
            entity.speed = 25;
            entity.coefficient = 1.0f;
            entity.waste = false;
            this.field_70170_p.func_72838_d((Entity)entity);
            EntityCloudFleijaRainbow cloud = new EntityCloudFleijaRainbow(this.field_70170_p, this.config.rainbow);
            cloud.field_70165_t = this.field_70165_t;
            cloud.field_70163_u = this.field_70163_u;
            cloud.field_70161_v = this.field_70161_v;
            this.field_70170_p.func_72838_d((Entity)cloud);
        }
        if (this.config.nuke > 0 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_70170_p, this.config.nuke, this.field_70165_t, this.field_70163_u, this.field_70161_v).mute());
            if (BombConfig.enableNukeClouds) {
                if (MainRegistry.polaroidID == 11 || this.field_70146_Z.nextInt(100) == 0) {
                    EntityNukeTorex.statFacBale(this.field_70170_p, (double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 5, (double)pos.func_177952_p() + 0.5, this.config.nuke);
                } else {
                    EntityNukeTorex.statFac(this.field_70170_p, (double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 5, (double)pos.func_177952_p() + 0.5, this.config.nuke);
                }
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, HBMSoundHandler.mukeExplosion, SoundCategory.HOSTILE, 15.0f, 1.0f);
        }
        if (this.config.destroysBlocks && !this.field_70170_p.field_72995_K) {
            if (blockstate.func_185887_b(this.field_70170_p, pos) <= 120.0f) {
                this.field_70170_p.func_175655_b(pos, false);
            }
        } else if (this.config.doesBreakGlass && !this.field_70170_p.field_72995_K) {
            if (block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co) {
                this.field_70170_p.func_175655_b(pos, false);
            }
            if (block == ModBlocks.red_barrel) {
                ((RedBarrel)ModBlocks.red_barrel).explode(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
    }

    private void onRicochet(BlockPos pos) {
        if (this.config.bRicochet != null) {
            this.config.bRicochet.behaveBlockRicochet(this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    private void onEntityImpact(Entity e, RayTraceResult rt) {
        if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
            return;
        }
        this.onEntityHurt(e, rt, false);
        this.onBlockImpact(new BlockPos(e), rt);
        if (this.config.bHit != null) {
            this.config.bHit.behaveEntityHit(this, e);
        }
    }

    private void onEntityHurt(Entity e, RayTraceResult rt, boolean doVFX) {
        if (doVFX) {
            this.doHitVFX(null, rt);
        }
        if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
            return;
        }
        if (this.config.bHurt != null) {
            this.config.bHurt.behaveEntityHurt(this, e);
        }
        if (this.config.incendiary > 0 && !this.field_70170_p.field_72995_K) {
            e.func_70015_d(this.config.incendiary);
        }
        if (this.config.leadChance > 0 && !this.field_70170_p.field_72995_K && this.field_70170_p.field_73012_v.nextInt(100) < this.config.leadChance && e instanceof EntityLivingBase) {
            ((EntityLivingBase)e).func_70690_d(new PotionEffect((Potion)HbmPotion.lead, 200, 0));
        }
        if (e instanceof EntityLivingBase && this.config.effects != null && !this.config.effects.isEmpty() && !this.field_70170_p.field_72995_K) {
            for (PotionEffect effect : this.config.effects) {
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(effect));
            }
        }
        if (this.config.instakill && e instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
            ((EntityLivingBase)e).func_70606_j(0.0f);
            if (!(e instanceof EntityPlayer) || !((EntityPlayer)e).field_71075_bZ.field_75098_d && !((EntityPlayer)e).func_175149_v()) {
                ((EntityLivingBase)e).func_70606_j(0.0f);
            }
        }
        if (this.config.caustic > 0 && e instanceof EntityPlayer) {
            ArmorUtil.damageSuit((EntityPlayer)e, 0, this.config.caustic);
            ArmorUtil.damageSuit((EntityPlayer)e, 1, this.config.caustic);
            ArmorUtil.damageSuit((EntityPlayer)e, 2, this.config.caustic);
            ArmorUtil.damageSuit((EntityPlayer)e, 3, this.config.caustic);
        }
    }

    public float func_70047_e() {
        return 0.0f;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        int cfg = nbt.func_74762_e("config");
        this.config = BulletConfigSyncingUtil.pullConfig(cfg);
        if (this.config == null) {
            this.func_70106_y();
            return;
        }
        this.func_184212_Q().func_187227_b(BULLETCONFIG, (Object)cfg);
        this.func_184212_Q().func_187227_b(STYLE, (Object)nbt.func_74762_e("overrideStyle"));
        this.func_184212_Q().func_187227_b(TRAIL, (Object)this.config.trail);
        this.overrideDamage = nbt.func_74760_g("damage");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("config", ((Integer)this.func_184212_Q().func_187225_a(BULLETCONFIG)).intValue());
        nbt.func_74768_a("overrideStyle", ((Integer)this.func_184212_Q().func_187225_a(STYLE)).intValue());
        nbt.func_74776_a("damage", this.overrideDamage);
    }
}

