/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.EntityGrenadeTau;
import com.hbm.blocks.generic.RedBarrel;
import com.hbm.config.CompatibilityConfig;
import com.hbm.entity.mob.EntityNuclearCreeper;
import com.hbm.entity.particle.EntityBSmokeFX;
import com.hbm.entity.projectile.EntityBoxcar;
import com.hbm.handler.ArmorUtil;
import com.hbm.items.ModItems;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.ParticleBurstPacket;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBullet
extends Entity
implements IProjectile {
    private static final DataParameter<Boolean> TAU = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHOPPER = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CRITICAL = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187198_h);
    private double prevMotionX;
    private double prevMotionY;
    private double prevMotionZ;
    private int field_145791_d = -1;
    private int field_145792_e = -1;
    private int field_145789_f = -1;
    public double gravity = 0.0;
    private Block field_145790_g;
    private IBlockState test_blockstate;
    private int inData;
    private boolean inGround;
    public int canBePickedUp;
    public int arrowShake;
    public Entity shootingEntity;
    private int ticksInGround;
    public double damage;
    private int knockbackStrength;
    private boolean instakill = false;
    private boolean rad = false;
    public boolean antidote = false;
    public boolean pip = false;
    public boolean field_190534_ay = false;

    public EntityBullet(World worldIn) {
        super(worldIn);
        if (worldIn.field_72995_K) {
            EntityBullet.func_184227_b((double)10.0);
        }
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBullet(World w, double x, double y, double z) {
        this(w);
        this.func_70107_b(x, y, z);
        this.func_181013_g(0.0f);
    }

    public EntityBullet(World w, EntityLivingBase shooter, EntityLivingBase shootingAt, float velocity, float innacuracy) {
        this(w);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = shootingAt.field_70165_t - shooter.field_70165_t;
        double d1 = shootingAt.func_174813_aQ().field_72338_b + (double)(shootingAt.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = shootingAt.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            this.func_181013_g(0.0f);
            this.setThrowableHeading(d0, d1, d2, velocity, innacuracy);
        }
    }

    public EntityBullet(World world, EntityLivingBase shooter, float velocity, int dmgMin, int dmgMax, boolean instakill, boolean rad, EnumHand hand) {
        this(world);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        if (hand == EnumHand.MAIN_HAND) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        } else {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_181013_g(0.0f);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
        this.instakill = instakill;
        this.rad = rad;
    }

    public EntityBullet(World world, EntityLivingBase shooter, float velocity, EnumHand hand) {
        this(world);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        if (hand == EnumHand.MAIN_HAND) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        } else {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_181013_g(0.0f);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.setThrowableHeading2(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
    }

    public EntityBullet(World world, EntityLivingBase shooter, float velocity, int dmgMin, int dmgMax, boolean instakill, String isTau, EnumHand hand) {
        this(world);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        if (hand == EnumHand.MAIN_HAND) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        } else {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
        this.setTau(isTau.equals("tauDay"));
        this.setChopper(isTau.equals("chopper"));
        this.setIsCritical(!isTau.equals("chopper"));
    }

    public EntityBullet(World world, EntityLivingBase shooter, float velocity, int dmgMin, int dmgMax, boolean instakill, String isTau, EntityGrenadeTau grenade) {
        this(world);
        this.shootingEntity = shooter;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(grenade.field_70165_t, grenade.field_70163_u + (double)grenade.func_70047_e(), grenade.field_70161_v, grenade.field_70177_z, grenade.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
        this.setTau(isTau.equals("tauDay"));
        this.setIsCritical(true);
    }

    public EntityBullet(World world, int x, int y, int z, double mx, double my, double mz, double grav) {
        super(world);
        this.field_70165_t = (float)x + 0.5f;
        this.field_70163_u = (float)y + 0.5f;
        this.field_70161_v = (float)z + 0.5f;
        this.field_70159_w = mx;
        this.field_70181_x = my;
        this.field_70179_y = mz;
        this.gravity = grav;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(CRITICAL, (Object)false);
        this.func_184212_Q().func_187214_a(TAU, (Object)false);
        this.func_184212_Q().func_187214_a(CHOPPER, (Object)false);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        if (this.field_70148_d) {
            this.prevMotionX = this.field_70159_w;
            this.prevMotionY = this.field_70181_x;
            this.prevMotionZ = this.field_70179_y;
        }
        if (this.getIsCritical()) {
            this.field_70159_w = this.prevMotionX;
            this.field_70181_x = this.prevMotionY;
            this.field_70179_y = this.prevMotionZ;
        }
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        }
        BlockPos bulletTilePos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        IBlockState blockstate = this.field_70170_p.func_180495_p(bulletTilePos);
        Block block = blockstate.func_177230_c();
        if (blockstate.func_185904_a() != Material.field_151579_a) {
            AxisAlignedBB axisalignedbb = blockstate.func_185890_d((IBlockAccess)this.field_70170_p, bulletTilePos);
            if (axisalignedbb != null && axisalignedbb != Block.field_185506_k && axisalignedbb.func_186670_a(bulletTilePos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)) && !this.getIsCritical()) {
                this.inGround = true;
            }
            if (block == ModBlocks.red_barrel) {
                ((RedBarrel)block).explode(this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            }
            if (block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block == Blocks.field_150410_aZ || block == Blocks.field_150397_co) {
                this.field_70170_p.func_175698_g(new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f));
                PacketDispatcher.wrapper.sendToAll((IMessage)new ParticleBurstPacket(this.field_145791_d, this.field_145792_e, this.field_145789_f, Block.func_149682_b((Block)block), block.func_176201_c(blockstate)));
                this.field_70170_p.func_184134_a((double)this.field_145791_d, (double)this.field_145792_e, (double)this.field_145789_f, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround && !this.getIsCritical()) {
            this.func_70106_y();
        } else {
            float f1;
            int i;
            Vec3d vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
            vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            vec31 = new Vec3d(this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x, this.field_70161_v - this.field_70179_y);
            if (movingobjectposition != null) {
                vec3 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(Math.abs(this.field_70159_w), Math.abs(this.field_70181_x), Math.abs(this.field_70179_y)).func_186662_g(1.0));
            double d0 = 0.0;
            for (i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityBullet && ((EntityBullet)entity1).shootingEntity == this.shootingEntity || !entity1.func_70067_L() || entity1 == this.shootingEntity) continue;
                f1 = 0.3f;
                AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_186662_g((double)f1);
                RayTraceResult movingobjectposition1 = axisalignedbb1.func_72327_a(vec31, vec3);
                if (movingobjectposition1 == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            if (movingobjectposition != null && CompatibilityConfig.isWarDim(this.field_70170_p)) {
                if (movingobjectposition.field_72308_g != null) {
                    if (!(movingobjectposition.field_72308_g instanceof EntityItemFrame) || movingobjectposition.field_72308_g instanceof EntityItemFrame && (((EntityItemFrame)movingobjectposition.field_72308_g).func_82335_i() == null || ((EntityItemFrame)movingobjectposition.field_72308_g).func_82335_i() != null && ((EntityItemFrame)movingobjectposition.field_72308_g).func_82335_i().func_77973_b() != ModItems.flame_pony)) {
                        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                        int k = MathHelper.func_76143_f((double)((double)f2 * this.damage));
                        if (this.getIsCritical()) {
                            k += this.field_70146_Z.nextInt(k / 2 + 2);
                        }
                        DamageSource damagesource = null;
                        if (!this.getIsCritical() && !this.getIsChopper()) {
                            damagesource = this.shootingEntity == null ? ModDamageSource.causeBulletDamage(this, (Entity)this) : ModDamageSource.causeBulletDamage(this, this.shootingEntity);
                        } else if (!this.getIsChopper()) {
                            damagesource = this.shootingEntity == null ? ModDamageSource.causeTauDamage(this, this) : ModDamageSource.causeTauDamage(this, this.shootingEntity);
                        } else if (!this.getIsCritical()) {
                            damagesource = this.shootingEntity == null ? ModDamageSource.causeDisplacementDamage(this, this) : ModDamageSource.causeDisplacementDamage(this, this.shootingEntity);
                        }
                        if (this.field_190534_ay || this.func_70027_ad() && !(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                            movingobjectposition.field_72308_g.func_70015_d(5);
                        }
                        if (movingobjectposition.field_72308_g.func_70097_a(damagesource, (float)this.damage)) {
                            if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                                float f4;
                                EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                                if (!(!this.rad || entitylivingbase instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityLivingBase)((EntityPlayer)entitylivingbase)))) {
                                    EntityNuclearCreeper creep;
                                    if (entitylivingbase instanceof EntityCreeper) {
                                        creep = new EntityNuclearCreeper(this.field_70170_p);
                                        creep.func_70012_b(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, entitylivingbase.field_70177_z, entitylivingbase.field_70125_A);
                                        if (!entitylivingbase.field_70128_L && !this.field_70170_p.field_72995_K) {
                                            this.field_70170_p.func_72838_d((Entity)creep);
                                        }
                                        entitylivingbase.func_70106_y();
                                    } else if (entitylivingbase instanceof EntityVillager) {
                                        creep = new EntityZombie(this.field_70170_p);
                                        creep.func_70012_b(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, entitylivingbase.field_70177_z, entitylivingbase.field_70125_A);
                                        entitylivingbase.func_70106_y();
                                        if (!this.field_70170_p.field_72995_K) {
                                            this.field_70170_p.func_72838_d((Entity)creep);
                                        }
                                    } else if (entitylivingbase instanceof EntityLivingBase && !(entitylivingbase instanceof EntityNuclearCreeper) && !(entitylivingbase instanceof EntityMooshroom) && !(entitylivingbase instanceof EntityZombie)) {
                                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 2400, 2));
                                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 20, 4));
                                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1200, 1));
                                    }
                                }
                                if (this.antidote) {
                                    entitylivingbase.func_70674_bp();
                                }
                                if (this.knockbackStrength > 0 && (f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                    movingobjectposition.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f4, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f4);
                                }
                                if (this.shootingEntity != null && this.shootingEntity instanceof EntityLivingBase) {
                                    EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                                    EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                                }
                                if (this.shootingEntity != null && movingobjectposition.field_72308_g != this.shootingEntity && movingobjectposition.field_72308_g instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                                    ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                                }
                                if (this.pip && !this.field_70170_p.field_72995_K) {
                                    EntityBoxcar pippo = new EntityBoxcar(this.field_70170_p);
                                    pippo.field_70165_t = movingobjectposition.field_72308_g.field_70165_t;
                                    pippo.field_70163_u = movingobjectposition.field_72308_g.field_70163_u + 50.0;
                                    pippo.field_70161_v = movingobjectposition.field_72308_g.field_70161_v;
                                    for (int j = 0; j < 50; ++j) {
                                        EntityBSmokeFX fx = new EntityBSmokeFX(this.field_70170_p, pippo.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 4.0, pippo.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * 12.0, pippo.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 4.0, 0.0, 0.0, 0.0);
                                        this.field_70170_p.func_72838_d((Entity)fx);
                                    }
                                    this.field_70170_p.func_72838_d((Entity)pippo);
                                    this.field_70170_p.func_184148_a(null, movingobjectposition.field_72308_g.field_70165_t, movingobjectposition.field_72308_g.field_70163_u + 50.0, movingobjectposition.field_72308_g.field_70161_v, HBMSoundHandler.trainHorn, SoundCategory.HOSTILE, 10000.0f, 1.0f);
                                }
                            }
                            if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                                if (!this.field_70170_p.field_72995_K && this.instakill && !(movingobjectposition.field_72308_g instanceof EntityPlayer) && movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                                    ((EntityLivingBase)movingobjectposition.field_72308_g).func_70606_j(0.0f);
                                }
                                if (!this.getIsCritical()) {
                                    // empty if block
                                }
                            }
                        } else if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                            try {
                                Field lastDamage = ReflectionHelper.findField(EntityLivingBase.class, (String)"lastDamage", (String)"field_110153_bc");
                                float dmg = (float)this.damage + lastDamage.getFloat(movingobjectposition.field_72308_g);
                                movingobjectposition.field_72308_g.func_70097_a(damagesource, dmg);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        this.func_70106_y();
                    }
                } else if (!this.getIsCritical()) {
                    this.field_145791_d = movingobjectposition.func_178782_a().func_177958_n();
                    this.field_145792_e = movingobjectposition.func_178782_a().func_177956_o();
                    this.field_145789_f = movingobjectposition.func_178782_a().func_177952_p();
                    BlockPos pos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                    this.test_blockstate = this.field_70170_p.func_180495_p(pos);
                    this.field_145790_g = this.test_blockstate.func_177230_c();
                    this.inData = this.field_145790_g.func_176201_c(this.test_blockstate);
                    this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                    this.inGround = true;
                    this.arrowShake = 7;
                    if (this.test_blockstate.func_185904_a() != Material.field_151579_a) {
                        this.field_145790_g.func_180634_a(this.field_70170_p, pos, this.test_blockstate, (Entity)this);
                    }
                }
            }
            if (this.field_70170_p.field_72995_K && this.getIsCritical()) {
                for (i = 0; i < 8; ++i) {
                    if (!this.getIsTau()) {
                        this.field_70170_p.func_175682_a(EnumParticleTypes.FIREWORKS_SPARK, true, this.field_70165_t + this.field_70159_w * (double)i / 8.0, this.field_70163_u + this.field_70181_x * (double)i / 8.0, this.field_70161_v + this.field_70179_y * (double)i / 8.0, 0.0, 0.0, 0.0, new int[0]);
                        continue;
                    }
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + this.field_70159_w * (double)i / 8.0, this.field_70163_u + this.field_70181_x * (double)i / 8.0, this.field_70161_v + this.field_70179_y * (double)i / 8.0, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            float f3 = 0.99f;
            f1 = 0.05f;
            if (this.field_70170_p.field_72995_K && this.func_70090_H()) {
                for (int l = 0; l < 4; ++l) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f3 = 0.8f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f3;
            this.field_70181_x *= (double)f3;
            this.field_70179_y *= (double)f3;
            this.field_70181_x -= this.gravity;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
        if (this.field_70173_aa > 250) {
            this.func_70106_y();
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && entityIn.field_71075_bZ.field_75098_d;
            if (this.canBePickedUp == 1 && !entityIn.field_71071_by.func_70441_a(new ItemStack(ModItems.gun_rpg_ammo, 1))) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int p_70240_1_) {
        this.knockbackStrength = p_70240_1_;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setIsCritical(boolean critical) {
        this.func_184212_Q().func_187227_b(CRITICAL, (Object)critical);
    }

    public void setTau(boolean tau) {
        this.func_184212_Q().func_187227_b(TAU, (Object)tau);
    }

    public void setChopper(boolean isChopper) {
        this.func_184212_Q().func_187227_b(CHOPPER, (Object)isChopper);
    }

    public boolean getIsCritical() {
        return (Boolean)this.func_184212_Q().func_187225_a(CRITICAL);
    }

    public boolean getIsTau() {
        return (Boolean)this.func_184212_Q().func_187225_a(TAU);
    }

    public boolean getIsChopper() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHOPPER);
    }

    public float func_70013_c() {
        if (this.getIsCritical() || this.getIsChopper()) {
            return 1.0f;
        }
        return super.func_70013_c();
    }

    public int func_70070_b() {
        if (this.getIsCritical() || this.getIsChopper()) {
            return 0xF000F0;
        }
        return super.func_70070_b();
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        this.setThrowableHeading(x, y, z, velocity, inaccuracy);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_145791_d = compound.func_74762_e("xTile");
        this.field_145792_e = compound.func_74762_e("yTile");
        this.field_145789_f = compound.func_74762_e("zTile");
        this.ticksInGround = compound.func_74762_e("life");
        this.field_145790_g = Block.func_149729_e((int)compound.func_74762_e("inTile"));
        this.inData = compound.func_74762_e("inData") & 0xFF;
        this.test_blockstate = this.field_145790_g == null ? null : this.field_145790_g.func_176203_a(this.inData);
        this.arrowShake = compound.func_74762_e("shake") & 0xFF;
        boolean bl = this.inGround = compound.func_74762_e("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.canBePickedUp = compound.func_74762_e("pickup");
        } else if (compound.func_150297_b("player", 99)) {
            this.canBePickedUp = compound.func_74767_n("player") ? 1 : 0;
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.field_145791_d);
        compound.func_74768_a("yTile", this.field_145792_e);
        compound.func_74768_a("zTile", this.field_145789_f);
        compound.func_74768_a("life", this.ticksInGround);
        compound.func_74768_a("inTile", Block.func_149682_b((Block)this.field_145790_g));
        compound.func_74768_a("inData", this.inData);
        compound.func_74768_a("shake", this.arrowShake);
        compound.func_74768_a("inGround", this.inGround ? 1 : 0);
        compound.func_74768_a("pickup", this.canBePickedUp);
        compound.func_74780_a("damage", this.damage);
    }

    public void setThrowableHeading(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void setThrowableHeading2(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 0.04249999983236194 * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 0.04249999983236194 * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 0.04249999983236194 * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public boolean func_70072_I() {
        double x = this.field_70159_w;
        double y = this.field_70181_x;
        double z = this.field_70179_y;
        boolean b = super.func_70072_I();
        if (this.getIsCritical()) {
            this.field_70159_w = x;
            this.field_70181_x = y;
            this.field_70179_y = z;
        }
        return b;
    }

    public boolean func_96092_aw() {
        return !this.getIsCritical();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBullet.func_184183_bd()) * d0;
    }
}

